/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import io.graphenee.core.model.BeanFault;
import io.graphenee.core.model.api.GxDataService;
import io.graphenee.core.model.bean.GxEmailTemplateBean;
import io.graphenee.core.model.bean.GxNamespaceBean;
import io.graphenee.core.vaadin.GxEmailTemplateForm;
import io.graphenee.vaadin.AbstractEntityListPanel;
import io.graphenee.vaadin.TRAbstractForm;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.vaadin.viritin.button.MButton;

@SpringComponent
@Scope(value="prototype")
public class GxEmailTemplateListPanel
extends AbstractEntityListPanel<GxEmailTemplateBean> {
    @Autowired
    GxDataService dataService;
    @Autowired
    GxEmailTemplateForm editorForm;
    public static final int ACTIVE = 1;
    public static final int INACTIVE = 2;
    private Integer fetchMode = 1;
    private GxNamespaceBean namespace;

    public GxEmailTemplateListPanel() {
        super(GxEmailTemplateBean.class);
    }

    protected void addButtonsToSecondaryToolbar(AbstractOrderedLayout toolbar) {
        MButton activeButton = new MButton("Active");
        MButton inactiveButton = new MButton("Inactive");
        activeButton.addClickListener((Button.ClickListener & Serializable)event -> {
            activeButton.setEnabled(false);
            inactiveButton.setEnabled(true);
            this.fetchMode = 1;
            this.refresh();
        });
        inactiveButton.addClickListener((Button.ClickListener & Serializable)event -> {
            activeButton.setEnabled(true);
            inactiveButton.setEnabled(false);
            this.fetchMode = 2;
            this.refresh();
        });
        activeButton.setEnabled(false);
        inactiveButton.setEnabled(true);
        CssLayout activeInactiveLayout = new CssLayout(new Component[]{activeButton, inactiveButton});
        activeInactiveLayout.setStyleName("v-component-group");
        activeInactiveLayout.setCaption("Template Status");
        toolbar.addComponent((Component)activeInactiveLayout);
        toolbar.setExpandRatio((Component)activeInactiveLayout, 1.0f);
    }

    protected boolean onSaveEntity(GxEmailTemplateBean entity) {
        this.dataService.save(entity);
        return true;
    }

    protected boolean onDeleteEntity(GxEmailTemplateBean entity) {
        this.dataService.delete(entity);
        return true;
    }

    protected String panelCaption() {
        return null;
    }

    protected <F> List<GxEmailTemplateBean> fetchEntities(F filter) {
        if (filter instanceof GxNamespaceBean) {
            this.namespace = (GxNamespaceBean)filter;
            switch (this.fetchMode) {
                case 1: {
                    return this.dataService.findEmailTemplateByNamespaceActive(this.namespace);
                }
                case 2: {
                    return this.dataService.findEmailTemplateByNamespaceInactive(this.namespace);
                }
            }
        }
        return super.fetchEntities(filter);
    }

    protected List<GxEmailTemplateBean> fetchEntities() {
        switch (this.fetchMode) {
            case 1: {
                return this.dataService.findEmailTemplateActive();
            }
            case 2: {
                return this.dataService.findEmailTemplateInactive();
            }
        }
        return null;
    }

    protected String[] visibleProperties() {
        return new String[]{"templateCode", "templateName", "subject"};
    }

    protected TRAbstractForm<GxEmailTemplateBean> editorForm() {
        return this.editorForm;
    }

    protected void onAddButtonClick(GxEmailTemplateBean entity) {
        if (this.namespace != null) {
            entity.setNamespaceBeanFault(BeanFault.beanFault((Object)this.namespace.getOid(), (Object)this.namespace));
        }
        super.onAddButtonClick((Object)entity);
    }
}

