/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.data.Property;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.ClickableRenderer;
import com.vaadin.ui.renderers.Renderer;
import io.graphenee.core.model.BeanFault;
import io.graphenee.core.model.api.GxDataService;
import io.graphenee.core.model.bean.GxNamespaceBean;
import io.graphenee.core.model.bean.GxRegisteredDeviceBean;
import io.graphenee.core.vaadin.GxRegisteredDeviceForm;
import io.graphenee.vaadin.AbstractEntityListPanel;
import io.graphenee.vaadin.TRAbstractForm;
import io.graphenee.vaadin.renderer.BooleanRenderer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@SpringComponent
@Scope(value="prototype")
public class GxRegisteredDeviceListPanel
extends AbstractEntityListPanel<GxRegisteredDeviceBean> {
    private static final long serialVersionUID = 1L;
    @Autowired
    GxDataService dataService;
    @Autowired
    GxRegisteredDeviceForm editorForm;
    private ComboBox namespaceComboBox;
    private GxNamespaceBean namespaceBean;

    public GxRegisteredDeviceListPanel() {
        super(GxRegisteredDeviceBean.class);
    }

    protected boolean onSaveEntity(GxRegisteredDeviceBean entity) {
        this.dataService.createOrUpdate(entity);
        return true;
    }

    protected boolean onDeleteEntity(GxRegisteredDeviceBean entity) {
        this.dataService.delete(entity);
        return true;
    }

    protected String panelCaption() {
        return null;
    }

    protected List<GxRegisteredDeviceBean> fetchEntities() {
        if (this.namespaceBean != null) {
            return this.dataService.findRegisteredDeviceByNamespace(this.namespaceBean);
        }
        return this.dataService.findRegisteredDevice();
    }

    protected <F> List<GxRegisteredDeviceBean> fetchEntities(F filter) {
        if (filter instanceof GxNamespaceBean) {
            return this.dataService.findRegisteredDeviceByNamespace((GxNamespaceBean)filter);
        }
        return super.fetchEntities(filter);
    }

    protected String[] visibleProperties() {
        return new String[]{"ownerId", "systemName", "brand", "isTablet", "isActive", "deviceToken"};
    }

    protected TRAbstractForm<GxRegisteredDeviceBean> editorForm() {
        return this.editorForm;
    }

    protected void addButtonsToSecondaryToolbar(AbstractOrderedLayout toolbar) {
        this.namespaceComboBox = new ComboBox("Namespace");
        this.namespaceComboBox.setTextInputAllowed(false);
        this.namespaceComboBox.addItems((Collection)this.dataService.findNamespace());
        this.namespaceComboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.refresh(event.getProperty().getValue()));
        toolbar.addComponent((Component)this.namespaceComboBox);
    }

    protected void preEdit(GxRegisteredDeviceBean item) {
        if (item.getOid() == null) {
            GxNamespaceBean selectedNamespaceBean;
            GxNamespaceBean gxNamespaceBean = selectedNamespaceBean = this.namespaceBean != null ? this.namespaceBean : (GxNamespaceBean)this.namespaceComboBox.getValue();
            if (selectedNamespaceBean != null) {
                item.setNamespaceFault(BeanFault.beanFault((Object)selectedNamespaceBean.getOid(), (Object)selectedNamespaceBean));
            }
        }
    }

    protected void postBuild() {
        super.postBuild();
        for (Grid.Column column : this.entityGrid().getColumns()) {
            if (!column.getPropertyId().toString().matches("(isActive)")) continue;
            column.setRenderer((Renderer)new BooleanRenderer((ClickableRenderer.RendererClickListener & Serializable)event -> this.onGridItemClicked((GxRegisteredDeviceBean)event.getItemId(), column.getPropertyId().toString())), (Converter)BooleanRenderer.SWITCH_CONVERTER);
        }
    }

    protected void onGridItemClicked(GxRegisteredDeviceBean item, String propertyId) {
        if (propertyId.equals("isActive")) {
            item.setIsActive(Boolean.valueOf(item.getIsActive() == false));
            this.dataService.createOrUpdate(item);
            this.entityGrid().refreshRow((Object)item);
            return;
        }
        super.onGridItemClicked((Object)item, propertyId);
    }

    public void initializeWithNamespace(GxNamespaceBean namespaceBean) {
        this.namespaceBean = namespaceBean;
        this.namespaceComboBox.setVisible(namespaceBean == null);
    }

    protected boolean isGridCellFilterEnabled() {
        return true;
    }
}

