/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.spring.annotation.SpringComponent;
import io.graphenee.core.model.BeanFault;
import io.graphenee.core.model.api.GxDataService;
import io.graphenee.core.model.bean.GxNamespaceBean;
import io.graphenee.core.model.bean.GxResourceBean;
import io.graphenee.core.vaadin.GxResourceForm;
import io.graphenee.vaadin.AbstractEntityListPanel;
import io.graphenee.vaadin.TRAbstractForm;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@SpringComponent
@Scope(value="prototype")
public class GxResourceListPanel
extends AbstractEntityListPanel<GxResourceBean> {
    private GxNamespaceBean namespace;
    @Autowired
    GxDataService gxDataService;
    @Autowired
    GxResourceForm editorForm;

    public GxResourceListPanel() {
        super(GxResourceBean.class);
    }

    protected boolean onSaveEntity(GxResourceBean entity) {
        this.gxDataService.createOrUpdate(entity);
        return true;
    }

    protected boolean onDeleteEntity(GxResourceBean entity) {
        this.gxDataService.delete(entity);
        return true;
    }

    protected String panelCaption() {
        return null;
    }

    protected List<GxResourceBean> fetchEntities() {
        return null;
    }

    protected <F> List<GxResourceBean> fetchEntities(F filter) {
        this.namespace = (GxNamespaceBean)filter;
        return this.gxDataService.findResourceByNamespace(this.namespace);
    }

    protected String[] visibleProperties() {
        return new String[]{"resourceName", "resourceDescription", "isActive"};
    }

    protected TRAbstractForm<GxResourceBean> editorForm() {
        return this.editorForm;
    }

    protected void onAddButtonClick(GxResourceBean entity) {
        if (this.namespace != null) {
            entity.setGxNamespaceBeanFault(BeanFault.beanFault((Object)this.namespace.getOid(), (Object)this.namespace));
        }
        super.onAddButtonClick((Object)entity);
    }

    protected boolean shouldShowDeleteConfirmation() {
        return true;
    }
}

