/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.spring.annotation.SpringComponent;
import io.graphenee.core.model.api.GxDataService;
import io.graphenee.core.model.bean.GxStateBean;
import io.graphenee.core.vaadin.GxStateForm;
import io.graphenee.vaadin.AbstractEntityListPanel;
import io.graphenee.vaadin.TRAbstractForm;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@SpringComponent
@Scope(value="prototype")
public class GxStateListPanel
extends AbstractEntityListPanel<GxStateBean> {
    @Autowired
    GxDataService dataService;
    @Autowired
    GxStateForm editorForm;

    public GxStateListPanel() {
        super(GxStateBean.class);
    }

    protected boolean onSaveEntity(GxStateBean entity) {
        this.dataService.createOrUpdate(entity);
        return true;
    }

    protected boolean onDeleteEntity(GxStateBean entity) {
        this.dataService.delete(entity);
        return true;
    }

    protected String panelCaption() {
        return "Countries";
    }

    protected List<GxStateBean> fetchEntities() {
        return this.dataService.findState();
    }

    protected String[] visibleProperties() {
        return new String[]{"stateName", "stateCode", "countryName"};
    }

    protected TRAbstractForm<GxStateBean> editorForm() {
        return this.editorForm;
    }

    protected boolean isGridCellFilterEnabled() {
        return true;
    }
}

