/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import io.grpc.alts.internal.AltsHandshakerOptions;
import io.grpc.alts.internal.TransportSecurityCommon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class AltsClientOptions
extends AltsHandshakerOptions {
    @Nullable
    private final String targetName;
    private final List<String> targetServiceAccounts;

    private AltsClientOptions(Builder builder) {
        super(builder.rpcProtocolVersions);
        this.targetName = builder.targetName;
        this.targetServiceAccounts = Collections.unmodifiableList(new ArrayList(builder.targetServiceAccounts));
    }

    public String getTargetName() {
        return this.targetName;
    }

    public List<String> getTargetServiceAccounts() {
        return this.targetServiceAccounts;
    }

    public static final class Builder {
        @Nullable
        private String targetName;
        @Nullable
        private TransportSecurityCommon.RpcProtocolVersions rpcProtocolVersions;
        private ArrayList<String> targetServiceAccounts = new ArrayList();

        public Builder setTargetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public Builder setRpcProtocolVersions(TransportSecurityCommon.RpcProtocolVersions rpcProtocolVersions) {
            this.rpcProtocolVersions = rpcProtocolVersions;
            return this;
        }

        public Builder addTargetServiceAccount(String targetServiceAccount) {
            this.targetServiceAccounts.add(targetServiceAccount);
            return this;
        }

        public AltsClientOptions build() {
            return new AltsClientOptions(this);
        }
    }
}

