/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.android;

import android.net.LocalSocketAddress;
import io.grpc.android.UdsSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;

class UdsSocketFactory
extends SocketFactory {
    private final LocalSocketAddress localSocketAddress;

    public UdsSocketFactory(String path, LocalSocketAddress.Namespace namespace) {
        this.localSocketAddress = new LocalSocketAddress(path, namespace);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.create();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createAndConnect();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createAndConnect();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createAndConnect();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.createAndConnect();
    }

    private Socket create() {
        return new UdsSocket(this.localSocketAddress);
    }

    private Socket createAndConnect() throws IOException {
        Socket socket = this.create();
        InetSocketAddress unusedAddress = new InetSocketAddress(0);
        socket.connect(unusedAddress);
        return socket;
    }
}

