/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.android;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.InlineMe;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.InternalManagedChannelProvider;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ManagedChannelProvider;
import io.grpc.MethodDescriptor;
import io.grpc.internal.GrpcUtil;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class AndroidChannelBuilder
extends ForwardingChannelBuilder<AndroidChannelBuilder> {
    private static final String LOG_TAG = "AndroidChannelBuilder";
    @Nullable
    private static final ManagedChannelProvider OKHTTP_CHANNEL_PROVIDER = AndroidChannelBuilder.findOkHttp();
    private final ManagedChannelBuilder<?> delegateBuilder;
    @Nullable
    private Context context;

    private static ManagedChannelProvider findOkHttp() {
        ManagedChannelProvider provider;
        Class<ManagedChannelProvider> klass;
        Class<?> klassRaw;
        try {
            klassRaw = Class.forName("io.grpc.okhttp.OkHttpChannelProvider");
        }
        catch (ClassNotFoundException e) {
            Log.w((String)LOG_TAG, (String)"Failed to find OkHttpChannelProvider", (Throwable)e);
            return null;
        }
        try {
            klass = klassRaw.asSubclass(ManagedChannelProvider.class);
        }
        catch (ClassCastException e) {
            Log.w((String)LOG_TAG, (String)"Couldn't cast OkHttpChannelProvider to ManagedChannelProvider", (Throwable)e);
            return null;
        }
        try {
            provider = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)LOG_TAG, (String)"Failed to construct OkHttpChannelProvider", (Throwable)e);
            return null;
        }
        if (!InternalManagedChannelProvider.isAvailable((ManagedChannelProvider)provider)) {
            Log.w((String)LOG_TAG, (String)"OkHttpChannelProvider.isAvailable() returned false");
            return null;
        }
        return provider;
    }

    public static AndroidChannelBuilder forTarget(String target) {
        return new AndroidChannelBuilder(target);
    }

    public static AndroidChannelBuilder forAddress(String name, int port) {
        return AndroidChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)name, (int)port));
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6043")
    @InlineMe(replacement="AndroidChannelBuilder.usingBuilder(builder)", imports={"io.grpc.android.AndroidChannelBuilder"})
    public static AndroidChannelBuilder fromBuilder(ManagedChannelBuilder<?> builder) {
        return AndroidChannelBuilder.usingBuilder(builder);
    }

    public static AndroidChannelBuilder usingBuilder(ManagedChannelBuilder<?> builder) {
        return new AndroidChannelBuilder(builder);
    }

    private AndroidChannelBuilder(String target) {
        if (OKHTTP_CHANNEL_PROVIDER == null) {
            throw new UnsupportedOperationException("Unable to load OkHttpChannelProvider");
        }
        this.delegateBuilder = InternalManagedChannelProvider.builderForTarget((ManagedChannelProvider)OKHTTP_CHANNEL_PROVIDER, (String)target);
    }

    private AndroidChannelBuilder(ManagedChannelBuilder<?> delegateBuilder) {
        this.delegateBuilder = (ManagedChannelBuilder)Preconditions.checkNotNull(delegateBuilder, (Object)"delegateBuilder");
    }

    public AndroidChannelBuilder context(Context context) {
        this.context = context;
        return this;
    }

    protected ManagedChannelBuilder<?> delegate() {
        return this.delegateBuilder;
    }

    public ManagedChannel build() {
        return new AndroidChannel(this.delegateBuilder.build(), this.context);
    }

    @VisibleForTesting
    static final class AndroidChannel
    extends ManagedChannel {
        private final ManagedChannel delegate;
        @Nullable
        private final Context context;
        @Nullable
        private final ConnectivityManager connectivityManager;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private Runnable unregisterRunnable;

        @VisibleForTesting
        AndroidChannel(ManagedChannel delegate, @Nullable Context context) {
            this.delegate = delegate;
            this.context = context;
            if (context != null) {
                this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                try {
                    this.configureNetworkMonitoring();
                }
                catch (SecurityException e) {
                    Log.w((String)AndroidChannelBuilder.LOG_TAG, (String)"Failed to configure network monitoring. Does app have ACCESS_NETWORK_STATE permission?", (Throwable)e);
                }
            } else {
                this.connectivityManager = null;
            }
        }

        @GuardedBy(value="lock")
        private void configureNetworkMonitoring() {
            if (Build.VERSION.SDK_INT >= 24 && this.connectivityManager != null) {
                final DefaultNetworkCallback defaultNetworkCallback = new DefaultNetworkCallback();
                this.connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)defaultNetworkCallback);
                this.unregisterRunnable = new Runnable(){

                    @Override
                    @TargetApi(value=21)
                    public void run() {
                        connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)defaultNetworkCallback);
                    }
                };
            } else {
                final NetworkReceiver networkReceiver = new NetworkReceiver();
                IntentFilter networkIntentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
                this.context.registerReceiver((BroadcastReceiver)networkReceiver, networkIntentFilter);
                this.unregisterRunnable = new Runnable(){

                    @Override
                    @TargetApi(value=21)
                    public void run() {
                        context.unregisterReceiver((BroadcastReceiver)networkReceiver);
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterNetworkListener() {
            Object object = this.lock;
            synchronized (object) {
                if (this.unregisterRunnable != null) {
                    this.unregisterRunnable.run();
                    this.unregisterRunnable = null;
                }
            }
        }

        public ManagedChannel shutdown() {
            this.unregisterNetworkListener();
            return this.delegate.shutdown();
        }

        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        public ManagedChannel shutdownNow() {
            this.unregisterNetworkListener();
            return this.delegate.shutdownNow();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            return this.delegate.newCall(methodDescriptor, callOptions);
        }

        public String authority() {
            return this.delegate.authority();
        }

        public ConnectivityState getState(boolean requestConnection) {
            return this.delegate.getState(requestConnection);
        }

        public void notifyWhenStateChanged(ConnectivityState source, Runnable callback) {
            this.delegate.notifyWhenStateChanged(source, callback);
        }

        public void resetConnectBackoff() {
            this.delegate.resetConnectBackoff();
        }

        public void enterIdle() {
            this.delegate.enterIdle();
        }

        private class NetworkReceiver
        extends BroadcastReceiver {
            private boolean isConnected = false;

            private NetworkReceiver() {
            }

            public void onReceive(Context context, Intent intent) {
                ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = conn.getActiveNetworkInfo();
                boolean wasConnected = this.isConnected;
                boolean bl = this.isConnected = networkInfo != null && networkInfo.isConnected();
                if (this.isConnected && !wasConnected) {
                    AndroidChannel.this.delegate.enterIdle();
                }
            }
        }

        @TargetApi(value=24)
        private class DefaultNetworkCallback
        extends ConnectivityManager.NetworkCallback {
            private DefaultNetworkCallback() {
            }

            public void onAvailable(Network network) {
                AndroidChannel.this.delegate.enterIdle();
            }

            public void onBlockedStatusChanged(Network network, boolean blocked) {
                if (!blocked) {
                    AndroidChannel.this.delegate.enterIdle();
                }
            }
        }
    }
}

