/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ContextRunnable;
import io.grpc.internal.DelayedStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.NoopClientStream;
import io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import io.grpc.internal.SerializingExecutor;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClientCallImpl<ReqT, RespT>
extends ClientCall<ReqT, RespT>
implements Context.CancellationListener {
    private final MethodDescriptor<ReqT, RespT> method;
    private final Executor callExecutor;
    private final Context context;
    private final boolean unaryRequest;
    private final CallOptions callOptions;
    private ClientStream stream;
    private volatile ScheduledFuture<?> deadlineCancellationFuture;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private final ClientTransportProvider clientTransportProvider;
    private String userAgent;
    private ScheduledExecutorService deadlineCancellationExecutor;
    private Set<String> knownMessageEncodingRegistry;
    private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();

    ClientCallImpl(MethodDescriptor<ReqT, RespT> method, Executor executor, CallOptions callOptions, ClientTransportProvider clientTransportProvider, ScheduledExecutorService deadlineCancellationExecutor) {
        this.method = method;
        this.callExecutor = executor == MoreExecutors.directExecutor() ? new SerializeReentrantCallsDirectExecutor() : new SerializingExecutor(executor);
        this.context = Context.current();
        this.unaryRequest = method.getType() == MethodDescriptor.MethodType.UNARY || method.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.callOptions = callOptions;
        this.clientTransportProvider = clientTransportProvider;
        this.deadlineCancellationExecutor = deadlineCancellationExecutor;
    }

    @Override
    public void cancelled(Context context) {
        this.cancel();
    }

    ClientCallImpl<ReqT, RespT> setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    ClientCallImpl<ReqT, RespT> setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
        this.decompressorRegistry = decompressorRegistry;
        return this;
    }

    ClientCallImpl<ReqT, RespT> setCompressorRegistry(CompressorRegistry compressorRegistry) {
        this.compressorRegistry = compressorRegistry;
        return this;
    }

    ClientCallImpl<ReqT, RespT> setKnownMessageEncodingRegistry(Set<String> knownMessageEncodings) {
        this.knownMessageEncodingRegistry = knownMessageEncodings;
        return this;
    }

    @VisibleForTesting
    static void prepareHeaders(Metadata headers, CallOptions callOptions, String userAgent, Set<String> knownMessageEncodings, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry) {
        headers.removeAll(GrpcUtil.AUTHORITY_KEY);
        if (callOptions.getAuthority() != null) {
            headers.put(GrpcUtil.AUTHORITY_KEY, callOptions.getAuthority());
        }
        headers.removeAll(GrpcUtil.USER_AGENT_KEY);
        if (userAgent != null) {
            headers.put(GrpcUtil.USER_AGENT_KEY, userAgent);
        }
        headers.removeAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        for (String messageEncoding : knownMessageEncodings) {
            Compressor compressor = compressorRegistry.lookupCompressor(messageEncoding);
            if (compressor == null || compressor == Codec.Identity.NONE) continue;
            headers.put(GrpcUtil.MESSAGE_ENCODING_KEY, compressor.getMessageEncoding());
            break;
        }
        headers.removeAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        if (!decompressorRegistry.getAdvertisedMessageEncodings().isEmpty()) {
            String acceptEncoding = GrpcUtil.ACCEPT_ENCODING_JOINER.join(decompressorRegistry.getAdvertisedMessageEncodings());
            headers.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, acceptEncoding);
        }
    }

    @Override
    public void start(final ClientCall.Listener<RespT> observer, Metadata headers) {
        Long timeoutNanos;
        Preconditions.checkState((this.stream == null ? 1 : 0) != 0, (Object)"Already started");
        Preconditions.checkNotNull(observer, (Object)"observer");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        if (this.context.isCancelled()) {
            this.stream = NoopClientStream.INSTANCE;
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    observer.onClose(Status.CANCELLED.withCause(ClientCallImpl.this.context.cause()), new Metadata());
                }
            });
            return;
        }
        ClientCallImpl.prepareHeaders(headers, this.callOptions, this.userAgent, this.knownMessageEncodingRegistry, this.decompressorRegistry, this.compressorRegistry);
        ListenableFuture<ClientTransport> transportFuture = this.clientTransportProvider.get(this.callOptions);
        if (transportFuture.isDone()) {
            try {
                ClientTransport transport = (ClientTransport)transportFuture.get();
                if (transport != null && ClientCallImpl.updateTimeoutHeader(this.callOptions.getDeadlineNanoTime(), headers)) {
                    this.stream = transport.newStream(this.method, headers);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.stream == null) {
            DelayedStream delayed = new DelayedStream();
            this.stream = delayed;
            Futures.addCallback(transportFuture, (FutureCallback)new StreamCreationTask(delayed, headers, this.method, this.callOptions), (Executor)(transportFuture.isDone() ? MoreExecutors.directExecutor() : this.callExecutor));
        }
        this.stream.setDecompressionRegistry(this.decompressorRegistry);
        this.stream.setCompressionRegistry(this.compressorRegistry);
        if (headers.containsKey(GrpcUtil.MESSAGE_ENCODING_KEY)) {
            this.stream.pickCompressor(Collections.singleton(headers.get(GrpcUtil.MESSAGE_ENCODING_KEY)));
            this.stream.setMessageCompression(true);
        }
        if ((timeoutNanos = ClientCallImpl.getRemainingTimeoutNanos(this.callOptions.getDeadlineNanoTime())) != null) {
            this.deadlineCancellationFuture = this.startDeadlineTimer(timeoutNanos);
        }
        this.context.addListener(this, MoreExecutors.directExecutor());
        this.stream.start(new ClientStreamListenerImpl(observer, transportFuture));
    }

    static boolean updateTimeoutHeader(@Nullable Long deadlineNanoTime, Metadata headers) {
        headers.removeAll(GrpcUtil.TIMEOUT_KEY);
        Long timeoutNanos = ClientCallImpl.getRemainingTimeoutNanos(deadlineNanoTime);
        if (timeoutNanos != null) {
            if (timeoutNanos <= 0L) {
                return false;
            }
            headers.put(GrpcUtil.TIMEOUT_KEY, timeoutNanos);
        }
        return true;
    }

    @Nullable
    private static Long getRemainingTimeoutNanos(@Nullable Long deadlineNanoTime) {
        if (deadlineNanoTime == null) {
            return null;
        }
        return deadlineNanoTime - System.nanoTime();
    }

    @Override
    public void request(int numMessages) {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        this.stream.request(numMessages);
    }

    @Override
    public void cancel() {
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        try {
            if (this.stream != null) {
                this.stream.cancel(Status.CANCELLED);
            }
        }
        finally {
            this.context.removeListener(this);
        }
    }

    @Override
    public void halfClose() {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        Preconditions.checkState((!this.cancelCalled ? 1 : 0) != 0, (Object)"call was cancelled");
        Preconditions.checkState((!this.halfCloseCalled ? 1 : 0) != 0, (Object)"call already half-closed");
        this.halfCloseCalled = true;
        this.stream.halfClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(ReqT message) {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        Preconditions.checkState((!this.cancelCalled ? 1 : 0) != 0, (Object)"call was cancelled");
        Preconditions.checkState((!this.halfCloseCalled ? 1 : 0) != 0, (Object)"call was half-closed");
        boolean failed = true;
        try {
            InputStream messageIs = this.method.streamRequest(message);
            this.stream.writeMessage(messageIs);
            failed = false;
        }
        finally {
            if (failed) {
                this.cancel();
            }
        }
        if (!this.unaryRequest) {
            this.stream.flush();
        }
    }

    @Override
    public void setMessageCompression(boolean enabled) {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
        this.stream.setMessageCompression(enabled);
    }

    @Override
    public boolean isReady() {
        return this.stream.isReady();
    }

    private ScheduledFuture<?> startDeadlineTimer(long timeoutNanos) {
        return this.deadlineCancellationExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                ClientCallImpl.this.stream.cancel(Status.DEADLINE_EXCEEDED);
            }
        }, timeoutNanos, TimeUnit.NANOSECONDS);
    }

    @VisibleForTesting
    static final class StreamCreationTask
    implements FutureCallback<ClientTransport> {
        private final DelayedStream stream;
        private final MethodDescriptor<?, ?> method;
        private final Metadata headers;
        private final CallOptions callOptions;

        StreamCreationTask(DelayedStream stream, Metadata headers, MethodDescriptor<?, ?> method, CallOptions callOptions) {
            this.stream = stream;
            this.headers = headers;
            this.method = method;
            this.callOptions = callOptions;
        }

        public void onSuccess(ClientTransport transport) {
            if (transport == null) {
                this.stream.setError(Status.UNAVAILABLE.withDescription("Channel is shutdown"));
                return;
            }
            if (!ClientCallImpl.updateTimeoutHeader(this.callOptions.getDeadlineNanoTime(), this.headers)) {
                this.stream.setError(Status.DEADLINE_EXCEEDED);
                return;
            }
            this.stream.setStream(transport.newStream(this.method, this.headers));
        }

        public void onFailure(Throwable t) {
            this.stream.setError(Status.fromThrowable(t));
        }
    }

    private class ClientStreamListenerImpl
    implements ClientStreamListener {
        private final ClientCall.Listener<RespT> observer;
        private final ListenableFuture<ClientTransport> transportFuture;
        private boolean closed;

        public ClientStreamListenerImpl(ClientCall.Listener<RespT> observer, ListenableFuture<ClientTransport> transportFuture) {
            this.observer = (ClientCall.Listener)Preconditions.checkNotNull(observer, (Object)"observer");
            this.transportFuture = (ListenableFuture)Preconditions.checkNotNull(transportFuture, (Object)"transportFuture");
        }

        @Override
        public void headersRead(final Metadata headers) {
            if (headers.containsKey(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY)) {
                String serverAcceptEncodings = headers.get(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
                Iterables.addAll((Collection)ClientCallImpl.this.knownMessageEncodingRegistry, (Iterable)GrpcUtil.ACCEPT_ENCODING_SPLITER.split((CharSequence)serverAcceptEncodings));
            }
            ClientCallImpl.this.callExecutor.execute(new ContextRunnable(ClientCallImpl.this.context){

                @Override
                public final void runInContext() {
                    try {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        ClientStreamListenerImpl.this.observer.onHeaders(headers);
                    }
                    catch (Throwable t) {
                        ClientCallImpl.this.cancel();
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            });
        }

        @Override
        public void messageRead(final InputStream message) {
            ClientCallImpl.this.callExecutor.execute(new ContextRunnable(ClientCallImpl.this.context){

                @Override
                public final void runInContext() {
                    try {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onMessage(ClientCallImpl.this.method.parseResponse(message));
                        }
                        finally {
                            message.close();
                        }
                    }
                    catch (Throwable t) {
                        ClientCallImpl.this.cancel();
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            });
        }

        @Override
        public void closed(Status status, Metadata trailers) {
            Long timeoutNanos = ClientCallImpl.getRemainingTimeoutNanos(ClientCallImpl.this.callOptions.getDeadlineNanoTime());
            this.transportFuture.cancel(false);
            if (status.getCode() == Status.Code.CANCELLED && timeoutNanos != null && timeoutNanos <= 0L) {
                status = Status.DEADLINE_EXCEEDED;
                trailers = new Metadata();
            }
            final Status savedStatus = status;
            final Metadata savedTrailers = trailers;
            ClientCallImpl.this.callExecutor.execute(new ContextRunnable(ClientCallImpl.this.context){

                @Override
                public final void runInContext() {
                    try {
                        ClientStreamListenerImpl.this.closed = true;
                        ScheduledFuture future = ClientCallImpl.this.deadlineCancellationFuture;
                        if (future != null) {
                            future.cancel(false);
                        }
                        ClientStreamListenerImpl.this.observer.onClose(savedStatus, savedTrailers);
                    }
                    finally {
                        ClientCallImpl.this.context.removeListener(ClientCallImpl.this);
                    }
                }
            });
        }

        @Override
        public void onReady() {
            ClientCallImpl.this.callExecutor.execute(new ContextRunnable(ClientCallImpl.this.context){

                @Override
                public final void runInContext() {
                    ClientStreamListenerImpl.this.observer.onReady();
                }
            });
        }
    }

    static interface ClientTransportProvider {
        public ListenableFuture<ClientTransport> get(CallOptions var1);
    }
}

