/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.Compressor;
import io.grpc.Decompressor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.NoopClientStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

class DelayedStream
implements ClientStream {
    private volatile boolean passThrough;
    private ClientStreamListener listener;
    private ClientStream realStream;
    @GuardedBy(value="this")
    private Status error;
    @GuardedBy(value="this")
    private List<Runnable> pendingCalls = new ArrayList<Runnable>();

    DelayedStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setStream(ClientStream stream) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.realStream != null) {
                return;
            }
            this.realStream = (ClientStream)Preconditions.checkNotNull((Object)stream, (Object)"stream");
        }
        this.drainPendingCalls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainPendingCalls() {
        assert (this.realStream != null);
        assert (!this.passThrough);
        List<Runnable> toRun = new ArrayList<Runnable>();
        while (true) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.pendingCalls.isEmpty()) {
                    this.pendingCalls = null;
                    this.passThrough = true;
                    break;
                }
                ArrayList<Runnable> tmp = toRun;
                toRun = this.pendingCalls;
                this.pendingCalls = tmp;
            }
            for (Runnable runnable : toRun) {
                runnable.run();
            }
            toRun.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOrExecute(Runnable runnable) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (!this.passThrough) {
                this.pendingCalls.add(runnable);
                return;
            }
        }
        runnable.run();
    }

    @Override
    public void setAuthority(final String authority) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"May only be called before start");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.setAuthority(authority);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(final ClientStreamListener listener) {
        Status savedError;
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            this.listener = (ClientStreamListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            savedError = this.error;
        }
        if (savedError != null) {
            listener.closed(savedError, new Metadata());
            return;
        }
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.start(listener);
            }
        });
    }

    @Override
    public void writeMessage(final InputStream message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        if (this.passThrough) {
            this.realStream.writeMessage(message);
        } else {
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStream.this.realStream.writeMessage(message);
                }
            });
        }
    }

    @Override
    public void flush() {
        if (this.passThrough) {
            this.realStream.flush();
        } else {
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStream.this.realStream.flush();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(final Status reason) {
        Preconditions.checkNotNull((Object)reason, (Object)"reason");
        boolean delegateToRealStream = true;
        ClientStreamListener listenerToClose = null;
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.realStream == null) {
                this.realStream = NoopClientStream.INSTANCE;
                delegateToRealStream = false;
                listenerToClose = this.listener;
                this.error = reason;
            }
        }
        if (delegateToRealStream) {
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStream.this.realStream.cancel(reason);
                }
            });
        } else {
            if (listenerToClose != null) {
                listenerToClose.closed(reason, new Metadata());
            }
            this.drainPendingCalls();
        }
    }

    @Override
    public void halfClose() {
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.halfClose();
            }
        });
    }

    @Override
    public void request(final int numMessages) {
        if (this.passThrough) {
            this.realStream.request(numMessages);
        } else {
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStream.this.realStream.request(numMessages);
                }
            });
        }
    }

    @Override
    public void setCompressor(final Compressor compressor) {
        Preconditions.checkNotNull((Object)compressor, (Object)"compressor");
        this.delayOrExecute(new Runnable(){

            @Override
            public void run() {
                DelayedStream.this.realStream.setCompressor(compressor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDecompressor(Decompressor decompressor) {
        Preconditions.checkNotNull((Object)decompressor, (Object)"decompressor");
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
        }
        Preconditions.checkState((this.realStream != null ? 1 : 0) != 0, (Object)"How did we receive a reply before the request is sent?");
        this.realStream.setDecompressor(decompressor);
    }

    @Override
    public boolean isReady() {
        if (this.passThrough) {
            return this.realStream.isReady();
        }
        return false;
    }

    @Override
    public void setMessageCompression(final boolean enable) {
        if (this.passThrough) {
            this.realStream.setMessageCompression(enable);
        } else {
            this.delayOrExecute(new Runnable(){

                @Override
                public void run() {
                    DelayedStream.this.realStream.setMessageCompression(enable);
                }
            });
        }
    }
}

