/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.FailingClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.WithLogId;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TransportSet
implements WithLogId {
    private static final Logger log = Logger.getLogger(TransportSet.class.getName());
    private static final ClientTransport SHUTDOWN_TRANSPORT = new FailingClientTransport(Status.UNAVAILABLE.withDescription("TransportSet is shutdown"));
    private final Object lock = new Object();
    private final EquivalentAddressGroup addressGroup;
    private final String authority;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Callback callback;
    private final ClientTransportFactory transportFactory;
    private final ScheduledExecutorService scheduledExecutor;
    private final Executor appExecutor;
    @GuardedBy(value="lock")
    private int nextAddressIndex;
    @GuardedBy(value="lock")
    private BackoffPolicy reconnectPolicy;
    @GuardedBy(value="lock")
    private boolean firstAttempt = true;
    @GuardedBy(value="lock")
    private final Stopwatch backoffWatch;
    @Nullable
    @GuardedBy(value="lock")
    private ScheduledFuture<?> reconnectTask;
    @GuardedBy(value="lock")
    private final Collection<ManagedClientTransport> transports = new ArrayList<ManagedClientTransport>();
    private final LoadBalancer<ClientTransport> loadBalancer;
    @GuardedBy(value="lock")
    private boolean shutdown;
    @Nullable
    private volatile ManagedClientTransport activeTransport;

    TransportSet(EquivalentAddressGroup addressGroup, String authority, LoadBalancer<ClientTransport> loadBalancer, BackoffPolicy.Provider backoffPolicyProvider, ClientTransportFactory transportFactory, ScheduledExecutorService scheduledExecutor, Executor appExecutor, Callback callback) {
        this(addressGroup, authority, loadBalancer, backoffPolicyProvider, transportFactory, scheduledExecutor, appExecutor, callback, Stopwatch.createUnstarted());
    }

    @VisibleForTesting
    TransportSet(EquivalentAddressGroup addressGroup, String authority, LoadBalancer<ClientTransport> loadBalancer, BackoffPolicy.Provider backoffPolicyProvider, ClientTransportFactory transportFactory, ScheduledExecutorService scheduledExecutor, Executor appExecutor, Callback callback, Stopwatch backoffWatch) {
        this.addressGroup = (EquivalentAddressGroup)Preconditions.checkNotNull((Object)addressGroup, (Object)"addressGroup");
        this.authority = authority;
        this.loadBalancer = loadBalancer;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.transportFactory = transportFactory;
        this.scheduledExecutor = scheduledExecutor;
        this.appExecutor = appExecutor;
        this.callback = callback;
        this.backoffWatch = backoffWatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ClientTransport obtainActiveTransport() {
        ManagedClientTransport savedTransport = this.activeTransport;
        if (savedTransport != null) {
            return savedTransport;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.activeTransport == null) {
                if (this.shutdown) {
                    return SHUTDOWN_TRANSPORT;
                }
                DelayedClientTransport delayedTransport = new DelayedClientTransport(this.appExecutor);
                this.transports.add(delayedTransport);
                delayedTransport.start(new BaseTransportListener(delayedTransport));
                this.activeTransport = delayedTransport;
                this.scheduleConnection(delayedTransport);
            }
            return this.activeTransport;
        }
    }

    @GuardedBy(value="lock")
    private void scheduleConnection(final DelayedClientTransport delayedTransport) {
        Preconditions.checkState((this.reconnectTask == null || this.reconnectTask.isDone() ? 1 : 0) != 0, (Object)"previous reconnectTask is not done");
        if (this.firstAttempt) {
            this.nextAddressIndex = 0;
        }
        final int currentAddressIndex = this.nextAddressIndex++;
        List<SocketAddress> addrs = this.addressGroup.getAddresses();
        final SocketAddress address = addrs.get(currentAddressIndex);
        if (this.nextAddressIndex >= addrs.size()) {
            this.nextAddressIndex = 0;
        }
        Runnable createTransportRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TransportSet.this.lock;
                synchronized (object) {
                    TransportSet.this.reconnectTask = null;
                    if (currentAddressIndex == 0) {
                        TransportSet.this.backoffWatch.reset().start();
                    }
                    ManagedClientTransport transport = TransportSet.this.transportFactory.newClientTransport(address, TransportSet.this.authority);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "[{0}] Created {1} for {2}", new Object[]{TransportSet.this.getLogId(), transport.getLogId(), address});
                    }
                    TransportSet.this.transports.add(transport);
                    transport.start(new TransportListener(transport, delayedTransport, address));
                }
            }
        };
        long delayMillis = 0L;
        if (currentAddressIndex == 0) {
            if (this.firstAttempt) {
                this.reconnectPolicy = this.backoffPolicyProvider.get();
            } else {
                delayMillis = this.reconnectPolicy.nextBackoffMillis() - this.backoffWatch.elapsed(TimeUnit.MILLISECONDS);
            }
        }
        this.firstAttempt = false;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "[{0}] Scheduling connection after {1} ms for {2}", new Object[]{this.getLogId(), delayMillis, address});
        }
        if (delayMillis <= 0L) {
            this.reconnectTask = null;
            createTransportRunnable.run();
        } else {
            this.reconnectTask = this.scheduledExecutor.schedule(createTransportRunnable, delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void shutdown() {
        ManagedClientTransport savedActiveTransport;
        boolean runCallback = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            savedActiveTransport = this.activeTransport;
            this.activeTransport = null;
            if (this.transports.isEmpty()) {
                runCallback = true;
                Preconditions.checkState((this.reconnectTask == null ? 1 : 0) != 0, (Object)"Should have no reconnectTask scheduled");
            }
        }
        if (savedActiveTransport != null) {
            savedActiveTransport.shutdown();
        }
        if (runCallback) {
            this.callback.onTerminated();
        }
    }

    @GuardedBy(value="lock")
    private void cancelReconnectTask() {
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel(false);
            this.reconnectTask = null;
        }
    }

    @Override
    public String getLogId() {
        return GrpcUtil.getLogId(this);
    }

    static interface Callback {
        public void onTerminated();

        public void onAllAddressesFailed();

        public void onConnectionClosedByServer(Status var1);
    }

    private class TransportListener
    extends BaseTransportListener {
        private final SocketAddress address;
        private final DelayedClientTransport delayedTransport;

        public TransportListener(ManagedClientTransport transport, DelayedClientTransport delayedTransport, SocketAddress address) {
            super(transport);
            this.address = address;
            this.delayedTransport = delayedTransport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportReady() {
            boolean savedShutdown;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "[{0}] {1} for {2} is ready", new Object[]{TransportSet.this.getLogId(), this.transport.getLogId(), this.address});
            }
            super.transportReady();
            Object object = TransportSet.this.lock;
            synchronized (object) {
                savedShutdown = TransportSet.this.shutdown;
                TransportSet.this.firstAttempt = true;
                if (TransportSet.this.shutdown) {
                    Preconditions.checkState((TransportSet.this.activeTransport == null ? 1 : 0) != 0, (Object)"Unexpected non-null activeTransport");
                } else if (TransportSet.this.activeTransport == this.delayedTransport) {
                    TransportSet.this.activeTransport = this.transport;
                }
            }
            this.delayedTransport.setTransport(this.transport);
            this.delayedTransport.shutdown();
            if (savedShutdown) {
                this.transport.shutdown();
            }
            TransportSet.this.loadBalancer.handleTransportReady(TransportSet.this.addressGroup);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportShutdown(Status s) {
            boolean allAddressesFailed = false;
            boolean closedByServer = false;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "[{0}] {1} for {2} is being shutdown with status {3}", new Object[]{TransportSet.this.getLogId(), this.transport.getLogId(), this.address, s});
            }
            super.transportShutdown(s);
            Object object = TransportSet.this.lock;
            synchronized (object) {
                if (TransportSet.this.activeTransport == this.transport) {
                    TransportSet.this.activeTransport = null;
                    closedByServer = !TransportSet.this.shutdown;
                } else if (TransportSet.this.activeTransport == this.delayedTransport) {
                    if (TransportSet.this.nextAddressIndex == 0) {
                        allAddressesFailed = true;
                        this.delayedTransport.setTransport(new FailingClientTransport(s));
                        this.delayedTransport.shutdown();
                        TransportSet.this.activeTransport = null;
                    } else {
                        TransportSet.this.scheduleConnection(this.delayedTransport);
                    }
                }
            }
            TransportSet.this.loadBalancer.handleTransportShutdown(TransportSet.this.addressGroup, s);
            if (allAddressesFailed) {
                TransportSet.this.callback.onAllAddressesFailed();
            }
            if (closedByServer) {
                TransportSet.this.callback.onConnectionClosedByServer(s);
            }
        }

        @Override
        public void transportTerminated() {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "[{0}] {1} for {2} is terminated", new Object[]{TransportSet.this.getLogId(), this.transport.getLogId(), this.address});
            }
            super.transportTerminated();
            Preconditions.checkState((TransportSet.this.activeTransport != this.transport ? 1 : 0) != 0, (Object)"activeTransport still points to the delayedTransport. Seems transportShutdown() was not called.");
        }
    }

    private class BaseTransportListener
    implements ManagedClientTransport.Listener {
        protected final ManagedClientTransport transport;

        public BaseTransportListener(ManagedClientTransport transport) {
            this.transport = transport;
        }

        @Override
        public void transportReady() {
        }

        @Override
        public void transportShutdown(Status status) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportTerminated() {
            boolean runCallback = false;
            Object object = TransportSet.this.lock;
            synchronized (object) {
                TransportSet.this.transports.remove(this.transport);
                if (TransportSet.this.shutdown && TransportSet.this.transports.isEmpty()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "[{0}] Terminated", TransportSet.this.getLogId());
                    }
                    runCallback = true;
                    TransportSet.this.cancelReconnectTask();
                }
            }
            if (runCallback) {
                TransportSet.this.callback.onTerminated();
            }
        }
    }
}

