/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Attributes;
import io.grpc.ClientInterceptor;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.DummyLoadBalancerFactory;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.ResolvedServerInfo;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedChannelImpl;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends ManagedChannelBuilder<T> {
    private static final String DIRECT_ADDRESS_SCHEME = "directaddress";
    @Nullable
    private Executor executor;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private final String target;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    private String userAgent;
    @Nullable
    private String authorityOverride;
    @Nullable
    private NameResolver.Factory nameResolverFactory;
    @Nullable
    private LoadBalancer.Factory loadBalancerFactory;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;

    protected AbstractManagedChannelImplBuilder(String target) {
        this.target = (String)Preconditions.checkNotNull((Object)target);
        this.directServerAddress = null;
    }

    @VisibleForTesting
    static String makeTargetStringForDirectAddress(SocketAddress address) {
        try {
            return new URI(DIRECT_ADDRESS_SCHEME, "", "/" + address, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractManagedChannelImplBuilder(SocketAddress directServerAddress, String authority) {
        this.target = AbstractManagedChannelImplBuilder.makeTargetStringForDirectAddress(directServerAddress);
        this.directServerAddress = directServerAddress;
        this.nameResolverFactory = new DirectAddressNameResolverFactory(directServerAddress, authority);
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this.thisT();
    }

    @Override
    public final T intercept(ClientInterceptor ... interceptors) {
        return (T)this.intercept((List)Arrays.asList(interceptors));
    }

    @Override
    public final T nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of NameResolverFactory", (Object[])new Object[]{this.directServerAddress});
        this.nameResolverFactory = resolverFactory;
        return this.thisT();
    }

    @Override
    public final T loadBalancerFactory(LoadBalancer.Factory loadBalancerFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of LoadBalancerFactory", (Object[])new Object[]{this.directServerAddress});
        this.loadBalancerFactory = loadBalancerFactory;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    private T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }

    @Override
    public final T userAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
        return this.thisT();
    }

    @Override
    public final T overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this.thisT();
    }

    protected String checkAuthority(String authority) {
        return GrpcUtil.checkAuthority(authority);
    }

    @Override
    public ManagedChannelImpl build() {
        ClientTransportFactory transportFactory = this.buildTransportFactory();
        if (this.authorityOverride != null) {
            transportFactory = new AuthorityOverridingTransportFactory(transportFactory, this.authorityOverride);
        }
        return new ManagedChannelImpl(this.target, new ExponentialBackoffPolicy.Provider(), (NameResolver.Factory)MoreObjects.firstNonNull((Object)this.nameResolverFactory, (Object)NameResolverProvider.asFactory()), this.getNameResolverParams(), (LoadBalancer.Factory)MoreObjects.firstNonNull((Object)this.loadBalancerFactory, (Object)DummyLoadBalancerFactory.getInstance()), transportFactory, (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), this.executor, this.userAgent, this.interceptors);
    }

    protected abstract ClientTransportFactory buildTransportFactory();

    protected Attributes getNameResolverParams() {
        return Attributes.EMPTY;
    }

    private static class DirectAddressNameResolverFactory
    extends NameResolver.Factory {
        final SocketAddress address;
        final String authority;

        DirectAddressNameResolverFactory(SocketAddress address, String authority) {
            this.address = address;
            this.authority = authority;
        }

        @Override
        public NameResolver newNameResolver(URI notUsedUri, Attributes params) {
            return new NameResolver(){

                @Override
                public String getServiceAuthority() {
                    return DirectAddressNameResolverFactory.this.authority;
                }

                @Override
                public void start(NameResolver.Listener listener) {
                    listener.onUpdate(Collections.singletonList(Collections.singletonList(new ResolvedServerInfo(DirectAddressNameResolverFactory.this.address, Attributes.EMPTY))), Attributes.EMPTY);
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return AbstractManagedChannelImplBuilder.DIRECT_ADDRESS_SCHEME;
        }
    }

    private static class AuthorityOverridingTransportFactory
    implements ClientTransportFactory {
        final ClientTransportFactory factory;
        final String authorityOverride;

        AuthorityOverridingTransportFactory(ClientTransportFactory factory, String authorityOverride) {
            this.factory = (ClientTransportFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory should not be null");
            this.authorityOverride = (String)Preconditions.checkNotNull((Object)authorityOverride, (Object)"authorityOverride should not be null");
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, String authority, @Nullable String userAgent) {
            return this.factory.newClientTransport(serverAddress, this.authorityOverride, userAgent);
        }

        @Override
        public void close() {
            this.factory.close();
        }
    }
}

