/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import io.grpc.HandlerRegistry;
import io.grpc.MutableHandlerRegistry;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MutableHandlerRegistryImpl
extends MutableHandlerRegistry {
    private final ConcurrentMap<String, ServerServiceDefinition> services = new ConcurrentHashMap<String, ServerServiceDefinition>();

    @Override
    @Nullable
    public ServerServiceDefinition addService(ServerServiceDefinition service) {
        return this.services.put(service.getName(), service);
    }

    @Override
    public boolean removeService(ServerServiceDefinition service) {
        return this.services.remove(service.getName(), service);
    }

    @Override
    @Nullable
    public HandlerRegistry.Method lookupMethod(String methodName) {
        int index = methodName.lastIndexOf("/");
        if (index < 2 || methodName.charAt(0) != '/') {
            return null;
        }
        ServerServiceDefinition service = (ServerServiceDefinition)this.services.get(methodName.substring(1, index));
        if (service == null) {
            return null;
        }
        ServerMethodDefinition<?, ?> method = service.getMethod(methodName.substring(index + 1));
        if (method == null) {
            return null;
        }
        return new HandlerRegistry.Method(service, method);
    }
}

