/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ServerInterceptors {
    private ServerInterceptors() {
    }

    public static ServerServiceDefinition intercept(ServerServiceDefinition serviceDef, ServerInterceptor ... interceptors) {
        return ServerInterceptors.intercept(serviceDef, Arrays.asList(interceptors));
    }

    public static ServerServiceDefinition intercept(ServerServiceDefinition serviceDef, List<ServerInterceptor> interceptors) {
        Preconditions.checkNotNull((Object)serviceDef);
        ImmutableList immutableInterceptors = ImmutableList.copyOf(interceptors);
        if (immutableInterceptors.isEmpty()) {
            return serviceDef;
        }
        ServerServiceDefinition.Builder serviceDefBuilder = ServerServiceDefinition.builder(serviceDef.getName());
        for (ServerMethodDefinition method : serviceDef.getMethods()) {
            ServerInterceptors.wrapAndAddMethod(serviceDefBuilder, method, (List<ServerInterceptor>)immutableInterceptors);
        }
        return serviceDefBuilder.build();
    }

    private static <ReqT, RespT> void wrapAndAddMethod(ServerServiceDefinition.Builder serviceDefBuilder, ServerMethodDefinition<ReqT, RespT> method, List<ServerInterceptor> interceptors) {
        InterceptCallHandler<ReqT, RespT> callHandler = InterceptCallHandler.create(interceptors, method.getServerCallHandler());
        serviceDefBuilder.addMethod(method.withServerCallHandler(callHandler));
    }

    @Deprecated
    public static class ForwardingListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        public ForwardingListener(ServerCall.Listener<ReqT> delegate) {
            super(delegate);
        }
    }

    @Deprecated
    public static class ForwardingServerCall<RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<RespT> {
        public ForwardingServerCall(ServerCall<RespT> delegate) {
            super(delegate);
        }
    }

    private static class ProcessInterceptorsCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private Iterator<ServerInterceptor> interceptors;
        private final ServerCallHandler<ReqT, RespT> callHandler;

        public static <ReqT, RespT> ProcessInterceptorsCallHandler<ReqT, RespT> create(Iterator<ServerInterceptor> interceptors, ServerCallHandler<ReqT, RespT> callHandler) {
            return new ProcessInterceptorsCallHandler<ReqT, RespT>(interceptors, callHandler);
        }

        private ProcessInterceptorsCallHandler(Iterator<ServerInterceptor> interceptors, ServerCallHandler<ReqT, RespT> callHandler) {
            this.interceptors = interceptors;
            this.callHandler = callHandler;
        }

        @Override
        public ServerCall.Listener<ReqT> startCall(String method, ServerCall<RespT> call, Metadata.Headers headers) {
            if (this.interceptors != null && this.interceptors.hasNext()) {
                return this.interceptors.next().interceptCall(method, call, headers, this);
            }
            Preconditions.checkState((this.interceptors != null ? 1 : 0) != 0, (Object)"The call handler has already been called. Some interceptor must have called on \"next\" twice.");
            this.interceptors = null;
            return this.callHandler.startCall(method, call, headers);
        }
    }

    private static class InterceptCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private final List<ServerInterceptor> interceptors;
        private final ServerCallHandler<ReqT, RespT> callHandler;

        public static <ReqT, RespT> InterceptCallHandler<ReqT, RespT> create(List<ServerInterceptor> interceptors, ServerCallHandler<ReqT, RespT> callHandler) {
            return new InterceptCallHandler<ReqT, RespT>(interceptors, callHandler);
        }

        private InterceptCallHandler(List<ServerInterceptor> interceptors, ServerCallHandler<ReqT, RespT> callHandler) {
            this.interceptors = interceptors;
            this.callHandler = callHandler;
        }

        @Override
        public ServerCall.Listener<ReqT> startCall(String method, ServerCall<RespT> call, Metadata.Headers headers) {
            return ProcessInterceptorsCallHandler.create(this.interceptors.iterator(), this.callHandler).startCall(method, call, headers);
        }
    }
}

