/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.BackoffPolicy;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientCallImpl;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ExponentialBackoffPolicy;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.SharedResourceHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ChannelImpl
extends Channel {
    private static final Logger log = Logger.getLogger(ChannelImpl.class.getName());
    private final ClientTransportFactory transportFactory;
    private final ExecutorService executor;
    private final String userAgent;
    private final Object lock = new Object();
    private ScheduledExecutorService scheduledExecutor;
    private final BackoffPolicy.Provider backoffPolicyProvider = new ExponentialBackoffPolicy.Provider();
    private final Channel interceptorChannel;
    @GuardedBy(value="lock")
    private Collection<ClientTransport> transports = new ArrayList<ClientTransport>();
    private volatile ClientTransport activeTransport;
    @GuardedBy(value="lock")
    private boolean shutdown;
    @GuardedBy(value="lock")
    private boolean terminated;
    private Runnable terminationRunnable;
    private long reconnectTimeMillis;
    private BackoffPolicy reconnectPolicy;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get() {
            return ChannelImpl.this.obtainActiveTransport();
        }
    };
    @VisibleForTesting
    public static final Metadata.Key<Long> TIMEOUT_KEY = Metadata.Key.of("grpc-timeout", new TimeoutMarshaller());
    static final SharedResourceHolder.Resource<ScheduledExecutorService> TIMER_SERVICE = new SharedResourceHolder.Resource<ScheduledExecutorService>(){

        @Override
        public ScheduledExecutorService create() {
            return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }

        @Override
        public void close(ScheduledExecutorService instance) {
            instance.shutdown();
        }
    };

    ChannelImpl(ClientTransportFactory transportFactory, ExecutorService executor, @Nullable String userAgent, List<ClientInterceptor> interceptors) {
        this.transportFactory = transportFactory;
        this.executor = executor;
        this.userAgent = userAgent;
        this.interceptorChannel = ClientInterceptors.intercept((Channel)new RealChannel(), interceptors);
        this.scheduledExecutor = SharedResourceHolder.get(TIMER_SERVICE);
    }

    void setTerminationRunnable(Runnable runnable) {
        this.terminationRunnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelImpl shutdown() {
        ClientTransport savedActiveTransport;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            this.scheduledExecutor = SharedResourceHolder.release(TIMER_SERVICE, this.scheduledExecutor);
            savedActiveTransport = this.activeTransport;
            if (savedActiveTransport != null) {
                this.activeTransport = null;
            } else if (this.transports.isEmpty()) {
                this.terminated = true;
                this.lock.notifyAll();
                if (this.terminationRunnable != null) {
                    this.terminationRunnable.run();
                }
            }
        }
        if (savedActiveTransport != null) {
            savedActiveTransport.shutdown();
        }
        return this;
    }

    public ChannelImpl shutdownNow() {
        this.shutdown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long timeoutNanos = unit.toNanos(timeout);
            long endTimeNanos = System.nanoTime() + timeoutNanos;
            while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, timeoutNanos);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        try {
            this.obtainActiveTransport().ping(callback, executor);
        }
        catch (RuntimeException ex) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.pingFailed(ex);
                }
            });
        }
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
        return this.interceptorChannel.newCall(method, callOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientTransport obtainActiveTransport() {
        ClientTransport savedActiveTransport = this.activeTransport;
        if (savedActiveTransport != null && !(savedActiveTransport instanceof InactiveTransport)) {
            return savedActiveTransport;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return null;
            }
            savedActiveTransport = this.activeTransport;
            if (savedActiveTransport instanceof InactiveTransport) {
                if (System.nanoTime() > TimeUnit.MILLISECONDS.toNanos(this.reconnectTimeMillis)) {
                    savedActiveTransport = this.activeTransport = null;
                } else {
                    return savedActiveTransport;
                }
            }
            if (savedActiveTransport != null) {
                return savedActiveTransport;
            }
            ClientTransport newActiveTransport = this.transportFactory.newClientTransport();
            this.transports.add(newActiveTransport);
            boolean failed = true;
            try {
                newActiveTransport.start(new TransportListener(newActiveTransport));
                failed = false;
            }
            finally {
                if (failed) {
                    this.transports.remove(newActiveTransport);
                }
            }
            if (this.transports.contains(newActiveTransport)) {
                this.activeTransport = newActiveTransport;
            }
            return newActiveTransport;
        }
    }

    private static final class InactiveTransport
    implements ClientTransport {
        private final Status shutdownStatus;

        private InactiveTransport(Status s) {
            this.shutdownStatus = s;
        }

        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata.Headers headers, ClientStreamListener listener) {
            listener.closed(this.shutdownStatus, new Metadata.Trailers());
            return new ClientCallImpl.NoopClientStream();
        }

        @Override
        public void start(ClientTransport.Listener listener) {
            throw new IllegalStateException();
        }

        @Override
        public void ping(final ClientTransport.PingCallback callback, Executor executor) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.pingFailed(InactiveTransport.this.shutdownStatus.asException());
                }
            });
        }

        @Override
        public void shutdown() {
        }
    }

    @VisibleForTesting
    static class TimeoutMarshaller
    implements Metadata.AsciiMarshaller<Long> {
        TimeoutMarshaller() {
        }

        @Override
        public String toAsciiString(Long timeoutMicros) {
            String timeoutUnit;
            long timeout;
            Preconditions.checkArgument((timeoutMicros >= 0L ? 1 : 0) != 0, (Object)"Negative timeout");
            int cutoff = 100000000;
            if (timeoutMicros < (long)cutoff) {
                timeout = timeoutMicros;
                timeoutUnit = "u";
            } else if (timeoutMicros / 1000L < (long)cutoff) {
                timeout = timeoutMicros / 1000L;
                timeoutUnit = "m";
            } else if (timeoutMicros / 1000000L < (long)cutoff) {
                timeout = timeoutMicros / 1000000L;
                timeoutUnit = "S";
            } else if (timeoutMicros / 60000000L < (long)cutoff) {
                timeout = timeoutMicros / 60000000L;
                timeoutUnit = "M";
            } else if (timeoutMicros / 3600000000L < (long)cutoff) {
                timeout = timeoutMicros / 3600000000L;
                timeoutUnit = "H";
            } else {
                throw new IllegalArgumentException("Timeout too large");
            }
            return Long.toString(timeout) + timeoutUnit;
        }

        @Override
        public Long parseAsciiString(String serialized) {
            long factor;
            String valuePart = serialized.substring(0, serialized.length() - 1);
            char unit = serialized.charAt(serialized.length() - 1);
            switch (unit) {
                case 'u': {
                    factor = 1L;
                    break;
                }
                case 'm': {
                    factor = 1000L;
                    break;
                }
                case 'S': {
                    factor = 1000000L;
                    break;
                }
                case 'M': {
                    factor = 60000000L;
                    break;
                }
                case 'H': {
                    factor = 3600000000L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid timeout unit: %s", Character.valueOf(unit)));
                }
            }
            return Long.parseLong(valuePart) * factor;
        }
    }

    private class TransportListener
    implements ClientTransport.Listener {
        private final ClientTransport transport;

        public TransportListener(ClientTransport transport) {
            this.transport = transport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportReady() {
            Object object = ChannelImpl.this.lock;
            synchronized (object) {
                if (ChannelImpl.this.activeTransport == this.transport) {
                    ChannelImpl.this.reconnectPolicy = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportShutdown(Status s) {
            Object object = ChannelImpl.this.lock;
            synchronized (object) {
                if (ChannelImpl.this.activeTransport == this.transport) {
                    ChannelImpl.this.activeTransport = null;
                    if (s.isOk()) {
                        return;
                    }
                    if (ChannelImpl.this.reconnectPolicy == null) {
                        ChannelImpl.this.reconnectPolicy = ChannelImpl.this.backoffPolicyProvider.get();
                        ChannelImpl.this.reconnectTimeMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    }
                    ChannelImpl.this.activeTransport = new InactiveTransport(s);
                    ChannelImpl.this.reconnectTimeMillis = ChannelImpl.this.reconnectTimeMillis + ChannelImpl.this.reconnectPolicy.nextBackoffMillis();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportTerminated() {
            Object object = ChannelImpl.this.lock;
            synchronized (object) {
                if (ChannelImpl.this.activeTransport == this.transport) {
                    log.warning("transportTerminated called without previous transportShutdown");
                    ChannelImpl.this.activeTransport = null;
                }
                this.transportShutdown(Status.UNKNOWN.withDescription("transport shutdown for unknown reason"));
                ChannelImpl.this.transports.remove(this.transport);
                if (ChannelImpl.this.shutdown && ChannelImpl.this.transports.isEmpty()) {
                    if (ChannelImpl.this.terminated) {
                        log.warning("transportTerminated called after already terminated");
                    }
                    ChannelImpl.this.terminated = true;
                    ChannelImpl.this.lock.notifyAll();
                    if (ChannelImpl.this.terminationRunnable != null) {
                        ChannelImpl.this.terminationRunnable.run();
                    }
                }
            }
        }
    }

    private class RealChannel
    extends Channel {
        private RealChannel() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
            return new ClientCallImpl<ReqT, RespT>(method, new SerializingExecutor(ChannelImpl.this.executor), callOptions, ChannelImpl.this.transportProvider, ChannelImpl.this.scheduledExecutor).setUserAgent(ChannelImpl.this.userAgent);
        }
    }
}

