/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MethodDescriptor<RequestT, ResponseT> {
    private final MethodType type;
    private final String fullMethodName;
    private final Marshaller<RequestT> requestMarshaller;
    private final Marshaller<ResponseT> responseMarshaller;

    public static <RequestT, ResponseT> MethodDescriptor<RequestT, ResponseT> create(MethodType type, String fullServiceName, String methodName, Marshaller<RequestT> requestMarshaller, Marshaller<ResponseT> responseMarshaller) {
        return new MethodDescriptor<RequestT, ResponseT>(type, MethodDescriptor.generateFullMethodName(fullServiceName, methodName), requestMarshaller, responseMarshaller);
    }

    public static <RequestT, ResponseT> MethodDescriptor<RequestT, ResponseT> create(MethodType type, String fullMethodName, Marshaller<RequestT> requestMarshaller, Marshaller<ResponseT> responseMarshaller) {
        return new MethodDescriptor<RequestT, ResponseT>(type, fullMethodName, requestMarshaller, responseMarshaller);
    }

    private MethodDescriptor(MethodType type, String fullMethodName, Marshaller<RequestT> requestMarshaller, Marshaller<ResponseT> responseMarshaller) {
        this.type = (MethodType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.fullMethodName = fullMethodName;
        this.requestMarshaller = requestMarshaller;
        this.responseMarshaller = responseMarshaller;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getFullMethodName() {
        return this.fullMethodName;
    }

    public ResponseT parseResponse(InputStream input) {
        return this.responseMarshaller.parse(input);
    }

    public InputStream streamRequest(RequestT requestMessage) {
        return this.requestMarshaller.stream(requestMessage);
    }

    public RequestT parseRequest(InputStream input) {
        return this.requestMarshaller.parse(input);
    }

    public InputStream streamResponse(ResponseT response) {
        return this.responseMarshaller.stream(response);
    }

    public static String generateFullMethodName(String fullServiceName, String methodName) {
        return fullServiceName + "/" + methodName;
    }

    @Nullable
    public static String extractFullServiceName(String fullMethodName) {
        int index = fullMethodName.lastIndexOf("/");
        if (index == -1) {
            return null;
        }
        return fullMethodName.substring(0, index);
    }

    public static interface Marshaller<T> {
        public InputStream stream(T var1);

        public T parse(InputStream var1);
    }

    public static enum MethodType {
        UNARY,
        CLIENT_STREAMING,
        SERVER_STREAMING,
        BIDI_STREAMING,
        UNKNOWN;


        public final boolean clientSendsOneMessage() {
            return this == UNARY || this == SERVER_STREAMING;
        }

        public final boolean serverSendsOneMessage() {
            return this == UNARY || this == CLIENT_STREAMING;
        }
    }
}

