/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.MutableHandlerRegistry;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MutableHandlerRegistryImpl
extends MutableHandlerRegistry {
    private final ConcurrentMap<String, ServerServiceDefinition> services = new ConcurrentHashMap<String, ServerServiceDefinition>();

    @Override
    @Nullable
    public ServerServiceDefinition addService(ServerServiceDefinition service) {
        return this.services.put(service.getName(), service);
    }

    @Override
    public boolean removeService(ServerServiceDefinition service) {
        return this.services.remove(service.getName(), service);
    }

    @Override
    @Nullable
    public HandlerRegistry.Method lookupMethod(String methodName) {
        String serviceName = MethodDescriptor.extractFullServiceName(methodName);
        if (serviceName == null) {
            return null;
        }
        ServerServiceDefinition service = (ServerServiceDefinition)this.services.get(serviceName);
        if (service == null) {
            return null;
        }
        ServerMethodDefinition<?, ?> method = service.getMethod(methodName);
        if (method == null) {
            return null;
        }
        return new HandlerRegistry.Method(service, method);
    }
}

