/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServer;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class InProcessTransport
implements ServerTransport,
ClientTransport {
    private static final Logger log = Logger.getLogger(InProcessTransport.class.getName());
    private final String name;
    private ServerTransportListener serverTransportListener;
    private ClientTransport.Listener clientTransportListener;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;
    @GuardedBy(value="this")
    private Status shutdownStatus;
    @GuardedBy(value="this")
    private Set<InProcessStream> streams = new HashSet<InProcessStream>();

    public InProcessTransport(String name) {
        this.name = name;
    }

    @Override
    public synchronized void start(ClientTransport.Listener listener) {
        this.clientTransportListener = listener;
        InProcessServer server = InProcessServer.findServer(this.name);
        if (server != null) {
            this.serverTransportListener = server.register(this);
        }
        if (this.serverTransportListener == null) {
            final Status localShutdownStatus = this.shutdownStatus = Status.UNAVAILABLE.withDescription("Could not find server: " + this.name);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InProcessTransport inProcessTransport = InProcessTransport.this;
                    synchronized (inProcessTransport) {
                        InProcessTransport.this.notifyShutdown(localShutdownStatus);
                        InProcessTransport.this.notifyTerminated();
                    }
                }
            }).start();
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InProcessTransport inProcessTransport = InProcessTransport.this;
                synchronized (inProcessTransport) {
                    InProcessTransport.this.clientTransportListener.transportReady();
                }
            }
        }).start();
    }

    @Override
    public synchronized ClientStream newStream(MethodDescriptor<?, ?> method, Metadata.Headers headers, ClientStreamListener clientStreamListener) {
        if (this.shutdownStatus != null) {
            clientStreamListener.closed(this.shutdownStatus, new Metadata.Trailers());
            return new NoopClientStream();
        }
        InProcessStream stream = new InProcessStream();
        stream.serverStream.setListener(clientStreamListener);
        ServerStreamListener serverStreamListener = this.serverTransportListener.streamCreated(stream.serverStream, method.getFullMethodName(), headers);
        stream.clientStream.setListener(serverStreamListener);
        this.streams.add(stream);
        return stream.clientStream;
    }

    @Override
    public synchronized void ping(final ClientTransport.PingCallback callback, Executor executor) {
        if (this.terminated) {
            final Status shutdownStatus = this.shutdownStatus;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.pingFailed(shutdownStatus.asRuntimeException());
                }
            });
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.pingAcknowledged(0L);
                }
            });
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdownStatus = Status.UNAVAILABLE.withDescription("transport was requested to shut down");
        this.notifyShutdown(Status.OK.withDescription(this.shutdownStatus.getDescription()));
        if (this.streams.isEmpty()) {
            this.notifyTerminated();
        }
    }

    private synchronized void notifyShutdown(Status s) {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.clientTransportListener.transportShutdown(s);
    }

    private synchronized void notifyTerminated() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.clientTransportListener.transportTerminated();
        if (this.serverTransportListener != null) {
            this.serverTransportListener.transportTerminated();
        }
    }

    private static class NoopClientStream
    implements ClientStream {
        private NoopClientStream() {
        }

        @Override
        public void request(int numMessages) {
        }

        @Override
        public void writeMessage(InputStream message) {
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isReady() {
            return false;
        }

        @Override
        public void cancel(Status status) {
        }

        @Override
        public void halfClose() {
        }
    }

    private class InProcessStream {
        private final InProcessServerStream serverStream = new InProcessServerStream();
        private final InProcessClientStream clientStream = new InProcessClientStream();

        private InProcessStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void streamClosed() {
            InProcessTransport inProcessTransport = InProcessTransport.this;
            synchronized (inProcessTransport) {
                boolean justRemovedAnElement = InProcessTransport.this.streams.remove(this);
                if (InProcessTransport.this.shutdown && InProcessTransport.this.streams.isEmpty() && justRemovedAnElement) {
                    InProcessTransport.this.notifyTerminated();
                }
            }
        }

        private class InProcessClientStream
        implements ClientStream {
            @GuardedBy(value="this")
            private ServerStreamListener serverStreamListener;
            @GuardedBy(value="this")
            private int serverRequested;
            @GuardedBy(value="this")
            private ArrayDeque<InputStream> serverReceiveQueue = new ArrayDeque();
            @GuardedBy(value="this")
            private boolean serverNotifyHalfClose;
            @GuardedBy(value="this")
            private boolean closed;

            private InProcessClientStream() {
            }

            private synchronized void setListener(ServerStreamListener listener) {
                this.serverStreamListener = listener;
            }

            @Override
            public void request(int numMessages) {
                InProcessStream.this.serverStream.clientRequested(numMessages);
            }

            private synchronized void serverRequested(int numMessages) {
                if (this.closed) {
                    return;
                }
                this.serverRequested += numMessages;
                while (this.serverRequested > 0 && !this.serverReceiveQueue.isEmpty()) {
                    --this.serverRequested;
                    this.serverStreamListener.messageRead(this.serverReceiveQueue.poll());
                }
                if (this.serverReceiveQueue.isEmpty() && this.serverNotifyHalfClose) {
                    this.serverNotifyHalfClose = false;
                    this.serverStreamListener.halfClosed();
                }
            }

            private void serverClosed(Status status) {
                this.internalCancel(status);
            }

            @Override
            public synchronized void writeMessage(InputStream message) {
                if (this.closed) {
                    return;
                }
                if (this.serverRequested > 0) {
                    --this.serverRequested;
                    this.serverStreamListener.messageRead(message);
                } else {
                    this.serverReceiveQueue.add(message);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public synchronized boolean isReady() {
                if (this.closed) {
                    return false;
                }
                return this.serverRequested > 0;
            }

            @Override
            public void cancel(Status reason) {
                if (!this.internalCancel(reason)) {
                    return;
                }
                InProcessStream.this.serverStream.clientCancelled(reason);
                InProcessStream.this.streamClosed();
            }

            private synchronized boolean internalCancel(Status reason) {
                InputStream stream;
                if (this.closed) {
                    return false;
                }
                this.closed = true;
                while ((stream = this.serverReceiveQueue.poll()) != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Exception closing stream", t);
                    }
                }
                this.serverStreamListener.closed(reason);
                return true;
            }

            @Override
            public synchronized void halfClose() {
                if (this.closed) {
                    return;
                }
                if (this.serverReceiveQueue.isEmpty()) {
                    this.serverStreamListener.halfClosed();
                } else {
                    this.serverNotifyHalfClose = true;
                }
            }
        }

        private class InProcessServerStream
        implements ServerStream {
            @GuardedBy(value="this")
            private ClientStreamListener clientStreamListener;
            @GuardedBy(value="this")
            private int clientRequested;
            @GuardedBy(value="this")
            private ArrayDeque<InputStream> clientReceiveQueue = new ArrayDeque();
            @GuardedBy(value="this")
            private Status clientNotifyStatus;
            @GuardedBy(value="this")
            private Metadata.Trailers clientNotifyTrailers;
            @GuardedBy(value="this")
            private boolean closed;

            private InProcessServerStream() {
            }

            private synchronized void setListener(ClientStreamListener listener) {
                this.clientStreamListener = listener;
            }

            @Override
            public void request(int numMessages) {
                InProcessStream.this.clientStream.serverRequested(numMessages);
            }

            private synchronized void clientRequested(int numMessages) {
                if (this.closed) {
                    return;
                }
                this.clientRequested += numMessages;
                while (this.clientRequested > 0 && !this.clientReceiveQueue.isEmpty()) {
                    --this.clientRequested;
                    this.clientStreamListener.messageRead(this.clientReceiveQueue.poll());
                }
                if (this.closed) {
                    return;
                }
                if (this.clientReceiveQueue.isEmpty() && this.clientNotifyStatus != null) {
                    this.closed = true;
                    this.clientStreamListener.closed(this.clientNotifyStatus, this.clientNotifyTrailers);
                }
            }

            private void clientCancelled(Status status) {
                this.internalCancel(status);
            }

            @Override
            public synchronized void writeMessage(InputStream message) {
                if (this.closed) {
                    return;
                }
                if (this.clientRequested > 0) {
                    --this.clientRequested;
                    this.clientStreamListener.messageRead(message);
                } else {
                    this.clientReceiveQueue.add(message);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public synchronized boolean isReady() {
                if (this.closed) {
                    return false;
                }
                return this.clientRequested > 0;
            }

            @Override
            public synchronized void writeHeaders(Metadata.Headers headers) {
                if (this.closed) {
                    return;
                }
                this.clientStreamListener.headersRead(headers);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close(Status status, Metadata.Trailers trailers) {
                InProcessServerStream inProcessServerStream = this;
                synchronized (inProcessServerStream) {
                    if (this.closed) {
                        return;
                    }
                    if (this.clientReceiveQueue.isEmpty()) {
                        this.closed = true;
                        this.clientStreamListener.closed(status, trailers);
                    } else {
                        this.clientNotifyStatus = status;
                        this.clientNotifyTrailers = trailers;
                    }
                }
                InProcessStream.this.clientStream.serverClosed(Status.OK);
                InProcessStream.this.streamClosed();
            }

            @Override
            public void cancel(Status status) {
                if (!this.internalCancel(Status.CANCELLED.withDescription("server cancelled stream"))) {
                    return;
                }
                InProcessStream.this.clientStream.serverClosed(status);
                InProcessStream.this.streamClosed();
            }

            private synchronized boolean internalCancel(Status status) {
                InputStream stream;
                if (this.closed) {
                    return false;
                }
                this.closed = true;
                while ((stream = this.clientReceiveQueue.poll()) != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Exception closing stream", t);
                    }
                }
                this.clientStreamListener.closed(status, new Metadata.Trailers());
                return true;
            }
        }
    }
}

