/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.internal.MessageDeframer;
import io.grpc.internal.MessageFramer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.Stream;
import io.grpc.internal.StreamListener;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractStream<IdT>
implements Stream {
    public static final int DEFAULT_ONREADY_THRESHOLD = 32768;
    private final MessageFramer framer;
    private final MessageDeframer deframer;
    private Phase inboundPhase = Phase.HEADERS;
    private Phase outboundPhase = Phase.HEADERS;
    private int onReadyThreshold = 32768;
    private int numSentBytesQueued;
    @GuardedBy(value="onReadyLock")
    private boolean allocated;
    private final Object onReadyLock = new Object();

    AbstractStream(WritableBufferAllocator bufferAllocator) {
        MessageDeframer.Listener inboundMessageHandler = new MessageDeframer.Listener(){

            @Override
            public void bytesRead(int numBytes) {
                AbstractStream.this.returnProcessedBytes(numBytes);
            }

            @Override
            public void messageRead(InputStream input) {
                AbstractStream.this.receiveMessage(input);
            }

            @Override
            public void deliveryStalled() {
                AbstractStream.this.inboundDeliveryPaused();
            }

            @Override
            public void endOfStream() {
                AbstractStream.this.remoteEndClosed();
            }
        };
        MessageFramer.Sink outboundFrameHandler = new MessageFramer.Sink(){

            @Override
            public void deliverFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
                AbstractStream.this.internalSendFrame(frame, endOfStream, flush);
            }
        };
        this.framer = new MessageFramer(outboundFrameHandler, bufferAllocator);
        this.deframer = new MessageDeframer(inboundMessageHandler);
    }

    protected abstract StreamListener listener();

    @Nullable
    public abstract IdT id();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOnReadyThreshold() {
        Object object = this.onReadyLock;
        synchronized (object) {
            return this.onReadyThreshold;
        }
    }

    @Override
    public void writeMessage(InputStream message) {
        Preconditions.checkNotNull((Object)message);
        this.outboundPhase(Phase.MESSAGE);
        if (!this.framer.isClosed()) {
            this.framer.writePayload(message);
        }
    }

    @Override
    public final void flush() {
        if (!this.framer.isClosed()) {
            this.framer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isReady() {
        if (this.listener() != null && this.outboundPhase() != Phase.STATUS) {
            Object object = this.onReadyLock;
            synchronized (object) {
                return this.allocated && this.numSentBytesQueued < this.onReadyThreshold;
            }
        }
        return false;
    }

    final void closeFramer() {
        if (!this.framer.isClosed()) {
            this.framer.close();
        }
    }

    public void dispose() {
        this.framer.dispose();
    }

    protected abstract void internalSendFrame(WritableBuffer var1, boolean var2, boolean var3);

    protected abstract void receiveMessage(InputStream var1);

    protected abstract void inboundDeliveryPaused();

    protected abstract void remoteEndClosed();

    protected abstract void returnProcessedBytes(int var1);

    protected abstract void deframeFailed(Throwable var1);

    protected final void closeDeframer() {
        this.deframer.close();
    }

    protected final void deframe(ReadableBuffer frame, boolean endOfStream) {
        try {
            this.deframer.deframe(frame, endOfStream);
        }
        catch (Throwable t) {
            this.deframeFailed(t);
        }
    }

    protected final boolean isDeframerStalled() {
        return this.deframer.isStalled();
    }

    protected final void requestMessagesFromDeframer(int numMessages) {
        try {
            this.deframer.request(numMessages);
        }
        catch (Throwable t) {
            this.deframeFailed(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onStreamAllocated() {
        Preconditions.checkState((this.listener() != null ? 1 : 0) != 0);
        Object object = this.onReadyLock;
        synchronized (object) {
            Preconditions.checkState((!this.allocated ? 1 : 0) != 0, (Object)"Already allocated");
            this.allocated = true;
        }
        this.notifyIfReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onSendingBytes(int numBytes) {
        Object object = this.onReadyLock;
        synchronized (object) {
            this.numSentBytesQueued += numBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onSentBytes(int numBytes) {
        boolean doNotify;
        Object object = this.onReadyLock;
        synchronized (object) {
            boolean belowThresholdBefore = this.numSentBytesQueued < this.onReadyThreshold;
            this.numSentBytesQueued -= numBytes;
            boolean belowThresholdAfter = this.numSentBytesQueued < this.onReadyThreshold;
            doNotify = !belowThresholdBefore && belowThresholdAfter;
        }
        if (doNotify) {
            this.notifyIfReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final void notifyIfReady() {
        boolean doNotify = false;
        Object object = this.onReadyLock;
        synchronized (object) {
            doNotify = this.isReady();
        }
        if (doNotify) {
            this.listener().onReady();
        }
    }

    final Phase inboundPhase() {
        return this.inboundPhase;
    }

    final Phase inboundPhase(Phase nextPhase) {
        Phase tmp = this.inboundPhase;
        this.inboundPhase = this.verifyNextPhase(this.inboundPhase, nextPhase);
        return tmp;
    }

    final Phase outboundPhase() {
        return this.outboundPhase;
    }

    final Phase outboundPhase(Phase nextPhase) {
        Phase tmp = this.outboundPhase;
        this.outboundPhase = this.verifyNextPhase(this.outboundPhase, nextPhase);
        return tmp;
    }

    @VisibleForTesting
    Phase verifyNextPhase(Phase currentPhase, Phase nextPhase) {
        if (nextPhase.ordinal() < currentPhase.ordinal()) {
            throw new IllegalStateException(String.format("Cannot transition phase from %s to %s", new Object[]{currentPhase, nextPhase}));
        }
        return nextPhase;
    }

    public boolean canReceive() {
        return this.inboundPhase() != Phase.STATUS;
    }

    public boolean canSend() {
        return this.outboundPhase() != Phase.STATUS;
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.inboundPhase() == Phase.STATUS && this.outboundPhase() == Phase.STATUS;
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper((Object)this).add("id", this.id()).add("inboundPhase", (Object)this.inboundPhase().name()).add("outboundPhase", (Object)this.outboundPhase().name());
    }

    protected static enum Phase {
        HEADERS,
        MESSAGE,
        STATUS;

    }
}

