/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.Metadata;
import io.grpc.Status;
import javax.annotation.Nullable;

public final class HttpUtil {
    public static final Metadata.Key<String> CONTENT_TYPE_KEY = Metadata.Key.of("content-type", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> USER_AGENT_KEY = Metadata.Key.of("user-agent", Metadata.ASCII_STRING_MARSHALLER);
    public static final String CONTENT_TYPE_GRPC = "application/grpc";
    public static final String HTTP_METHOD = "POST";
    public static final String TE_TRAILERS = "trailers";
    public static final String TIMEOUT = "grpc-timeout";

    public static Status httpStatusToGrpcStatus(int httpStatusCode) {
        switch (httpStatusCode) {
            case 401: {
                return Status.UNAUTHENTICATED;
            }
            case 403: {
                return Status.PERMISSION_DENIED;
            }
        }
        if (httpStatusCode < 100) {
            return Status.UNKNOWN;
        }
        if (httpStatusCode < 200) {
            return Status.INTERNAL;
        }
        if (httpStatusCode < 300) {
            return Status.OK;
        }
        return Status.UNKNOWN;
    }

    public static String getGrpcUserAgent(String transportName, @Nullable String applicationUserAgent) {
        StringBuilder builder = new StringBuilder("grpc-java-").append(transportName);
        String version = HttpUtil.class.getPackage().getImplementationVersion();
        if (version != null) {
            builder.append("/");
            builder.append(version);
        }
        if (applicationUserAgent != null) {
            builder.append(' ');
            builder.append(applicationUserAgent);
        }
        return builder.toString();
    }

    private HttpUtil() {
    }

    public static enum Http2Error {
        NO_ERROR(0, Status.INTERNAL),
        PROTOCOL_ERROR(1, Status.INTERNAL),
        INTERNAL_ERROR(2, Status.INTERNAL),
        FLOW_CONTROL_ERROR(3, Status.INTERNAL),
        SETTINGS_TIMEOUT(4, Status.INTERNAL),
        STREAM_CLOSED(5, Status.INTERNAL),
        FRAME_SIZE_ERROR(6, Status.INTERNAL),
        REFUSED_STREAM(7, Status.UNAVAILABLE),
        CANCEL(8, Status.CANCELLED),
        COMPRESSION_ERROR(9, Status.INTERNAL),
        CONNECT_ERROR(10, Status.INTERNAL),
        ENHANCE_YOUR_CALM(11, Status.RESOURCE_EXHAUSTED.withDescription("Bandwidth exhausted")),
        INADEQUATE_SECURITY(12, Status.PERMISSION_DENIED.withDescription("Permission denied as protocol is not secure enough to call")),
        HTTP_1_1_REQUIRED(13, Status.UNKNOWN);

        private static final Http2Error[] codeMap;
        private final int code;
        private final Status status;

        private Http2Error(int code, Status status) {
            this.code = code;
            this.status = status.augmentDescription("HTTP/2 error code: " + this.name());
        }

        public long code() {
            return this.code;
        }

        public Status status() {
            return this.status;
        }

        public static Http2Error forCode(long code) {
            if (code >= (long)codeMap.length || code < 0L) {
                return null;
            }
            return codeMap[(int)code];
        }

        public static Status statusForCode(long code) {
            Http2Error error = Http2Error.forCode(code);
            if (error == null) {
                Status.Code statusCode = INTERNAL_ERROR.status().getCode();
                return Status.fromCodeValue(statusCode.value()).withDescription("Unrecognized HTTP/2 error code: " + code);
            }
            return error.status();
        }

        static {
            Http2Error[] errors = Http2Error.values();
            int size = (int)errors[errors.length - 1].code() + 1;
            codeMap = new Http2Error[size];
            for (Http2Error error : errors) {
                int index = (int)error.code();
                Http2Error.codeMap[index] = error;
            }
        }
    }
}

