/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.ExperimentalApi;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import java.util.concurrent.Executor;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4901")
public abstract class CallCredentials2
implements CallCredentials {
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1914")
    public abstract void applyRequestMetadata(CallCredentials.RequestInfo var1, Executor var2, CallCredentials.MetadataApplier var3);

    @Override
    public final void applyRequestMetadata(final MethodDescriptor<?, ?> method, final Attributes attrs, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        final String authority = (String)Preconditions.checkNotNull(attrs.get(ATTR_AUTHORITY), (Object)"authority");
        final SecurityLevel securityLevel = (SecurityLevel)((Object)MoreObjects.firstNonNull(attrs.get(ATTR_SECURITY_LEVEL), (Object)((Object)SecurityLevel.NONE)));
        CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

            @Override
            public MethodDescriptor<?, ?> getMethodDescriptor() {
                return method;
            }

            @Override
            public SecurityLevel getSecurityLevel() {
                return securityLevel;
            }

            @Override
            public String getAuthority() {
                return authority;
            }

            @Override
            public Attributes getTransportAttrs() {
                return attrs;
            }
        };
        this.applyRequestMetadata(requestInfo, appExecutor, applier);
    }
}

