/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Attributes {
    private final HashMap<Key<?>, Object> data = new HashMap();
    public static final Attributes EMPTY = new Attributes();

    private Attributes() {
    }

    @Nullable
    public <T> T get(Key<T> key) {
        return (T)this.data.get(key);
    }

    public Set<Key<?>> keys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public static Builder newBuilder(Attributes base) {
        return Attributes.newBuilder().setAll(base);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attributes that = (Attributes)o;
        return Objects.equal(this.data, that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public static final class Builder {
        private Attributes product = new Attributes();

        private Builder() {
        }

        public <T> Builder set(Key<T> key, T value) {
            this.product.data.put(key, value);
            return this;
        }

        public <T> Builder setAll(Attributes other) {
            this.product.data.putAll(other.data);
            return this;
        }

        public Attributes build() {
            Preconditions.checkState((this.product != null ? 1 : 0) != 0, (Object)"Already built");
            Attributes result = this.product;
            this.product = null;
            return result;
        }
    }

    public static final class Key<T> {
        private final String name;

        private Key(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static <T> Key<T> of(String name) {
            return new Key<T>(name);
        }
    }
}

