/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import io.grpc.Metadata;
import java.nio.charset.Charset;

public final class InternalMetadata {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");

    public static <T> Metadata.Key<T> keyOf(String name, TrustedAsciiMarshaller<T> marshaller) {
        boolean isPseudo = name != null && !name.isEmpty() && name.charAt(0) == ':';
        return Metadata.Key.of(name, isPseudo, marshaller);
    }

    public static <T> Metadata.Key<T> keyOf(String name, Metadata.AsciiMarshaller<T> marshaller) {
        boolean isPseudo = name != null && !name.isEmpty() && name.charAt(0) == ':';
        return Metadata.Key.of(name, isPseudo, marshaller);
    }

    public static Metadata newMetadata(byte[] ... binaryValues) {
        return new Metadata(binaryValues);
    }

    public static Metadata newMetadata(int usedNames, byte[] ... binaryValues) {
        return new Metadata(usedNames, binaryValues);
    }

    public static byte[][] serialize(Metadata md) {
        return md.serialize();
    }

    public static int headerCount(Metadata md) {
        return md.headerCount();
    }

    public static interface TrustedAsciiMarshaller<T>
    extends Metadata.TrustedAsciiMarshaller<T> {
    }
}

