/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.OptionalMethod;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import javax.net.ssl.SSLSocket;

public class OkHttpProtocolNegotiator {
    private static Platform platform = Platform.get();
    private static final OptionalMethod<Socket> SET_USE_SESSION_TICKETS = new OptionalMethod(null, "setUseSessionTickets", new Class[]{Boolean.TYPE});
    private static final OptionalMethod<Socket> SET_HOSTNAME = new OptionalMethod(null, "setHostname", new Class[]{String.class});
    private static final OptionalMethod<Socket> GET_ALPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
    private static final OptionalMethod<Socket> SET_ALPN_PROTOCOLS = new OptionalMethod(null, "setAlpnProtocols", new Class[]{byte[].class});
    private static final OptionalMethod<Socket> GET_NPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getNpnSelectedProtocol", new Class[0]);
    private static boolean android = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String negotiate(SSLSocket sslSocket, String hostname, List<Protocol> protocols) throws IOException {
        OkHttpProtocolNegotiator.configureTlsExtensions(sslSocket, hostname, protocols);
        String negotiatedProtocol = OkHttpProtocolNegotiator.getSelectedProtocol(sslSocket);
        if (negotiatedProtocol == null) {
            try {
                sslSocket.startHandshake();
                negotiatedProtocol = OkHttpProtocolNegotiator.getSelectedProtocol(sslSocket);
                if (negotiatedProtocol == null) {
                    throw new RuntimeException("protocol negotiation failed");
                }
            }
            finally {
                OkHttpProtocolNegotiator.afterHandshake(sslSocket);
            }
        }
        return negotiatedProtocol;
    }

    private static void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        if (!android) {
            platform.configureTlsExtensions(sslSocket, hostname, protocols);
            return;
        }
        if (hostname != null) {
            SET_USE_SESSION_TICKETS.invokeOptionalWithoutCheckedException((Object)sslSocket, new Object[]{true});
            SET_HOSTNAME.invokeOptionalWithoutCheckedException((Object)sslSocket, new Object[]{hostname});
        }
        if (SET_ALPN_PROTOCOLS.isSupported((Object)sslSocket)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = Platform.concatLengthPrefixed(protocols);
            Object[] parameters = objectArray;
            SET_ALPN_PROTOCOLS.invokeWithoutCheckedException((Object)sslSocket, parameters);
        }
    }

    private static void afterHandshake(SSLSocket sslSocket) {
        if (!android) {
            platform.afterHandshake(sslSocket);
        }
    }

    public static String getSelectedProtocol(SSLSocket socket) {
        if (!android) {
            return platform.getSelectedProtocol(socket);
        }
        if (GET_ALPN_SELECTED_PROTOCOL.isSupported((Object)socket)) {
            try {
                byte[] alpnResult = (byte[])GET_ALPN_SELECTED_PROTOCOL.invokeWithoutCheckedException((Object)socket, new Object[0]);
                if (alpnResult != null) {
                    return new String(alpnResult, Util.UTF_8);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (GET_NPN_SELECTED_PROTOCOL.isSupported((Object)socket)) {
            try {
                byte[] npnResult = (byte[])GET_NPN_SELECTED_PROTOCOL.invokeWithoutCheckedException((Object)socket, new Object[0]);
                if (npnResult != null) {
                    return new String(npnResult, Util.UTF_8);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
        }
        catch (ClassNotFoundException ignored) {
            try {
                Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl");
            }
            catch (ClassNotFoundException ignored2) {
                android = false;
            }
        }
    }
}

