/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.OptionalMethod;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.net.Socket;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;

public class OkHttpProtocolNegotiator {
    private static final Platform PLATFORM = Platform.get();
    private static OkHttpProtocolNegotiator NEGOTIATOR = OkHttpProtocolNegotiator.createNegotiator();

    private OkHttpProtocolNegotiator() {
    }

    public static OkHttpProtocolNegotiator get() {
        return NEGOTIATOR;
    }

    private static OkHttpProtocolNegotiator createNegotiator() {
        boolean android = true;
        try {
            Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
        }
        catch (ClassNotFoundException ignored) {
            try {
                Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl");
            }
            catch (ClassNotFoundException ignored2) {
                android = false;
            }
        }
        return android ? new AndroidNegotiator() : new OkHttpProtocolNegotiator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String negotiate(SSLSocket sslSocket, String hostname, @Nullable List<Protocol> protocols) throws IOException {
        if (protocols != null) {
            this.configureTlsExtensions(sslSocket, hostname, protocols);
        }
        try {
            sslSocket.startHandshake();
            String negotiatedProtocol = this.getSelectedProtocol(sslSocket);
            if (negotiatedProtocol == null) {
                throw new RuntimeException("protocol negotiation failed");
            }
            String string = negotiatedProtocol;
            return string;
        }
        finally {
            PLATFORM.afterHandshake(sslSocket);
        }
    }

    protected void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        PLATFORM.configureTlsExtensions(sslSocket, hostname, protocols);
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return PLATFORM.getSelectedProtocol(socket);
    }

    private static class AndroidNegotiator
    extends OkHttpProtocolNegotiator {
        private static final OptionalMethod<Socket> SET_USE_SESSION_TICKETS = new OptionalMethod(null, "setUseSessionTickets", new Class[]{Boolean.TYPE});
        private static final OptionalMethod<Socket> SET_HOSTNAME = new OptionalMethod(null, "setHostname", new Class[]{String.class});
        private static final OptionalMethod<Socket> GET_ALPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
        private static final OptionalMethod<Socket> SET_ALPN_PROTOCOLS = new OptionalMethod(null, "setAlpnProtocols", new Class[]{byte[].class});
        private static final OptionalMethod<Socket> GET_NPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getNpnSelectedProtocol", new Class[0]);
        private static final OptionalMethod<Socket> SET_NPN_PROTOCOLS = new OptionalMethod(null, "setNpnProtocols", new Class[]{byte[].class});
        private static TlsExtensionType tlsExtensionType;

        private AndroidNegotiator() {
        }

        @Override
        public String negotiate(SSLSocket sslSocket, String hostname, List<Protocol> protocols) throws IOException {
            String negotiatedProtocol = this.getSelectedProtocol(sslSocket);
            if (negotiatedProtocol == null) {
                negotiatedProtocol = super.negotiate(sslSocket, hostname, protocols);
            }
            return negotiatedProtocol;
        }

        @Override
        protected void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            if (hostname != null) {
                SET_USE_SESSION_TICKETS.invokeOptionalWithoutCheckedException((Object)sslSocket, new Object[]{true});
                SET_HOSTNAME.invokeOptionalWithoutCheckedException((Object)sslSocket, new Object[]{hostname});
            }
            Object[] parameters = new Object[]{Platform.concatLengthPrefixed(protocols)};
            if (tlsExtensionType == TlsExtensionType.ALPN_AND_NPN) {
                SET_ALPN_PROTOCOLS.invokeWithoutCheckedException((Object)sslSocket, parameters);
            }
            if (tlsExtensionType == null) {
                throw new RuntimeException("We can not do TLS handshake on this Android version, please install the Google Play Services Dynamic Security Provider to use TLS");
            }
            SET_NPN_PROTOCOLS.invokeWithoutCheckedException((Object)sslSocket, parameters);
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            if (tlsExtensionType == TlsExtensionType.ALPN_AND_NPN) {
                try {
                    byte[] alpnResult = (byte[])GET_ALPN_SELECTED_PROTOCOL.invokeWithoutCheckedException((Object)socket, new Object[0]);
                    if (alpnResult != null) {
                        return new String(alpnResult, Util.UTF_8);
                    }
                }
                catch (Exception alpnResult) {
                    // empty catch block
                }
            }
            if (tlsExtensionType != null) {
                try {
                    byte[] npnResult = (byte[])GET_NPN_SELECTED_PROTOCOL.invokeWithoutCheckedException((Object)socket, new Object[0]);
                    if (npnResult != null) {
                        return new String(npnResult, Util.UTF_8);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            Provider provider = Security.getProvider("GmsCore_OpenSSL");
            if (provider != null) {
                tlsExtensionType = TlsExtensionType.ALPN_AND_NPN;
            }
            if (tlsExtensionType == null) {
                try {
                    Class.forName("android.net.Network");
                    tlsExtensionType = TlsExtensionType.ALPN_AND_NPN;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (tlsExtensionType == null) {
                try {
                    Class.forName("android.app.ActivityOptions");
                    tlsExtensionType = TlsExtensionType.NPN;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }

        private static enum TlsExtensionType {
            ALPN_AND_NPN,
            NPN;

        }
    }
}

