/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.AbstractClientStream;
import io.grpc.internal.Http2ClientStreamTransportState;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.okhttp.AsyncFrameWriter;
import io.grpc.okhttp.Headers;
import io.grpc.okhttp.OkHttpClientTransport;
import io.grpc.okhttp.OkHttpReadableBuffer;
import io.grpc.okhttp.OkHttpWritableBuffer;
import io.grpc.okhttp.OkHttpWritableBufferAllocator;
import io.grpc.okhttp.OutboundFlowController;
import io.grpc.okhttp.Utils;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.Header;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import okio.Buffer;

class OkHttpClientStream
extends AbstractClientStream {
    private static final int WINDOW_UPDATE_THRESHOLD = Short.MAX_VALUE;
    private static final Buffer EMPTY_BUFFER = new Buffer();
    public static final int ABSENT_ID = -1;
    private final MethodDescriptor<?, ?> method;
    private final String userAgent;
    private final StatsTraceContext statsTraceCtx;
    private String authority;
    private Object outboundFlowState;
    private volatile int id = -1;
    private final TransportState state;
    private final Sink sink = new Sink();
    private boolean useGet = false;

    OkHttpClientStream(MethodDescriptor<?, ?> method, Metadata headers, AsyncFrameWriter frameWriter, OkHttpClientTransport transport, OutboundFlowController outboundFlow, Object lock, int maxMessageSize, String authority, String userAgent, StatsTraceContext statsTraceCtx) {
        super((WritableBufferAllocator)new OkHttpWritableBufferAllocator(), statsTraceCtx, headers, method.isSafe());
        this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        this.method = method;
        this.authority = authority;
        this.userAgent = userAgent;
        this.state = new TransportState(maxMessageSize, statsTraceCtx, lock, frameWriter, outboundFlow, transport);
    }

    protected TransportState transportState() {
        return this.state;
    }

    protected Sink abstractClientStreamSink() {
        return this.sink;
    }

    public MethodDescriptor.MethodType getType() {
        return this.method.getType();
    }

    public int id() {
        return this.id;
    }

    boolean useGet() {
        return this.useGet;
    }

    public void setAuthority(String authority) {
        this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
    }

    public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    void setOutboundFlowState(Object outboundFlowState) {
        this.outboundFlowState = outboundFlowState;
    }

    Object getOutboundFlowState() {
        return this.outboundFlowState;
    }

    private static class PendingData {
        Buffer buffer;
        boolean endOfStream;
        boolean flush;

        PendingData(Buffer buffer, boolean endOfStream, boolean flush) {
            this.buffer = buffer;
            this.endOfStream = endOfStream;
            this.flush = flush;
        }
    }

    class TransportState
    extends Http2ClientStreamTransportState {
        private final Object lock;
        @GuardedBy(value="lock")
        private List<Header> requestHeaders;
        @GuardedBy(value="lock")
        private Queue<PendingData> pendingData;
        @GuardedBy(value="lock")
        private boolean cancelSent;
        @GuardedBy(value="lock")
        private int window;
        @GuardedBy(value="lock")
        private int processedWindow;
        @GuardedBy(value="lock")
        private final AsyncFrameWriter frameWriter;
        @GuardedBy(value="lock")
        private final OutboundFlowController outboundFlow;
        @GuardedBy(value="lock")
        private final OkHttpClientTransport transport;

        public TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx, Object lock, AsyncFrameWriter frameWriter, OutboundFlowController outboundFlow, OkHttpClientTransport transport) {
            super(maxMessageSize, statsTraceCtx);
            this.pendingData = new ArrayDeque<PendingData>();
            this.cancelSent = false;
            this.window = 65535;
            this.processedWindow = 65535;
            this.lock = Preconditions.checkNotNull((Object)lock, (Object)"lock");
            this.frameWriter = frameWriter;
            this.outboundFlow = outboundFlow;
            this.transport = transport;
        }

        @GuardedBy(value="lock")
        public void start(int streamId) {
            Preconditions.checkState((OkHttpClientStream.this.id == -1 ? 1 : 0) != 0, (String)"the stream has been started with id %s", (Object[])new Object[]{streamId});
            OkHttpClientStream.this.id = streamId;
            OkHttpClientStream.this.state.onStreamAllocated();
            if (this.pendingData != null) {
                this.frameWriter.synStream(OkHttpClientStream.this.useGet, false, OkHttpClientStream.this.id, 0, this.requestHeaders);
                OkHttpClientStream.this.statsTraceCtx.clientOutboundHeaders();
                this.requestHeaders = null;
                boolean flush = false;
                while (!this.pendingData.isEmpty()) {
                    PendingData data = this.pendingData.poll();
                    this.outboundFlow.data(data.endOfStream, OkHttpClientStream.this.id, data.buffer, false);
                    if (!data.flush) continue;
                    flush = true;
                }
                if (flush) {
                    this.outboundFlow.flush();
                }
                this.pendingData = null;
            }
        }

        @GuardedBy(value="lock")
        protected void onStreamAllocated() {
            super.onStreamAllocated();
        }

        @GuardedBy(value="lock")
        protected void http2ProcessingFailed(Status status, boolean stopDelivery, Metadata trailers) {
            this.cancel(status, stopDelivery, trailers);
        }

        @GuardedBy(value="lock")
        public void deframeFailed(Throwable cause) {
            this.http2ProcessingFailed(Status.fromThrowable((Throwable)cause), true, new Metadata());
        }

        @GuardedBy(value="lock")
        public void bytesRead(int processedBytes) {
            this.processedWindow -= processedBytes;
            if (this.processedWindow <= Short.MAX_VALUE) {
                int delta = 65535 - this.processedWindow;
                this.window += delta;
                this.processedWindow += delta;
                this.frameWriter.windowUpdate(OkHttpClientStream.this.id(), delta);
            }
        }

        @GuardedBy(value="lock")
        public void deframerClosed(boolean hasPartialMessageIgnored) {
            this.onEndOfStream();
            super.deframerClosed(hasPartialMessageIgnored);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value="lock")
        public void runOnTransportThread(Runnable r) {
            Object object = this.lock;
            synchronized (object) {
                r.run();
            }
        }

        @GuardedBy(value="lock")
        public void transportHeadersReceived(List<Header> headers, boolean endOfStream) {
            if (endOfStream) {
                this.transportTrailersReceived(Utils.convertTrailers(headers));
            } else {
                this.transportHeadersReceived(Utils.convertHeaders(headers));
            }
        }

        @GuardedBy(value="lock")
        public void transportDataReceived(Buffer frame, boolean endOfStream) {
            int length = (int)frame.size();
            this.window -= length;
            if (this.window < 0) {
                this.frameWriter.rstStream(OkHttpClientStream.this.id(), ErrorCode.FLOW_CONTROL_ERROR);
                this.transport.finishStream(OkHttpClientStream.this.id(), Status.INTERNAL.withDescription("Received data size exceeded our receiving window size"), false, null, null);
                return;
            }
            super.transportDataReceived((ReadableBuffer)new OkHttpReadableBuffer(frame), endOfStream);
        }

        @GuardedBy(value="lock")
        private void onEndOfStream() {
            if (!OkHttpClientStream.this.framer().isClosed()) {
                this.transport.finishStream(OkHttpClientStream.this.id(), null, false, ErrorCode.CANCEL, null);
            } else {
                this.transport.finishStream(OkHttpClientStream.this.id(), null, false, null, null);
            }
        }

        @GuardedBy(value="lock")
        private void cancel(Status reason, boolean stopDelivery, Metadata trailers) {
            if (this.cancelSent) {
                return;
            }
            this.cancelSent = true;
            if (this.pendingData != null) {
                this.transport.removePendingStream(OkHttpClientStream.this);
                this.requestHeaders = null;
                for (PendingData data : this.pendingData) {
                    data.buffer.clear();
                }
                this.pendingData = null;
                this.transportReportStatus(reason, true, trailers != null ? trailers : new Metadata());
            } else {
                this.transport.finishStream(OkHttpClientStream.this.id(), reason, stopDelivery, ErrorCode.CANCEL, trailers);
            }
        }

        @GuardedBy(value="lock")
        private void sendBuffer(Buffer buffer, boolean endOfStream, boolean flush) {
            if (this.cancelSent) {
                return;
            }
            if (this.pendingData != null) {
                this.pendingData.add(new PendingData(buffer, endOfStream, flush));
            } else {
                Preconditions.checkState((OkHttpClientStream.this.id() != -1 ? 1 : 0) != 0, (Object)"streamId should be set");
                this.outboundFlow.data(endOfStream, OkHttpClientStream.this.id(), buffer, flush);
            }
        }

        @GuardedBy(value="lock")
        private void streamReady(Metadata metadata, String path) {
            this.requestHeaders = Headers.createRequestHeaders(metadata, path, OkHttpClientStream.this.authority, OkHttpClientStream.this.userAgent, OkHttpClientStream.this.useGet);
            this.transport.streamReadyToStart(OkHttpClientStream.this);
        }
    }

    class Sink
    implements AbstractClientStream.Sink {
        Sink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeHeaders(Metadata metadata, byte[] payload) {
            String defaultPath = "/" + OkHttpClientStream.this.method.getFullMethodName();
            if (payload != null) {
                OkHttpClientStream.this.useGet = true;
                defaultPath = defaultPath + "?" + BaseEncoding.base64().encode(payload);
            }
            Object object = OkHttpClientStream.this.state.lock;
            synchronized (object) {
                OkHttpClientStream.this.state.streamReady(metadata, defaultPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
            Buffer buffer;
            if (frame == null) {
                buffer = EMPTY_BUFFER;
            } else {
                buffer = ((OkHttpWritableBuffer)frame).buffer();
                int size = (int)buffer.size();
                if (size > 0) {
                    OkHttpClientStream.this.onSendingBytes(size);
                }
            }
            Object object = OkHttpClientStream.this.state.lock;
            synchronized (object) {
                OkHttpClientStream.this.state.sendBuffer(buffer, endOfStream, flush);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(int numMessages) {
            Object object = OkHttpClientStream.this.state.lock;
            synchronized (object) {
                OkHttpClientStream.this.state.requestMessagesFromDeframer(numMessages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Status reason) {
            Object object = OkHttpClientStream.this.state.lock;
            synchronized (object) {
                OkHttpClientStream.this.state.cancel(reason, true, null);
            }
        }
    }
}

