/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;

public class ServerCalls {
    private ServerCalls() {
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncUnaryCall(UnaryMethod<ReqT, RespT> method) {
        return ServerCalls.asyncUnaryRequestCall(method);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncServerStreamingCall(ServerStreamingMethod<ReqT, RespT> method) {
        return ServerCalls.asyncUnaryRequestCall(method);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncClientStreamingCall(ClientStreamingMethod<ReqT, RespT> method) {
        return ServerCalls.asyncStreamingRequestCall(method);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncBidiStreamingCall(BidiStreamingMethod<ReqT, RespT> method) {
        return ServerCalls.asyncStreamingRequestCall(method);
    }

    private static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncUnaryRequestCall(final UnaryRequestMethod<ReqT, RespT> method) {
        return new ServerCallHandler<ReqT, RespT>(){

            public ServerCall.Listener<ReqT> startCall(MethodDescriptor<ReqT, RespT> methodDescriptor, final ServerCall<RespT> call, Metadata headers) {
                final ServerCallStreamObserverImpl responseObserver = new ServerCallStreamObserverImpl(call);
                call.request(2);
                return new EmptyServerCallListener<ReqT>(){
                    ReqT request;

                    @Override
                    public void onMessage(ReqT request) {
                        this.request = request;
                    }

                    @Override
                    public void onHalfClose() {
                        if (this.request != null) {
                            method.invoke(this.request, responseObserver);
                            responseObserver.freeze();
                            if (call.isReady()) {
                                this.onReady();
                            }
                        } else {
                            call.close(Status.INVALID_ARGUMENT.withDescription("Half-closed without a request"), new Metadata());
                        }
                    }

                    @Override
                    public void onCancel() {
                        responseObserver.cancelled = true;
                        if (responseObserver.onCancelHandler != null) {
                            responseObserver.onCancelHandler.run();
                        }
                    }

                    public void onReady() {
                        if (responseObserver.onReadyHandler != null) {
                            responseObserver.onReadyHandler.run();
                        }
                    }
                };
            }
        };
    }

    private static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncStreamingRequestCall(final StreamingRequestMethod<ReqT, RespT> method) {
        return new ServerCallHandler<ReqT, RespT>(){

            public ServerCall.Listener<ReqT> startCall(MethodDescriptor<ReqT, RespT> methodDescriptor, final ServerCall<RespT> call, Metadata headers) {
                final ServerCallStreamObserverImpl responseObserver = new ServerCallStreamObserverImpl(call);
                final StreamObserver requestObserver = method.invoke(responseObserver);
                responseObserver.freeze();
                if (responseObserver.autoFlowControlEnabled) {
                    call.request(1);
                }
                return new EmptyServerCallListener<ReqT>(){
                    boolean halfClosed = false;

                    @Override
                    public void onMessage(ReqT request) {
                        requestObserver.onNext(request);
                        if (responseObserver.autoFlowControlEnabled) {
                            call.request(1);
                        }
                    }

                    @Override
                    public void onHalfClose() {
                        this.halfClosed = true;
                        requestObserver.onCompleted();
                    }

                    @Override
                    public void onCancel() {
                        responseObserver.cancelled = true;
                        if (responseObserver.onCancelHandler != null) {
                            responseObserver.onCancelHandler.run();
                        }
                        if (!this.halfClosed) {
                            requestObserver.onError((Throwable)Status.CANCELLED.asException());
                        }
                    }

                    public void onReady() {
                        if (responseObserver.onReadyHandler != null) {
                            responseObserver.onReadyHandler.run();
                        }
                    }
                };
            }
        };
    }

    public static void asyncUnimplementedUnaryCall(MethodDescriptor<?, ?> methodDescriptor, StreamObserver<?> responseObserver) {
        Preconditions.checkNotNull(methodDescriptor);
        Preconditions.checkNotNull(responseObserver);
        responseObserver.onError((Throwable)Status.UNIMPLEMENTED.withDescription(String.format("Method %s is unimplemented", methodDescriptor.getFullMethodName())).asException());
    }

    public static <T> StreamObserver<T> asyncUnimplementedStreamingCall(MethodDescriptor<?, ?> methodDescriptor, StreamObserver<?> responseObserver) {
        ServerCalls.asyncUnimplementedUnaryCall(methodDescriptor, responseObserver);
        return new NoopStreamObserver();
    }

    static class NoopStreamObserver<V>
    implements StreamObserver<V> {
        NoopStreamObserver() {
        }

        @Override
        public void onNext(V value) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onCompleted() {
        }
    }

    private static class EmptyServerCallListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private EmptyServerCallListener() {
        }

        public void onMessage(ReqT request) {
        }

        public void onHalfClose() {
        }

        public void onCancel() {
        }

        public void onComplete() {
        }
    }

    private static class ServerCallStreamObserverImpl<RespT>
    extends ServerCallStreamObserver<RespT> {
        final ServerCall<RespT> call;
        volatile boolean cancelled;
        private boolean frozen;
        private boolean autoFlowControlEnabled = true;
        private boolean sentHeaders;
        private Runnable onReadyHandler;
        private Runnable onCancelHandler;

        ServerCallStreamObserverImpl(ServerCall<RespT> call) {
            this.call = call;
        }

        private final void freeze() {
            this.frozen = true;
        }

        @Override
        public void onNext(RespT response) {
            if (this.cancelled) {
                throw Status.CANCELLED.asRuntimeException();
            }
            if (!this.sentHeaders) {
                this.call.sendHeaders(new Metadata());
                this.sentHeaders = true;
            }
            this.call.sendMessage(response);
        }

        @Override
        public void onError(Throwable t) {
            this.call.close(Status.fromThrowable((Throwable)t), new Metadata());
        }

        @Override
        public void onCompleted() {
            if (this.cancelled) {
                throw Status.CANCELLED.asRuntimeException();
            }
            this.call.close(Status.OK, new Metadata());
        }

        @Override
        public boolean isReady() {
            return this.call.isReady();
        }

        @Override
        public void setOnReadyHandler(Runnable r) {
            if (this.frozen) {
                throw new IllegalStateException("Cannot alter onReadyHandler after initialization");
            }
            this.onReadyHandler = r;
        }

        @Override
        public boolean isCancelled() {
            return this.call.isCancelled();
        }

        @Override
        public void setOnCancelHandler(Runnable onCancelHandler) {
            if (this.frozen) {
                throw new IllegalStateException("Cannot alter onCancelHandler after initialization");
            }
            this.onCancelHandler = onCancelHandler;
        }

        @Override
        public void disableAutoInboundFlowControl() {
            if (this.frozen) {
                throw new IllegalStateException("Cannot disable auto flow control after initialization");
            }
            this.autoFlowControlEnabled = false;
        }

        @Override
        public void request(int count) {
            this.call.request(count);
        }
    }

    private static interface StreamingRequestMethod<ReqT, RespT> {
        public StreamObserver<ReqT> invoke(StreamObserver<RespT> var1);
    }

    private static interface UnaryRequestMethod<ReqT, RespT> {
        public void invoke(ReqT var1, StreamObserver<RespT> var2);
    }

    public static interface BidiStreamingMethod<ReqT, RespT>
    extends StreamingRequestMethod<ReqT, RespT> {
    }

    public static interface ClientStreamingMethod<ReqT, RespT>
    extends StreamingRequestMethod<ReqT, RespT> {
    }

    public static interface ServerStreamingMethod<ReqT, RespT>
    extends UnaryRequestMethod<ReqT, RespT> {
    }

    public static interface UnaryMethod<ReqT, RespT>
    extends UnaryRequestMethod<ReqT, RespT> {
    }
}

