/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.grpc.Call;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.MethodType;
import io.grpc.Status;
import io.grpc.stub.Method;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Calls {
    public static <RequestT, ResponseT> MethodDescriptor<RequestT, ResponseT> createMethodDescriptor(String fullServiceName, Method<RequestT, ResponseT> method) {
        return MethodDescriptor.create((MethodType)method.getType(), (String)(fullServiceName + "/" + method.getName()), (long)1L, (TimeUnit)TimeUnit.SECONDS, method.getRequestMarshaller(), method.getResponseMarshaller());
    }

    public static <ReqT, RespT> ListenableFuture<RespT> unaryFutureCall(Call<ReqT, RespT> call, ReqT param) {
        GrpcFuture<RespT> responseFuture = new GrpcFuture<RespT>(call);
        Calls.asyncServerStreamingCall(call, param, new UnaryStreamToFuture<RespT>(responseFuture));
        return responseFuture;
    }

    private static <V> V getUnchecked(Future<V> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() == null) {
                throw new UncheckedExecutionException((Throwable)e);
            }
            if (e.getCause() instanceof Error) {
                throw new ExecutionError((Error)e.getCause());
            }
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    public static <ReqT, RespT> RespT blockingUnaryCall(Call<ReqT, RespT> call, ReqT param) {
        try {
            return Calls.getUnchecked(Calls.unaryFutureCall(call, param));
        }
        catch (Throwable t) {
            call.cancel();
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static <ReqT, RespT> void asyncUnaryCall(Call<ReqT, RespT> call, ReqT param, StreamObserver<RespT> observer) {
        Calls.asyncServerStreamingCall(call, param, observer);
    }

    public static <ReqT, RespT> Iterator<RespT> blockingServerStreamingCall(Call<ReqT, RespT> call, ReqT param) {
        BlockingResponseStream result = new BlockingResponseStream(call);
        Calls.asyncServerStreamingCall(call, param, result.listener());
        return result;
    }

    public static <ReqT, RespT> void asyncServerStreamingCall(Call<ReqT, RespT> call, ReqT param, StreamObserver<RespT> responseObserver) {
        Calls.asyncServerStreamingCall(call, param, new StreamObserverToCallListenerAdapter<RespT>(call, responseObserver));
    }

    private static <ReqT, RespT> void asyncServerStreamingCall(Call<ReqT, RespT> call, ReqT param, Call.Listener<RespT> responseListener) {
        call.start(responseListener, new Metadata.Headers());
        call.request(1);
        try {
            call.sendPayload(param);
            call.halfClose();
        }
        catch (Throwable t) {
            call.cancel();
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static <ReqT, RespT> RespT blockingClientStreamingCall(Call<ReqT, RespT> call, Iterator<ReqT> clientStream) {
        GrpcFuture<RespT> responseFuture = new GrpcFuture<RespT>(call);
        call.start(new UnaryStreamToFuture<RespT>(responseFuture), new Metadata.Headers());
        try {
            while (clientStream.hasNext()) {
                call.sendPayload(clientStream.next());
            }
            call.halfClose();
        }
        catch (Throwable t) {
            call.cancel();
            throw Throwables.propagate((Throwable)t);
        }
        try {
            return Calls.getUnchecked(responseFuture);
        }
        catch (Throwable t) {
            call.cancel();
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static <ReqT, RespT> StreamObserver<ReqT> asyncClientStreamingCall(Call<ReqT, RespT> call, StreamObserver<RespT> responseObserver) {
        return Calls.duplexStreamingCall(call, responseObserver);
    }

    public static <ReqT, RespT> StreamObserver<ReqT> duplexStreamingCall(Call<ReqT, RespT> call, StreamObserver<RespT> responseObserver) {
        call.start(new StreamObserverToCallListenerAdapter<RespT>(call, responseObserver), new Metadata.Headers());
        call.request(1);
        return new CallToStreamObserverAdapter<ReqT>(call);
    }

    private static class BlockingResponseStream<T>
    implements Iterator<T> {
        private final BlockingQueue<Object> buffer = new ArrayBlockingQueue<Object>(2);
        private final Call.Listener<T> listener = new QueuingListener();
        private final Call<?, T> call;
        private Object last;

        private BlockingResponseStream(Call<?, T> call) {
            this.call = call;
        }

        Call.Listener<T> listener() {
            return this.listener;
        }

        @Override
        public boolean hasNext() {
            try {
                this.last = this.last == null ? this.buffer.take() : this.last;
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                throw new RuntimeException(ie);
            }
            if (this.last instanceof Throwable) {
                throw Throwables.propagate((Throwable)((Throwable)this.last));
            }
            return this.last != this;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object tmp;
                this.call.request(1);
                Object object = tmp = this.last;
                return (T)object;
            }
            finally {
                this.last = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class QueuingListener
        extends Call.Listener<T> {
            private boolean done = false;

            private QueuingListener() {
            }

            public void onHeaders(Metadata.Headers headers) {
            }

            public void onPayload(T value) {
                Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"Call already closed");
                BlockingResponseStream.this.buffer.add(value);
            }

            public void onClose(Status status, Metadata.Trailers trailers) {
                Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"Call already closed");
                if (status.isOk()) {
                    BlockingResponseStream.this.buffer.add(BlockingResponseStream.this);
                } else {
                    BlockingResponseStream.this.buffer.add(status.asRuntimeException());
                }
                this.done = true;
            }
        }
    }

    private static class GrpcFuture<RespT>
    extends AbstractFuture<RespT> {
        private final Call<?, RespT> call;

        GrpcFuture(Call<?, RespT> call) {
            this.call = call;
        }

        protected void interruptTask() {
            this.call.cancel();
        }

        protected boolean set(@Nullable RespT resp) {
            return super.set(resp);
        }

        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }

    private static class UnaryStreamToFuture<RespT>
    extends Call.Listener<RespT> {
        private final GrpcFuture<RespT> responseFuture;
        private RespT value;

        public UnaryStreamToFuture(GrpcFuture<RespT> responseFuture) {
            this.responseFuture = responseFuture;
        }

        public void onHeaders(Metadata.Headers headers) {
        }

        public void onPayload(RespT value) {
            if (this.value != null) {
                throw Status.INTERNAL.withDescription("More than one value received for unary call").asRuntimeException();
            }
            this.value = value;
        }

        public void onClose(Status status, Metadata.Trailers trailers) {
            if (status.isOk()) {
                if (this.value == null) {
                    this.responseFuture.setException(Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException().fillInStackTrace());
                }
                this.responseFuture.set(this.value);
            } else {
                this.responseFuture.setException((Throwable)status.asRuntimeException());
            }
        }
    }

    private static class StreamObserverToCallListenerAdapter<RespT>
    extends Call.Listener<RespT> {
        private final Call<?, RespT> call;
        private final StreamObserver<RespT> observer;

        public StreamObserverToCallListenerAdapter(Call<?, RespT> call, StreamObserver<RespT> observer) {
            this.call = call;
            this.observer = observer;
        }

        public void onHeaders(Metadata.Headers headers) {
        }

        public void onPayload(RespT payload) {
            this.observer.onValue(payload);
            this.call.request(1);
        }

        public void onClose(Status status, Metadata.Trailers trailers) {
            if (status.isOk()) {
                this.observer.onCompleted();
            } else {
                this.observer.onError((Throwable)status.asRuntimeException());
            }
        }
    }

    private static class CallToStreamObserverAdapter<T>
    implements StreamObserver<T> {
        private final Call<T, ?> call;

        public CallToStreamObserverAdapter(Call<T, ?> call) {
            this.call = call;
        }

        @Override
        public void onValue(T value) {
            this.call.sendPayload(value);
        }

        @Override
        public void onError(Throwable t) {
            this.call.cancel();
        }

        @Override
        public void onCompleted() {
            this.call.halfClose();
        }
    }
}

