/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ClientStreamTracer;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StreamListener;
import io.grpc.internal.testing.TestClientStreamTracer;
import io.grpc.internal.testing.TestServerStreamTracer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public abstract class AbstractTransportTest {
    private static final int TIMEOUT_MS = 1000;
    private static final Attributes.Key<String> ADDITIONAL_TRANSPORT_ATTR_KEY = Attributes.Key.of((String)"additional-attr");
    private InternalServer server;
    private ServerTransport serverTransport;
    private ManagedClientTransport client;
    private MethodDescriptor<String, String> methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNKNOWN).setFullMethodName("service/method").setRequestMarshaller((MethodDescriptor.Marshaller)StringMarshaller.INSTANCE).setResponseMarshaller((MethodDescriptor.Marshaller)StringMarshaller.INSTANCE).build();
    private CallOptions callOptions;
    private Metadata.Key<String> asciiKey = Metadata.Key.of((String)"ascii-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private Metadata.Key<String> binaryKey = Metadata.Key.of((String)"key-bin", (Metadata.BinaryMarshaller)StringBinaryMarshaller.INSTANCE);
    private ManagedClientTransport.Listener mockClientTransportListener = (ManagedClientTransport.Listener)Mockito.mock(ManagedClientTransport.Listener.class);
    private ClientStreamListener mockClientStreamListener = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
    private final BlockingQueue<InputStream> clientStreamMessageQueue = new LinkedBlockingQueue<InputStream>();
    private MockServerListener serverListener = new MockServerListener();
    private ArgumentCaptor<Status> statusCaptor = ArgumentCaptor.forClass(Status.class);
    private ArgumentCaptor<Throwable> throwableCaptor = ArgumentCaptor.forClass(Throwable.class);
    private ArgumentCaptor<Metadata> metadataCaptor = ArgumentCaptor.forClass(Metadata.class);
    private final ClientStreamTracer.Factory clientStreamTracerFactory = (ClientStreamTracer.Factory)Mockito.mock(ClientStreamTracer.Factory.class);
    private final TestClientStreamTracer clientStreamTracer1 = new TestClientStreamTracer();
    private final TestClientStreamTracer clientStreamTracer2 = new TestClientStreamTracer();
    private final ServerStreamTracer.Factory serverStreamTracerFactory = (ServerStreamTracer.Factory)Mockito.mock(ServerStreamTracer.Factory.class);
    private final TestServerStreamTracer serverStreamTracer1 = new TestServerStreamTracer();
    private final TestServerStreamTracer serverStreamTracer2 = new TestServerStreamTracer();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    protected abstract InternalServer newServer(List<ServerStreamTracer.Factory> var1);

    protected abstract InternalServer newServer(InternalServer var1, List<ServerStreamTracer.Factory> var2);

    protected abstract ManagedClientTransport newClientTransport(InternalServer var1);

    protected abstract String testAuthority(InternalServer var1);

    protected abstract boolean metricsExpected();

    @Before
    public void setUp() {
        this.server = this.newServer(Arrays.asList(this.serverStreamTracerFactory));
        Mockito.when((Object)this.clientStreamTracerFactory.newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class))).thenReturn((Object)this.clientStreamTracer1).thenReturn((Object)this.clientStreamTracer2);
        Mockito.when((Object)this.serverStreamTracerFactory.newServerStreamTracer(Matchers.anyString(), (Metadata)Matchers.any(Metadata.class))).thenReturn((Object)this.serverStreamTracer1).thenReturn((Object)this.serverStreamTracer2);
        this.callOptions = CallOptions.DEFAULT.withStreamTracerFactory(this.clientStreamTracerFactory);
        ((ClientStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                InputStream message;
                StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                while ((message = producer.next()) != null) {
                    AbstractTransportTest.this.clientStreamMessageQueue.add(message);
                }
                return null;
            }
        }).when((Object)this.mockClientStreamListener)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
    }

    @After
    public void tearDown() throws InterruptedException {
        if (!this.metricsExpected()) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.clientStreamTracerFactory});
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.serverStreamTracerFactory});
        }
        if (this.client != null) {
            this.client.shutdownNow(Status.UNKNOWN.withDescription("teardown"));
        }
        if (this.serverTransport != null) {
            this.serverTransport.shutdownNow(Status.UNKNOWN.withDescription("teardown"));
        }
        if (this.server != null) {
            this.server.shutdown();
            Assert.assertTrue((boolean)this.serverListener.waitForShutdown(1000L, TimeUnit.MILLISECONDS));
        }
    }

    @Test
    public void frameAfterRstStreamShouldNotBreakClientChannel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        stream.flush();
        stream.writeMessage(this.methodDescriptor.streamRequest((Object)"foo"));
        stream.flush();
        stream.cancel(Status.CANCELLED);
        stream.flush();
        serverStreamCreation.stream.writeHeaders(new Metadata());
        serverStreamCreation.stream.flush();
        serverStreamCreation.stream.writeMessage(this.methodDescriptor.streamResponse((Object)"bar"));
        serverStreamCreation.stream.flush();
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)250))).closed((Status)Matchers.eq((Object)Status.CANCELLED), (Metadata)Matchers.any(Metadata.class));
        ClientStreamListener mockClientStreamListener2 = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream.start(mockClientStreamListener2);
        serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        serverStreamCreation.stream.writeHeaders(new Metadata());
        serverStreamCreation.stream.flush();
        ((ClientStreamListener)Mockito.verify((Object)mockClientStreamListener2, (VerificationMode)Mockito.timeout((int)250))).headersRead((Metadata)Matchers.any(Metadata.class));
    }

    @Test
    public void serverNotListening() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.server.shutdown();
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(1000L, TimeUnit.MILLISECONDS));
        this.server = null;
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.UNAVAILABLE, (Status)this.statusCaptor.getValue());
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportReady();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void clientStartStop() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        Status shutdownReason = Status.UNAVAILABLE.withDescription("shutdown called");
        this.client.shutdown(shutdownReason);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)Matchers.same((Object)shutdownReason));
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void clientStartAndStopOnceConnected() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportReady();
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.client.shutdown(Status.UNAVAILABLE);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(1000L, TimeUnit.MILLISECONDS));
        this.server.shutdown();
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(1000L, TimeUnit.MILLISECONDS));
        this.server = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void serverAlreadyListening() throws Exception {
        this.client = null;
        this.server.start((ServerListener)this.serverListener);
        InternalServer server2 = this.newServer(this.server, Arrays.asList(this.serverStreamTracerFactory));
        this.thrown.expect(IOException.class);
        server2.start((ServerListener)new MockServerListener());
    }

    @Test
    public void openStreamPreventsTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        this.client.shutdown(Status.UNAVAILABLE);
        this.client = null;
        this.server.shutdown();
        this.serverTransport.shutdown();
        this.serverTransport = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(1000L, TimeUnit.MILLISECONDS));
        this.serverListener = new MockServerListener();
        this.server = this.newServer(this.server, Arrays.asList(this.serverStreamTracerFactory));
        this.server.start((ServerListener)this.serverListener);
        serverStream.writeHeaders(new Metadata());
        clientStream.halfClose();
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).headersRead((Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).halfClosed();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        Assert.assertFalse((boolean)serverTransportListener.isTerminated());
        clientStream.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void shutdownNowKillsClientStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.UNKNOWN.withDescription("test shutdownNow");
        this.client.shutdownNow(status);
        this.client = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverTransportListener.isTerminated());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)Matchers.same((Object)status), (Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture());
        Assert.assertFalse((boolean)((Status)this.statusCaptor.getValue()).isOk());
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
            Assert.assertSame((Object)status, (Object)this.clientStreamTracer1.getStatus());
            Assert.assertTrue((boolean)this.serverStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.serverStreamTracer1.getStatus());
        }
    }

    @Test
    public void shutdownNowKillsServerStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status shutdownStatus = Status.UNKNOWN.withDescription("test shutdownNow");
        this.serverTransport.shutdownNow(shutdownStatus);
        this.serverTransport = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverTransportListener.isTerminated());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertFalse((boolean)((Status)this.statusCaptor.getValue()).isOk());
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.clientStreamTracer1.getStatus());
            Assert.assertTrue((boolean)this.serverStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
            Assert.assertSame((Object)shutdownStatus, (Object)this.serverStreamTracer1.getStatus());
        }
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)Matchers.any(Status.class));
    }

    @Test
    public void ping() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)1000))).onSuccess(Matchers.anyLong());
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void ping_duringShutdown() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream.start(this.mockClientStreamListener);
        this.client.shutdown(Status.UNAVAILABLE);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)1000))).onSuccess(Matchers.anyLong());
        stream.cancel(Status.CANCELLED);
    }

    @Test
    public void ping_afterTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportReady();
        Status shutdownReason = Status.UNAVAILABLE.withDescription("shutdown called");
        this.client.shutdown(shutdownReason);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)1000))).onFailure((Throwable)this.throwableCaptor.capture());
        Status status = Status.fromThrowable((Throwable)((Throwable)this.throwableCaptor.getValue()));
        Assert.assertSame((Object)shutdownReason, (Object)status);
    }

    @Test
    public void newStream_duringShutdown() throws Exception {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.clientStreamTracerFactory});
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        if (this.metricsExpected()) {
            ((ClientStreamTracer.Factory)inOrder.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class));
        }
        stream.start(this.mockClientStreamListener);
        this.client.shutdown(Status.UNAVAILABLE);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        if (this.metricsExpected()) {
            ((ClientStreamTracer.Factory)inOrder.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class));
        }
        ClientStreamListener mockClientStreamListener2 = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        ((ClientStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                InputStream message;
                StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                while ((message = producer.next()) != null) {
                    message.close();
                }
                return null;
            }
        }).when((Object)mockClientStreamListener2)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
        stream2.start(mockClientStreamListener2);
        ((ClientStreamListener)Mockito.verify((Object)mockClientStreamListener2, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        AbstractTransportTest.assertCodeEquals(Status.UNAVAILABLE, (Status)this.statusCaptor.getValue());
        if (this.metricsExpected()) {
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.clientStreamTracer2.getStatus());
        }
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(20000L, TimeUnit.MILLISECONDS);
        serverStreamCreation.stream.close(Status.OK, new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
    }

    @Test
    public void newStream_afterTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportReady();
        Status shutdownReason = Status.UNAVAILABLE.withDescription("shutdown called");
        this.client.shutdown(shutdownReason);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        Thread.sleep(100L);
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream.start(this.mockClientStreamListener);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)Matchers.same((Object)shutdownReason), (Metadata)Matchers.any(Metadata.class));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
        if (this.metricsExpected()) {
            ((ClientStreamTracer.Factory)Mockito.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class));
            Assert.assertSame((Object)shutdownReason, (Object)this.clientStreamTracer1.getStatus());
            Assert.assertNull(this.serverStreamTracer1.getServerCall());
        }
    }

    @Test
    public void transportInUse_normalClose() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream stream1 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream1.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation1 = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream2.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation2 = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        stream1.halfClose();
        serverStreamCreation1.stream.close(Status.OK, new Metadata());
        stream2.halfClose();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        serverStreamCreation2.stream.close(Status.OK, new Metadata());
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(true);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(false);
    }

    @Test
    public void transportInUse_clientCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream stream1 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream1.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream2.start(this.mockClientStreamListener);
        stream1.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        stream2.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(true);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(false);
    }

    @Test
    public void basicStream() throws Exception {
        InOrder clientInOrder = Mockito.inOrder((Object[])new Object[]{this.clientStreamTracerFactory});
        InOrder serverInOrder = Mockito.inOrder((Object[])new Object[]{this.serverStreamTracerFactory});
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        Metadata clientHeaders = new Metadata();
        clientHeaders.put(this.asciiKey, (Object)"client");
        clientHeaders.put(this.asciiKey, (Object)"dupvalue");
        clientHeaders.put(this.asciiKey, (Object)"dupvalue");
        clientHeaders.put(this.binaryKey, (Object)"\u00e4binaryclient");
        Metadata clientHeadersCopy = new Metadata();
        clientHeadersCopy.merge(clientHeaders);
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, clientHeaders, this.callOptions);
        if (this.metricsExpected()) {
            ((ClientStreamTracer.Factory)clientInOrder.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.same((Object)this.callOptions), (Metadata)Matchers.same((Object)clientHeaders));
        }
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        }
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)clientHeadersCopy.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)serverStreamCreation.headers.getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)clientHeadersCopy.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)serverStreamCreation.headers.getAll(this.binaryKey)));
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        final LinkedBlockingQueue serverStreamMessageQueue = new LinkedBlockingQueue();
        ((ServerStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                InputStream message;
                StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                while ((message = producer.next()) != null) {
                    serverStreamMessageQueue.add(message);
                }
                return null;
            }
        }).when((Object)mockServerStreamListener)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
        if (this.metricsExpected()) {
            ((ServerStreamTracer.Factory)serverInOrder.verify((Object)this.serverStreamTracerFactory)).newServerStreamTracer((String)Matchers.eq((Object)this.methodDescriptor.getFullMethodName()), (Metadata)Matchers.any(Metadata.class));
        }
        Assert.assertEquals((Object)"additional attribute value", (Object)serverStream.getAttributes().get(ADDITIONAL_TRANSPORT_ATTR_KEY));
        Assert.assertNotNull((Object)serverStream.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
        serverStream.request(1);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).onReady();
        Assert.assertTrue((boolean)clientStream.isReady());
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)"Hello!"));
        if (this.metricsExpected()) {
            Truth.assertThat((Integer)this.clientStreamTracer1.getOutboundMessageCount()).isGreaterThan((Comparable)Integer.valueOf(0));
        }
        clientStream.flush();
        InputStream message = (InputStream)serverStreamMessageQueue.poll(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"Hello!", (Object)this.methodDescriptor.parseRequest(message));
        message.close();
        if (this.metricsExpected()) {
            Truth.assertThat((Integer)this.clientStreamTracer1.getOutboundMessageCount()).isGreaterThan((Comparable)Integer.valueOf(0));
            Truth.assertThat((Long)this.clientStreamTracer1.getOutboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.clientStreamTracer1.getOutboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Assert.assertEquals((long)1L, (long)this.serverStreamTracer1.getInboundMessageCount());
        }
        Assert.assertNull((String)"no additional message expected", serverStreamMessageQueue.poll());
        clientStream.halfClose();
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).halfClosed();
        if (this.metricsExpected()) {
            Truth.assertThat((Long)this.serverStreamTracer1.getInboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.serverStreamTracer1.getInboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
        }
        Metadata serverHeaders = new Metadata();
        serverHeaders.put(this.asciiKey, (Object)"server");
        serverHeaders.put(this.asciiKey, (Object)"dupvalue");
        serverHeaders.put(this.asciiKey, (Object)"dupvalue");
        serverHeaders.put(this.binaryKey, (Object)"\u00e4binaryserver");
        Metadata serverHeadersCopy = new Metadata();
        serverHeadersCopy.merge(serverHeaders);
        serverStream.writeHeaders(serverHeaders);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).headersRead((Metadata)this.metadataCaptor.capture());
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)serverHeadersCopy.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)serverHeadersCopy.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.binaryKey)));
        clientStream.request(1);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).onReady();
        Assert.assertTrue((boolean)serverStream.isReady());
        serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)"Hi. Who are you?"));
        if (this.metricsExpected()) {
            Assert.assertEquals((long)1L, (long)this.serverStreamTracer1.getOutboundMessageCount());
        }
        serverStream.flush();
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000).atLeast(1))).messagesAvailable((StreamListener.MessageProducer)Matchers.any(StreamListener.MessageProducer.class));
        message = this.clientStreamMessageQueue.poll(1000L, TimeUnit.MILLISECONDS);
        if (this.metricsExpected()) {
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Assert.assertTrue((boolean)this.clientStreamTracer1.getInboundHeaders());
            Truth.assertThat((Integer)this.clientStreamTracer1.getInboundMessageCount()).isGreaterThan((Comparable)Integer.valueOf(0));
        }
        Assert.assertEquals((Object)"Hi. Who are you?", (Object)this.methodDescriptor.parseResponse(message));
        if (this.metricsExpected()) {
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
        }
        message.close();
        Assert.assertNull((String)"no additional message expected", this.clientStreamMessageQueue.poll());
        Status status = Status.OK.withDescription("That was normal");
        Metadata trailers = new Metadata();
        trailers.put(this.asciiKey, (Object)"trailers");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.binaryKey, (Object)"\u00e4binarytrailers");
        serverStream.close(status, trailers);
        if (this.metricsExpected()) {
            Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
        }
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)this.metadataCaptor.capture());
        if (this.metricsExpected()) {
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.clientStreamTracer1.getStatus());
        }
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)((Status)this.statusCaptor.getValue()).getDescription());
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.binaryKey)));
    }

    @Test
    public void authorityPropagation() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        Metadata clientHeaders = new Metadata();
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, clientHeaders, this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        Assert.assertEquals((Object)this.testAuthority(this.server), (Object)serverStream.getAuthority());
    }

    @Test
    public void zeroMessageStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        clientStream.halfClose();
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).halfClosed();
        serverStream.writeHeaders(new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).headersRead((Metadata)Matchers.any(Metadata.class));
        Status status = Status.OK.withDescription("Nice talking to you");
        serverStream.close(status, new Metadata());
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)((Status)this.statusCaptor.getValue()).getDescription());
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
            Assert.assertTrue((boolean)this.clientStreamTracer1.getInboundHeaders());
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.clientStreamTracer1.getStatus());
            Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
        }
    }

    @Test
    public void earlyServerClose_withServerHeaders() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        ((ServerStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                InputStream message;
                StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                while ((message = producer.next()) != null) {
                    message.close();
                }
                return null;
            }
        }).when((Object)mockServerStreamListener)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
        serverStream.writeHeaders(new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).headersRead((Metadata)Matchers.any(Metadata.class));
        Status status = Status.OK.withDescription("Hello. Goodbye.").withCause((Throwable)new Exception());
        serverStream.close(status, new Metadata());
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)"Hello. Goodbye.", (Object)((Status)this.statusCaptor.getValue()).getDescription());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
            Assert.assertTrue((boolean)this.clientStreamTracer1.getInboundHeaders());
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.clientStreamTracer1.getStatus());
            Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
        }
    }

    @Test
    public void earlyServerClose_noServerHeaders() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.OK.withDescription("Hellogoodbye").withCause((Throwable)new Exception());
        Metadata trailers = new Metadata();
        trailers.put(this.asciiKey, (Object)"trailers");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.binaryKey, (Object)"\u00e4binarytrailers");
        serverStream.close(status, trailers);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)this.metadataCaptor.capture());
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)"Hellogoodbye", (Object)((Status)this.statusCaptor.getValue()).getDescription());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.binaryKey)));
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.clientStreamTracer1.getStatus());
            Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
        }
    }

    @Test
    public void earlyServerClose_serverFailure() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.INTERNAL.withDescription("I'm not listening").withCause((Throwable)new Exception());
        serverStream.close(status, new Metadata());
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)((Status)this.statusCaptor.getValue()).getDescription());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.clientStreamTracer1.getStatus());
            Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
        }
    }

    @Test
    public void clientCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        ((ServerStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                InputStream message;
                StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                while ((message = producer.next()) != null) {
                    message.close();
                }
                return null;
            }
        }).when((Object)mockServerStreamListener)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
        Status status = Status.CANCELLED.withDescription("Nevermind").withCause((Throwable)new Exception());
        clientStream.cancel(status);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)Matchers.same((Object)status), (Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture());
        Assert.assertNotEquals((Object)Status.Code.OK, (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
        Mockito.reset((Object[])new ServerStreamListener[]{mockServerStreamListener});
        Mockito.reset((Object[])new ClientStreamListener[]{this.mockClientStreamListener});
        clientStream.cancel(status);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class));
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
            Assert.assertSame((Object)status, (Object)this.clientStreamTracer1.getStatus());
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.serverStreamTracer1.getStatus());
        }
    }

    @Test
    public void clientCancelFromWithinMessageRead() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        final SettableFuture closedCalled = SettableFuture.create();
        final ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        final Status status = Status.CANCELLED.withDescription("nevermind");
        clientStream.start(new ClientStreamListener(){
            private boolean messageReceived = false;

            public void headersRead(Metadata headers) {
            }

            public void closed(Status status2, Metadata trailers) {
                Assert.assertEquals((Object)Status.CANCELLED.getCode(), (Object)status2.getCode());
                Assert.assertEquals((Object)"nevermind", (Object)status2.getDescription());
                closedCalled.set((Object)true);
            }

            public void messagesAvailable(StreamListener.MessageProducer producer) {
                InputStream message;
                while ((message = producer.next()) != null) {
                    Assert.assertFalse((String)"too many messages received", (boolean)this.messageReceived);
                    this.messageReceived = true;
                    Assert.assertEquals((Object)"foo", (Object)AbstractTransportTest.this.methodDescriptor.parseResponse(message));
                    clientStream.cancel(status);
                }
            }

            public void onReady() {
            }
        });
        clientStream.halfClose();
        clientStream.request(1);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).onReady();
        Assert.assertTrue((boolean)serverStream.isReady());
        serverStream.writeHeaders(new Metadata());
        serverStream.writeMessage(this.methodDescriptor.streamRequest((Object)"foo"));
        serverStream.flush();
        closedCalled.get(5L, TimeUnit.SECONDS);
        serverStream.close(Status.OK, new Metadata());
        if (this.metricsExpected()) {
            Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
            Assert.assertTrue((boolean)this.clientStreamTracer1.getInboundHeaders());
            Assert.assertEquals((long)1L, (long)this.clientStreamTracer1.getInboundMessageCount());
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Assert.assertSame((Object)status, (Object)this.clientStreamTracer1.getStatus());
            Assert.assertEquals((long)1L, (long)this.serverStreamTracer1.getOutboundMessageCount());
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Assert.assertTrue((boolean)this.serverStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
            Assert.assertNotNull((Object)this.serverStreamTracer1.getStatus());
        }
    }

    @Test
    public void serverCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.DEADLINE_EXCEEDED.withDescription("It was bound to happen").withCause((Throwable)new Exception());
        serverStream.cancel(status);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)Matchers.same((Object)status));
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        AbstractTransportTest.assertCodeEquals(Status.CANCELLED, (Status)this.statusCaptor.getValue());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
        if (this.metricsExpected()) {
            ((ClientStreamTracer.Factory)Mockito.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class));
            Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
            Assert.assertSame((Object)this.statusCaptor.getValue(), (Object)this.clientStreamTracer1.getStatus());
            ((ServerStreamTracer.Factory)Mockito.verify((Object)this.serverStreamTracerFactory)).newServerStreamTracer(Matchers.anyString(), (Metadata)Matchers.any(Metadata.class));
            Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
        }
        Mockito.reset((Object[])new ServerStreamListener[]{mockServerStreamListener});
        Mockito.reset((Object[])new ClientStreamListener[]{this.mockClientStreamListener});
        serverStream.cancel(status);
        this.doPingPong(this.serverListener);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class));
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
    }

    @Test
    public void flowControlPushBack() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        final LinkedBlockingQueue<InputStream> serverStreamMessageQueue = new LinkedBlockingQueue<InputStream>();
        ((ServerStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                InputStream message;
                StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                while ((message = producer.next()) != null) {
                    serverStreamMessageQueue.add(message);
                }
                return null;
            }
        }).when((Object)mockServerStreamListener)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
        serverStream.writeHeaders(new Metadata());
        int size = 1024;
        StringBuffer sb = new StringBuffer(size);
        for (int i = 0; i < size; ++i) {
            sb.append('a');
        }
        String largeMessage = sb.toString();
        serverStream.request(1);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).onReady();
        Assert.assertTrue((boolean)clientStream.isReady());
        int maxToSend = 10240;
        int clientSent = 0;
        while (clientStream.isReady()) {
            if (clientSent > 10240) {
                Assert.fail((String)"Too many messages sent before isReady() returned false");
            }
            clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
            clientStream.flush();
            ++clientSent;
        }
        Assert.assertTrue((clientSent > 0 ? 1 : 0) != 0);
        while (clientSent < 5) {
            clientStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            clientStream.flush();
            ++clientSent;
        }
        this.doPingPong(this.serverListener);
        int serverReceived = this.verifyMessageCountAndClose(serverStreamMessageQueue, 1);
        clientStream.request(1);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).onReady();
        Assert.assertTrue((boolean)serverStream.isReady());
        int serverSent = 0;
        while (serverStream.isReady()) {
            if (serverSent > 10240) {
                Assert.fail((String)"Too many messages sent before isReady() returned false");
            }
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
            ++serverSent;
        }
        Assert.assertTrue((serverSent > 0 ? 1 : 0) != 0);
        while (serverSent < 5) {
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
            ++serverSent;
        }
        this.doPingPong(this.serverListener);
        int clientReceived = this.verifyMessageCountAndClose(this.clientStreamMessageQueue, 1);
        serverStream.request(3);
        clientStream.request(3);
        this.doPingPong(this.serverListener);
        clientReceived += this.verifyMessageCountAndClose(this.clientStreamMessageQueue, 3);
        serverReceived += this.verifyMessageCountAndClose(serverStreamMessageQueue, 3);
        serverStream.request(clientSent);
        clientStream.request(serverSent);
        clientReceived += this.verifyMessageCountAndClose(this.clientStreamMessageQueue, serverSent - clientReceived);
        serverReceived += this.verifyMessageCountAndClose(serverStreamMessageQueue, clientSent - serverReceived);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000).times(2))).onReady();
        Assert.assertTrue((boolean)clientStream.isReady());
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000).times(2))).onReady();
        Assert.assertTrue((boolean)serverStream.isReady());
        for (int i = 0; i < 5; ++i) {
            clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
            clientStream.flush();
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
        }
        this.doPingPong(this.serverListener);
        clientReceived += this.verifyMessageCountAndClose(this.clientStreamMessageQueue, 4);
        serverReceived += this.verifyMessageCountAndClose(serverStreamMessageQueue, 4);
        serverStream.request(1);
        clientStream.request(1);
        clientReceived += this.verifyMessageCountAndClose(this.clientStreamMessageQueue, 1);
        serverReceived += this.verifyMessageCountAndClose(serverStreamMessageQueue, 1);
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
        clientStream.flush();
        clientStream.halfClose();
        this.doPingPong(this.serverListener);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.never())).halfClosed();
        serverStream.request(1);
        Assert.assertEquals((long)(clientSent + 6), (long)(serverReceived += this.verifyMessageCountAndClose(serverStreamMessageQueue, 1)));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).halfClosed();
        serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
        serverStream.flush();
        Status status = Status.OK.withDescription("... quite a lengthy discussion");
        serverStream.close(status, new Metadata());
        this.doPingPong(this.serverListener);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
        clientStream.request(1);
        Assert.assertEquals((long)(serverSent + 6), (long)(clientReceived += this.verifyMessageCountAndClose(this.clientStreamMessageQueue, 1)));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)((Status)this.statusCaptor.getValue()).getDescription());
    }

    private int verifyMessageCountAndClose(BlockingQueue<InputStream> messageQueue, int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            InputStream message = messageQueue.poll(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)message);
            message.close();
        }
        Assert.assertNull((String)"no additional message expected", messageQueue.poll());
        return count;
    }

    @Test
    public void interactionsAfterServerStreamCloseAreNoops() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListener clientListener = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        ((ClientStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                InputStream message;
                StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                while ((message = producer.next()) != null) {
                    message.close();
                }
                return null;
            }
        }).when((Object)clientListener)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
        clientStream.start(clientListener);
        StreamCreation server = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        clientStream.request(1);
        server.stream.close(Status.INTERNAL, new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)clientListener, (VerificationMode)Mockito.timeout((int)1000).times(1))).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
        Mockito.reset((Object[])new ClientStreamListener[]{clientListener});
        server.stream.writeHeaders(new Metadata());
        server.stream.writeMessage(this.methodDescriptor.streamResponse((Object)"response"));
        server.stream.close(Status.INTERNAL, new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)clientListener, (VerificationMode)Mockito.never())).headersRead((Metadata)Matchers.any(Metadata.class));
        ((ClientStreamListener)Mockito.verify((Object)clientListener, (VerificationMode)Mockito.never())).messagesAvailable((StreamListener.MessageProducer)Matchers.any(StreamListener.MessageProducer.class));
        ((ClientStreamListener)Mockito.verify((Object)clientListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
        this.doPingPong(this.serverListener);
    }

    @Test
    public void interactionsAfterClientStreamCancelAreNoops() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListener clientListener = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        clientStream.start(clientListener);
        StreamCreation server = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        server.stream.request(1);
        clientStream.cancel(Status.UNKNOWN);
        ((ServerStreamListener)Mockito.verify((Object)server.listener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)Matchers.any(Status.class));
        Mockito.reset((Object[])new ServerStreamListener[]{server.listener});
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)"request"));
        clientStream.halfClose();
        clientStream.cancel(Status.UNKNOWN);
        ((ServerStreamListener)Mockito.verify((Object)server.listener, (VerificationMode)Mockito.never())).messagesAvailable((StreamListener.MessageProducer)Matchers.any(StreamListener.MessageProducer.class));
        ((ServerStreamListener)Mockito.verify((Object)server.listener, (VerificationMode)Mockito.never())).halfClosed();
        ((ServerStreamListener)Mockito.verify((Object)server.listener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class));
        this.doPingPong(this.serverListener);
    }

    private void doPingPong(MockServerListener serverListener) throws InterruptedException {
        ManagedClientTransport client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(client.start((ManagedClientTransport.Listener)Mockito.mock(ManagedClientTransport.Listener.class)));
        ClientStream clientStream = client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListener mockClientStreamListener = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        ((ClientStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                InputStream message;
                StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                while ((message = producer.next()) != null) {
                    message.close();
                }
                return null;
            }
        }).when((Object)mockClientStreamListener)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
        clientStream.start(mockClientStreamListener);
        MockServerTransportListener serverTransportListener = serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        serverStream.close(Status.OK, new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)mockClientStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)1000))).closed((Status)Matchers.any(Status.class));
        client.shutdown(Status.UNAVAILABLE);
    }

    private static void assertCodeEquals(String message, Status expected, Status actual) {
        if (expected == null) {
            Assert.fail((String)"expected should not be null");
        }
        if (actual == null || !expected.getCode().equals((Object)actual.getCode())) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        }
    }

    private static void assertCodeEquals(Status expected, Status actual) {
        AbstractTransportTest.assertCodeEquals(null, expected, actual);
    }

    private static boolean waitForFuture(Future<?> future, long timeout, TimeUnit unit) throws InterruptedException {
        try {
            future.get(timeout, unit);
        }
        catch (ExecutionException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (TimeoutException ex) {
            return false;
        }
        return true;
    }

    private static void runIfNotNull(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    private static class StringBinaryMarshaller
    implements Metadata.BinaryMarshaller<String> {
        public static final StringBinaryMarshaller INSTANCE = new StringBinaryMarshaller();

        private StringBinaryMarshaller() {
        }

        public byte[] toBytes(String value) {
            return value.getBytes(Charsets.UTF_8);
        }

        public String parseBytes(byte[] serialized) {
            return new String(serialized, Charsets.UTF_8);
        }
    }

    private static class StringMarshaller
    implements MethodDescriptor.Marshaller<String> {
        public static final StringMarshaller INSTANCE = new StringMarshaller();

        private StringMarshaller() {
        }

        public InputStream stream(String value) {
            return new ByteArrayInputStream(value.getBytes(Charsets.UTF_8));
        }

        public String parse(InputStream stream) {
            try {
                return new String(ByteStreams.toByteArray((InputStream)stream), Charsets.UTF_8);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class StreamCreation {
        public final ServerStream stream;
        public final String method;
        public final Metadata headers;
        public final ServerStreamListener listener;

        public StreamCreation(ServerStream stream, String method, Metadata headers, ServerStreamListener listener) {
            this.stream = stream;
            this.method = method;
            this.headers = headers;
            this.listener = listener;
        }
    }

    private static class MockServerTransportListener
    implements ServerTransportListener {
        public final ServerTransport transport;
        public final BlockingQueue<StreamCreation> streams = new LinkedBlockingQueue<StreamCreation>();
        private final SettableFuture<?> terminated = SettableFuture.create();

        public MockServerTransportListener(ServerTransport transport) {
            this.transport = transport;
        }

        public void streamCreated(ServerStream stream, String method, Metadata headers) {
            ServerStreamListener listener = (ServerStreamListener)Mockito.mock(ServerStreamListener.class);
            ((ServerStreamListener)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    InputStream message;
                    StreamListener.MessageProducer producer = (StreamListener.MessageProducer)invocation.getArguments()[0];
                    while ((message = producer.next()) != null) {
                        message.close();
                    }
                    return null;
                }
            }).when((Object)listener)).messagesAvailable((StreamListener.MessageProducer)Matchers.any());
            this.streams.add(new StreamCreation(stream, method, headers, listener));
            stream.setListener(listener);
        }

        public Attributes transportReady(Attributes attributes) {
            return Attributes.newBuilder().setAll(attributes).set(ADDITIONAL_TRANSPORT_ATTR_KEY, (Object)"additional attribute value").build();
        }

        public void transportTerminated() {
            Assert.assertTrue((boolean)this.terminated.set(null));
        }

        public boolean waitForTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return AbstractTransportTest.waitForFuture(this.terminated, timeout, unit);
        }

        public boolean isTerminated() {
            return this.terminated.isDone();
        }

        public StreamCreation takeStreamOrFail(long timeout, TimeUnit unit) throws InterruptedException {
            StreamCreation stream = this.streams.poll(timeout, unit);
            if (stream == null) {
                Assert.fail((String)"Timed out waiting for server stream");
            }
            return stream;
        }
    }

    private static class MockServerListener
    implements ServerListener {
        public final BlockingQueue<MockServerTransportListener> listeners = new LinkedBlockingQueue<MockServerTransportListener>();
        private final SettableFuture<?> shutdown = SettableFuture.create();

        private MockServerListener() {
        }

        public ServerTransportListener transportCreated(ServerTransport transport) {
            MockServerTransportListener listener = new MockServerTransportListener(transport);
            this.listeners.add(listener);
            return listener;
        }

        public void serverShutdown() {
            Assert.assertTrue((boolean)this.shutdown.set(null));
        }

        public boolean waitForShutdown(long timeout, TimeUnit unit) throws InterruptedException {
            return AbstractTransportTest.waitForFuture(this.shutdown, timeout, unit);
        }

        public MockServerTransportListener takeListenerOrFail(long timeout, TimeUnit unit) throws InterruptedException {
            MockServerTransportListener listener = this.listeners.poll(timeout, unit);
            if (listener == null) {
                Assert.fail((String)"Timed out waiting for server transport");
            }
            return listener;
        }
    }
}

