/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import io.grpc.Status;
import io.grpc.StreamTracer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public interface TestStreamTracer {
    public void await() throws InterruptedException;

    public boolean await(long var1, TimeUnit var3) throws InterruptedException;

    public int getInboundMessageCount();

    public int getOutboundMessageCount();

    public Status getStatus();

    public long getInboundWireSize();

    public long getInboundUncompressedSize();

    public long getOutboundWireSize();

    public long getOutboundUncompressedSize();

    public static class TestBaseStreamTracer
    extends StreamTracer
    implements TestStreamTracer {
        protected final AtomicLong outboundWireSize = new AtomicLong();
        protected final AtomicLong inboundWireSize = new AtomicLong();
        protected final AtomicLong outboundUncompressedSize = new AtomicLong();
        protected final AtomicLong inboundUncompressedSize = new AtomicLong();
        protected final AtomicInteger inboundMessageCount = new AtomicInteger();
        protected final AtomicInteger outboundMessageCount = new AtomicInteger();
        protected final AtomicReference<Status> streamClosedStatus = new AtomicReference();
        protected final CountDownLatch streamClosed = new CountDownLatch(1);
        protected final AtomicBoolean failDuplicateCallbacks = new AtomicBoolean(true);

        @Override
        public void await() throws InterruptedException {
            this.streamClosed.await();
        }

        @Override
        public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.streamClosed.await(timeout, timeUnit);
        }

        @Override
        public int getInboundMessageCount() {
            return this.inboundMessageCount.get();
        }

        @Override
        public int getOutboundMessageCount() {
            return this.outboundMessageCount.get();
        }

        @Override
        public Status getStatus() {
            return this.streamClosedStatus.get();
        }

        @Override
        public long getInboundWireSize() {
            return this.inboundWireSize.get();
        }

        @Override
        public long getInboundUncompressedSize() {
            return this.inboundUncompressedSize.get();
        }

        @Override
        public long getOutboundWireSize() {
            return this.outboundWireSize.get();
        }

        @Override
        public long getOutboundUncompressedSize() {
            return this.outboundUncompressedSize.get();
        }

        public void outboundWireSize(long bytes) {
            this.outboundWireSize.addAndGet(bytes);
        }

        public void inboundWireSize(long bytes) {
            this.inboundWireSize.addAndGet(bytes);
        }

        public void outboundUncompressedSize(long bytes) {
            this.outboundUncompressedSize.addAndGet(bytes);
        }

        public void inboundUncompressedSize(long bytes) {
            this.inboundUncompressedSize.addAndGet(bytes);
        }

        public void streamClosed(Status status) {
            if (!this.streamClosedStatus.compareAndSet(null, status)) {
                if (this.failDuplicateCallbacks.get()) {
                    throw new AssertionError((Object)"streamClosed called more than once");
                }
            } else {
                this.streamClosed.countDown();
            }
        }

        public void inboundMessage() {
            this.inboundMessageCount.incrementAndGet();
        }

        public void outboundMessage() {
            this.outboundMessageCount.incrementAndGet();
        }
    }
}

