/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractSource;
import io.helidon.config.AbstractSourceBuilder;
import io.helidon.config.ClasspathSourceHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.OverrideSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class ClasspathOverrideSource
extends AbstractSource
implements OverrideSource {
    private final String resource;
    private final URL resourceUrl;

    ClasspathOverrideSource(Builder builder) {
        super(builder);
        this.resource = builder.resource;
        this.resourceUrl = builder.url;
    }

    @Override
    protected String uid() {
        return ClasspathSourceHelper.uid(this.resource);
    }

    @Override
    public Optional<ConfigContent.OverrideContent> load() throws ConfigException {
        InputStream inputStream;
        if (null == this.resourceUrl) {
            return Optional.empty();
        }
        try {
            inputStream = this.resourceUrl.openStream();
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read configuration from classpath, resource: " + this.resource, e);
        }
        OverrideSource.OverrideData data = OverrideSource.OverrideData.create(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return Optional.of(ConfigContent.OverrideContent.builder().data(data).build());
    }

    public static ClasspathOverrideSource create(Config config) {
        return ClasspathOverrideSource.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractSourceBuilder<Builder, Void>
    implements io.helidon.common.Builder<ClasspathOverrideSource> {
        private URL url;
        private String resource;

        private Builder() {
        }

        public ClasspathOverrideSource build() {
            return new ClasspathOverrideSource(this);
        }

        @Override
        public Builder config(Config metaConfig) {
            metaConfig.get("resource").asString().ifPresent(this::resource);
            return (Builder)super.config(metaConfig);
        }

        public Builder resource(String resource) {
            String cleaned = resource.startsWith("/") ? resource.substring(1) : resource;
            this.resource = resource;
            this.url = Thread.currentThread().getContextClassLoader().getResource(cleaned);
            return this;
        }
    }
}

