/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.OrderedProperties;
import io.helidon.config.spi.Source;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface OverrideSource
extends Source,
Supplier<OverrideSource> {
    @Override
    default public OverrideSource get() {
        return this;
    }

    public Optional<ConfigContent.OverrideContent> load() throws ConfigException;

    public static final class OverrideData {
        static final Function<String, Predicate<Config.Key>> WILDCARDS_TO_PREDICATE = s -> key -> Pattern.compile(s.replace("*", "\\w+").replace(".", "\\.")).matcher(key.toString()).matches();
        private List<Map.Entry<Predicate<Config.Key>, String>> data = new ArrayList<Map.Entry<Predicate<Config.Key>, String>>();

        private OverrideData(List<Map.Entry<Predicate<Config.Key>, String>> data) {
            this.data = data;
        }

        public static OverrideData create(List<Map.Entry<Predicate<Config.Key>, String>> data) {
            return new OverrideData(data);
        }

        public static OverrideData createFromWildcards(List<Map.Entry<String, String>> wildcards) {
            List<Map.Entry<Predicate<Config.Key>, String>> overrides = wildcards.stream().map(e -> new AbstractMap.SimpleEntry<Predicate<Config.Key>, String>(WILDCARDS_TO_PREDICATE.apply((String)e.getKey()), (String)e.getValue())).collect(Collectors.toList());
            return new OverrideData(overrides);
        }

        public static OverrideData create(Reader reader) {
            OrderedProperties properties = new OrderedProperties();
            try (Reader autoCloseableReader = reader;){
                properties.load(autoCloseableReader);
            }
            catch (IOException e2) {
                throw new ConfigException("Cannot load data from reader.", e2);
            }
            List<Map.Entry<Predicate<Config.Key>, String>> data = properties.orderedMap().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Predicate<Config.Key>, String>(WILDCARDS_TO_PREDICATE.apply((String)e.getKey()), (String)e.getValue())).collect(Collectors.toList());
            return OverrideData.create(data);
        }

        public static OverrideData empty() {
            return new OverrideData(List.of());
        }

        public List<Map.Entry<Predicate<Config.Key>, String>> data() {
            return this.data;
        }
    }
}

