/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.logger.Level;
import org.koin.core.registry.PropertyRegistry;
import org.koin.core.registry.PropertyRegistryExtKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"readDataFromFile", "Ljava/util/Properties;", "content", "", "loadEnvironmentProperties", "", "Lorg/koin/core/registry/PropertyRegistry;", "loadPropertiesFromFile", "fileName", "saveProperties", "properties", "koin-core"})
public final class PropertyRegistryExtKt {
    public static final void saveProperties(@NotNull PropertyRegistry $this$saveProperties, @NotNull Properties properties) {
        Map propertiesMapValues;
        Intrinsics.checkNotNullParameter((Object)$this$saveProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        $this$saveProperties.get_koin$koin_core().getLogger().log(Level.DEBUG, (Function0<String>)((Function0)new Function0<String>(properties){
            final /* synthetic */ Properties $properties;
            {
                this.$properties = $properties;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "load " + this.$properties.size() + " properties";
            }
        }));
        Map $this$forEach$iv = propertiesMapValues = MapsKt.toMap((Map)properties);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)$dstr$k$v.getKey();
            String v = (String)$dstr$k$v.getValue();
            $this$saveProperties.saveProperty$koin_core(k, v);
        }
    }

    public static final void loadPropertiesFromFile(@NotNull PropertyRegistry $this$loadPropertiesFromFile, @NotNull String fileName) {
        String content;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$loadPropertiesFromFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        $this$loadPropertiesFromFile.get_koin$koin_core().getLogger().log(Level.DEBUG, (Function0<String>)((Function0)new Function0<String>(fileName){
            final /* synthetic */ String $fileName;
            {
                this.$fileName = $fileName;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"load properties from ", (Object)this.$fileName);
            }
        }));
        URL uRL = Koin.class.getResource(fileName);
        if (uRL == null) {
            string = null;
        } else {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            string = content = new String(byArray, charset);
        }
        if (content == null) {
            throw new NoPropertyFileFoundException("No properties found for file '" + fileName + '\'');
        }
        $this$loadPropertiesFromFile.get_koin$koin_core().getLogger().log(Level.INFO, (Function0<String>)((Function0)new Function0<String>(fileName){
            final /* synthetic */ String $fileName;
            {
                this.$fileName = $fileName;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "loaded properties from file:'" + this.$fileName + '\'';
            }
        }));
        Properties properties = PropertyRegistryExtKt.readDataFromFile(content);
        PropertyRegistryExtKt.saveProperties($this$loadPropertiesFromFile, properties);
    }

    private static final Properties readDataFromFile(String content) {
        Properties properties = new Properties();
        String string = content;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    public static final void loadEnvironmentProperties(@NotNull PropertyRegistry $this$loadEnvironmentProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$loadEnvironmentProperties, (String)"<this>");
        $this$loadEnvironmentProperties.get_koin$koin_core().getLogger().log(Level.DEBUG, (Function0<String>)((Function0)loadEnvironmentProperties.1.INSTANCE));
        Properties sysProperties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)sysProperties, (String)"sysProperties");
        PropertyRegistryExtKt.saveProperties($this$loadEnvironmentProperties, sysProperties);
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv()");
        Properties properties = new Properties();
        properties.putAll(map);
        Properties sysEnvProperties = properties;
        PropertyRegistryExtKt.saveProperties($this$loadEnvironmentProperties, sysEnvProperties);
    }
}

