/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.annotation.KoinInternalApi;
import org.koin.core.error.ScopeAlreadyCreatedException;
import org.koin.core.module.Module;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.qualifier.QualifierKt;
import org.koin.core.qualifier.StringQualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\n\u0010\u0017\u001a\u00060\u000fj\u0002`\u0018H\u0001\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00020\u00102\n\u0010\u0017\u001a\u00060\u000fj\u0002`\u00182\u0006\u0010\u001b\u001a\u00020\b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0001\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\u00020\u001f2\n\u0010\u0017\u001a\u00060\u000fj\u0002`\u0018H\u0000\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b J\r\u0010#\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020\u001fH\u0002J\u0014\u0010&\u001a\u00020\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\nJ\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/koin/core/registry/ScopeRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "<init>", "(Lorg/koin/core/Koin;)V", "_scopeDefinitions", "Ljava/util/HashSet;", "Lorg/koin/core/qualifier/Qualifier;", "scopeDefinitions", "", "getScopeDefinitions", "()Ljava/util/Set;", "_scopes", "", "", "Lorg/koin/core/scope/Scope;", "rootScope", "getRootScope$annotations", "()V", "getRootScope", "()Lorg/koin/core/scope/Scope;", "getScopeOrNull", "scopeId", "Lorg/koin/core/scope/ScopeID;", "(Ljava/lang/String;)Lorg/koin/core/scope/Scope;", "createScope", "qualifier", "source", "(Ljava/lang/String;Lorg/koin/core/qualifier/Qualifier;Ljava/lang/Object;)Lorg/koin/core/scope/Scope;", "deleteScope", "", "deleteScope$koin_core", "(Ljava/lang/String;)V", "scope", "close", "close$koin_core", "closeAllScopes", "loadScopes", "modules", "Lorg/koin/core/module/Module;", "loadModule", "module", "Companion", "koin-core"})
@SourceDebugExtension(value={"SMAP\nScopeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeRegistry.kt\norg/koin/core/registry/ScopeRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1#2:115\n1863#3,2:116\n1863#3,2:118\n*S KotlinDebug\n*F\n+ 1 ScopeRegistry.kt\norg/koin/core/registry/ScopeRegistry\n*L\n92#1:116,2\n98#1:118,2\n*E\n"})
public final class ScopeRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Koin _koin;
    @NotNull
    private final HashSet<Qualifier> _scopeDefinitions;
    @NotNull
    private final Map<String, Scope> _scopes;
    @NotNull
    private final Scope rootScope;
    @NotNull
    private static final String ROOT_SCOPE_ID = "_root_";
    @NotNull
    private static final StringQualifier rootScopeQualifier = QualifierKt._q("_root_");

    public ScopeRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._scopeDefinitions = new HashSet();
        this._scopes = KoinPlatformTools.INSTANCE.safeHashMap();
        this.rootScope = new Scope(rootScopeQualifier, ROOT_SCOPE_ID, true, this._koin);
        this._scopeDefinitions.add(this.rootScope.getScopeQualifier());
        this._scopes.put(this.rootScope.getId(), this.rootScope);
    }

    @NotNull
    public final Set<Qualifier> getScopeDefinitions() {
        return this._scopeDefinitions;
    }

    @NotNull
    public final Scope getRootScope() {
        return this.rootScope;
    }

    @KoinInternalApi
    public static /* synthetic */ void getRootScope$annotations() {
    }

    @PublishedApi
    @Nullable
    public final Scope getScopeOrNull(@NotNull String scopeId) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        return this._scopes.get(scopeId);
    }

    @PublishedApi
    @NotNull
    public final Scope createScope(@NotNull String scopeId, @NotNull Qualifier qualifier, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        this._koin.getLogger().debug("| (+) Scope - id:'" + scopeId + "' q:'" + qualifier + '\'');
        if (!this._scopeDefinitions.contains(qualifier)) {
            this._koin.getLogger().debug("| Scope '" + qualifier + "' not defined. Creating it ...");
            this._scopeDefinitions.add(qualifier);
        }
        if (this._scopes.containsKey(scopeId)) {
            throw new ScopeAlreadyCreatedException("Scope with id '" + scopeId + "' is already created");
        }
        Scope scope = new Scope(qualifier, scopeId, false, this._koin, 4, null);
        Object object = source;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            this._koin.getLogger().debug("|- Scope source set id:'" + scopeId + "' -> " + source);
            scope.set_source(source);
        }
        Scope[] scopeArray = new Scope[]{this.rootScope};
        scope.linkTo(scopeArray);
        this._scopes.put(scopeId, scope);
        return scope;
    }

    public static /* synthetic */ Scope createScope$default(ScopeRegistry scopeRegistry, String string, Qualifier qualifier, Object object, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        return scopeRegistry.createScope(string, qualifier, object);
    }

    public final void deleteScope$koin_core(@NotNull String scopeId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
            Scope scope = this._scopes.get(scopeId);
            if (scope == null) break block0;
            Scope it = scope;
            boolean bl = false;
            this.deleteScope$koin_core(it);
        }
    }

    public final void deleteScope$koin_core(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this._koin.getInstanceRegistry().dropScopeInstances$koin_core(scope);
        this._scopes.remove(scope.getId());
    }

    public final void close$koin_core() {
        this.closeAllScopes();
        this._scopes.clear();
        this._scopeDefinitions.clear();
    }

    private final void closeAllScopes() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this._scopes.values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope scope = (Scope)element$iv;
            boolean bl = false;
            scope.close();
        }
    }

    public final void loadScopes(@NotNull Set<Module> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            this.loadModule(it);
        }
    }

    private final void loadModule(Module module) {
        this._scopeDefinitions.addAll((Collection<Qualifier>)module.getScopes());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/koin/core/registry/ScopeRegistry$Companion;", "", "<init>", "()V", "ROOT_SCOPE_ID", "", "rootScopeQualifier", "Lorg/koin/core/qualifier/StringQualifier;", "getRootScopeQualifier$annotations", "getRootScopeQualifier", "()Lorg/koin/core/qualifier/StringQualifier;", "koin-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringQualifier getRootScopeQualifier() {
            return rootScopeQualifier;
        }

        @PublishedApi
        public static /* synthetic */ void getRootScopeQualifier$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

