/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.logger.Level;
import org.koin.core.logger.Logger;
import org.koin.core.module.KoinApplicationDslMarker;
import org.koin.core.module.Module;
import org.koin.core.option.KoinOption;
import org.koin.core.time.DurationExtKt;
import org.koin.mp.KoinPlatformTools;

@KoinApplicationDslMarker
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u001f\u0010\n\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\f\"\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\b\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\u001a\u0010\u0014\u001a\u00020\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010\u0016J7\u0010\u0018\u001a\u00020\u00002*\u0010\u0019\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a0\f\"\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u0010J\u001b\u0010#\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0000\u00a2\u0006\u0002\b$J\u0015\u0010#\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b$R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/koin/core/KoinApplication;", "", "<init>", "()V", "koin", "Lorg/koin/core/Koin;", "getKoin", "()Lorg/koin/core/Koin;", "allowOverride", "", "modules", "Lorg/koin/core/module/Module;", "", "([Lorg/koin/core/module/Module;)Lorg/koin/core/KoinApplication;", "", "createEagerInstances", "", "strictOverride", "override", "loadModules", "properties", "values", "", "", "options", "optionValue", "Lkotlin/Pair;", "Lorg/koin/core/option/KoinOption;", "([Lkotlin/Pair;)Lorg/koin/core/KoinApplication;", "logger", "Lorg/koin/core/logger/Logger;", "printLogger", "level", "Lorg/koin/core/logger/Level;", "close", "unloadModules", "unloadModules$koin_core", "module", "Companion", "koin-core"})
@SourceDebugExtension(value={"SMAP\nKoinApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoinApplication.kt\norg/koin/core/KoinApplication\n+ 2 Logger.kt\norg/koin/core/logger/Logger\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,162:1\n43#2:163\n24#3:164\n63#3,3:165\n*S KotlinDebug\n*F\n+ 1 KoinApplication.kt\norg/koin/core/KoinApplication\n*L\n63#1:163\n64#1:164\n64#1:165,3\n*E\n"})
public final class KoinApplication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Koin koin = new Koin();
    private boolean allowOverride = true;

    private KoinApplication() {
    }

    @NotNull
    public final Koin getKoin() {
        return this.koin;
    }

    @NotNull
    public final KoinApplication modules(@NotNull Module modules) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        return this.modules(CollectionsKt.listOf((Object)modules));
    }

    @NotNull
    public final KoinApplication modules(Module ... modules) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        return this.modules(ArraysKt.toList((Object[])modules));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KoinApplication modules(@NotNull List<Module> modules) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Logger logger = this.koin.getLogger();
        Level lvl$iv = Level.INFO;
        boolean $i$f$isAt = false;
        if (this_$iv.getLevel().compareTo((Enum)lvl$iv) <= 0) {
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            this.loadModules(modules);
            long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            int count = this.koin.getInstanceRegistry().size();
            this.koin.getLogger().display(Level.INFO, "Started " + count + " definitions in " + DurationExtKt.getInMs-LRDsOJo(duration) + " ms");
        } else {
            this.loadModules(modules);
        }
        return this;
    }

    public final void createEagerInstances() {
        this.koin.createEagerInstances();
    }

    public final void strictOverride() {
        this.allowOverride = false;
    }

    public final void allowOverride(boolean override) {
        this.allowOverride = override;
    }

    private final void loadModules(List<Module> modules) {
        this.koin.loadModules(modules, this.allowOverride, false);
    }

    @NotNull
    public final KoinApplication properties(@NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.koin.getPropertyRegistry().saveProperties(values);
        return this;
    }

    @NotNull
    public final KoinApplication options(Pair<? extends KoinOption, ? extends Object> ... optionValue) {
        Intrinsics.checkNotNullParameter(optionValue, (String)"optionValue");
        this.koin.getOptionRegistry().setValues$koin_core(MapsKt.toMap(optionValue));
        return this;
    }

    @NotNull
    public final KoinApplication logger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.koin.setupLogger(logger);
        return this;
    }

    @NotNull
    public final KoinApplication printLogger(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.koin.setupLogger(KoinPlatformTools.INSTANCE.defaultLogger(level));
        return this;
    }

    public static /* synthetic */ KoinApplication printLogger$default(KoinApplication koinApplication, Level level, int n, Object object) {
        if ((n & 1) != 0) {
            level = Level.INFO;
        }
        return koinApplication.printLogger(level);
    }

    public final void close() {
        this.koin.close();
    }

    public final void unloadModules$koin_core(@NotNull List<Module> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.koin.unloadModules(modules);
    }

    public final void unloadModules$koin_core(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.koin.unloadModules(CollectionsKt.listOf((Object)module));
    }

    public /* synthetic */ KoinApplication(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/koin/core/KoinApplication$Companion;", "", "<init>", "()V", "init", "Lorg/koin/core/KoinApplication;", "koin-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KoinApplication init() {
            KoinApplication app = new KoinApplication(null);
            return app;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

