/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.core.JavalinConfig;
import io.javalin.core.security.RouteRole;
import io.javalin.core.util.CorsPlugin;
import io.javalin.core.util.LogUtil;
import io.javalin.http.Context;
import io.javalin.http.ErrorMapper;
import io.javalin.http.ExceptionMapper;
import io.javalin.http.Handler;
import io.javalin.http.HandlerEntry;
import io.javalin.http.HandlerType;
import io.javalin.http.JavalinResponseWrapper;
import io.javalin.http.JavalinServletKt;
import io.javalin.http.MethodNotAllowedResponse;
import io.javalin.http.NotFoundResponse;
import io.javalin.http.PathMatcher;
import io.javalin.http.RequestLogger;
import io.javalin.http.ResponseWrapperContext;
import io.javalin.http.util.ContextUtil;
import io.javalin.http.util.MethodNotAllowedUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lio/javalin/http/JavalinServlet;", "Ljavax/servlet/http/HttpServlet;", "config", "Lio/javalin/core/JavalinConfig;", "(Lio/javalin/core/JavalinConfig;)V", "getConfig", "()Lio/javalin/core/JavalinConfig;", "errorMapper", "Lio/javalin/http/ErrorMapper;", "getErrorMapper", "()Lio/javalin/http/ErrorMapper;", "exceptionMapper", "Lio/javalin/http/ExceptionMapper;", "getExceptionMapper", "()Lio/javalin/http/ExceptionMapper;", "matcher", "Lio/javalin/http/PathMatcher;", "getMatcher", "()Lio/javalin/http/PathMatcher;", "addHandler", "", "handlerType", "Lio/javalin/http/HandlerType;", "path", "", "handler", "Lio/javalin/http/Handler;", "roles", "", "Lio/javalin/core/security/RouteRole;", "hasGetHandlerMapped", "", "requestUri", "isCorsEnabled", "service", "req", "Ljavax/servlet/http/HttpServletRequest;", "res", "Ljavax/servlet/http/HttpServletResponse;", "javalin"})
public final class JavalinServlet
extends HttpServlet {
    @NotNull
    private final JavalinConfig config;
    @NotNull
    private final PathMatcher matcher;
    @NotNull
    private final ExceptionMapper exceptionMapper;
    @NotNull
    private final ErrorMapper errorMapper;

    public JavalinServlet(@NotNull JavalinConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.matcher = new PathMatcher();
        this.exceptionMapper = new ExceptionMapper();
        this.errorMapper = new ErrorMapper();
    }

    @NotNull
    public final JavalinConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final PathMatcher getMatcher() {
        return this.matcher;
    }

    @NotNull
    public final ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    @NotNull
    public final ErrorMapper getErrorMapper() {
        return this.errorMapper;
    }

    protected void service(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        try {
            HandlerType type2 = HandlerType.Companion.fromServletRequest(req);
            ResponseWrapperContext rwc = new ResponseWrapperContext(req, this.config);
            String string = req.getRequestURI();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"req.requestURI");
            String string2 = string;
            string = req.getContextPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"req.contextPath");
            String requestUri = StringsKt.removePrefix((String)string2, (CharSequence)string);
            Map<String, Object> map = this.config.inner.appAttributes;
            Intrinsics.checkNotNullExpressionValue(map, (String)"config.inner.appAttributes");
            Context ctx = new Context(req, res, map);
            AtomicBoolean responseStarted = new AtomicBoolean(false);
            LogUtil.INSTANCE.setup(ctx, this.matcher, this.config.inner.requestLogger != null);
            String string3 = this.config.defaultContentType;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config.defaultContentType");
            ctx.contentType(string3);
            JavalinServlet.service$tryBeforeAndEndpointHandlers(this, requestUri, type2, req, res, rwc, ctx);
            CompletableFuture<?> completableFuture = ctx.resultFuture();
            if (completableFuture == null) {
                JavalinServlet.service$finishUpResponse(responseStarted, rwc, ctx, this, requestUri, (ServletResponse)res);
                return;
            }
            CompletableFuture<?> resultFuture = completableFuture;
            AsyncContext asyncContext = req.startAsync();
            boolean bl = false;
            boolean bl2 = false;
            AsyncContext $this$service_u24lambda_u2d0 = asyncContext;
            boolean bl3 = false;
            Long l = this.getConfig().asyncRequestTimeout;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"config.asyncRequestTimeout");
            $this$service_u24lambda_u2d0.setTimeout(((Number)l).longValue());
            AsyncContext asyncContext2 = asyncContext;
            Intrinsics.checkNotNullExpressionValue((Object)asyncContext2, (String)"asyncContext");
            JavalinServletKt.access$addTimeoutListener(asyncContext2, (Function0)new Function0<Unit>(ctx, asyncContext2, resultFuture, responseStarted, rwc, this, requestUri){
                final /* synthetic */ Context $ctx;
                final /* synthetic */ AsyncContext $asyncContext;
                final /* synthetic */ CompletableFuture<?> $resultFuture;
                final /* synthetic */ AtomicBoolean $responseStarted;
                final /* synthetic */ ResponseWrapperContext $rwc;
                final /* synthetic */ JavalinServlet this$0;
                final /* synthetic */ String $requestUri;
                {
                    this.$ctx = $ctx;
                    this.$asyncContext = $asyncContext;
                    this.$resultFuture = $resultFuture;
                    this.$responseStarted = $responseStarted;
                    this.$rwc = $rwc;
                    this.this$0 = $receiver;
                    this.$requestUri = $requestUri;
                    super(0);
                }

                public final void invoke() {
                    this.$ctx.status(500).result("Request timed out");
                    ServletResponse servletResponse = this.$asyncContext.getResponse();
                    Intrinsics.checkNotNullExpressionValue((Object)servletResponse, (String)"asyncContext.response");
                    JavalinServlet.access$service$finishUpResponse(this.$responseStarted, this.$rwc, this.$ctx, this.this$0, this.$requestUri, servletResponse);
                    servletResponse = Unit.INSTANCE;
                    AsyncContext asyncContext = this.$asyncContext;
                    boolean bl = false;
                    boolean bl2 = false;
                    ServletResponse it = servletResponse;
                    boolean bl3 = false;
                    asyncContext.complete();
                    this.$resultFuture.cancel(true);
                }
            });
            ((CompletableFuture)((CompletableFuture)resultFuture.exceptionally(new Function(this, ctx){
                final /* synthetic */ JavalinServlet this$0;
                final /* synthetic */ Context $ctx;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                }

                public final Void apply(Throwable throwable) {
                    ExceptionMapper exceptionMapper = this.this$0.getExceptionMapper();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"throwable");
                    return exceptionMapper.handleFutureException$javalin(this.$ctx, throwable);
                }
            })).thenAccept(arg_0 -> JavalinServlet.service$lambda-2(asyncContext2, ctx, this, responseStarted, rwc, requestUri, arg_0))).exceptionally(arg_0 -> JavalinServlet.service$lambda-4(this, res, asyncContext2, arg_0));
        }
        catch (Throwable throwable) {
            this.exceptionMapper.handleUnexpectedThrowable$javalin(res, throwable);
        }
    }

    private final boolean hasGetHandlerMapped(String requestUri) {
        Collection collection = this.matcher.findEntries(HandlerType.GET, requestUri);
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final void addHandler(@NotNull HandlerType handlerType, @NotNull String path, @NotNull Handler handler, @NotNull Set<? extends RouteRole> roles) {
        Intrinsics.checkNotNullParameter((Object)((Object)handlerType), (String)"handlerType");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Handler protectedHandler = handlerType.isHttpMethod() ? arg_0 -> JavalinServlet.addHandler$lambda-5(this, handler, roles, arg_0) : handler;
        this.matcher.add(new HandlerEntry(handlerType, path, this.config.ignoreTrailingSlashes, protectedHandler, handler));
    }

    private final boolean isCorsEnabled(JavalinConfig config) {
        return config.inner.plugins.get(CorsPlugin.class) != null;
    }

    private static final void service$tryWithExceptionMapper(JavalinServlet this$0, Context ctx, Function0<Unit> func) {
        ExceptionMapper this_$iv = this$0.exceptionMapper;
        boolean $i$f$catchException$javalin = false;
        try {
            func.invoke();
        }
        catch (Exception e$iv) {
            this_$iv.handle$javalin(e$iv, ctx);
        }
    }

    private static final void service$tryBeforeAndEndpointHandlers(JavalinServlet this$0, String requestUri, HandlerType type2, HttpServletRequest $req, HttpServletResponse $res, ResponseWrapperContext rwc, Context ctx) {
        JavalinServlet.service$tryWithExceptionMapper(this$0, ctx, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, requestUri, type2, $req, $res, rwc, ctx){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ String $requestUri;
            final /* synthetic */ HandlerType $type;
            final /* synthetic */ HttpServletRequest $req;
            final /* synthetic */ HttpServletResponse $res;
            final /* synthetic */ ResponseWrapperContext $rwc;
            final /* synthetic */ Context $ctx;
            {
                this.this$0 = $receiver;
                this.$requestUri = $requestUri;
                this.$type = $type;
                this.$req = $req;
                this.$res = $res;
                this.$rwc = $rwc;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                Object entry;
                Object $this$forEach$iv;
                Iterable iterable = this.this$0.getMatcher().findEntries(HandlerType.BEFORE, this.$requestUri);
                Object object = this.$ctx;
                Object object2 = this.$requestUri;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv = iterator.next();
                    entry = (HandlerEntry)element$iv;
                    boolean bl = false;
                    ((HandlerEntry)entry).getHandler().handle(ContextUtil.INSTANCE.update((Context)object, (HandlerEntry)entry, (String)object2));
                }
                $this$forEach$iv = (HandlerEntry)CollectionsKt.firstOrNull(this.this$0.getMatcher().findEntries(this.$type, this.$requestUri));
                if ($this$forEach$iv != null) {
                    object = $this$forEach$iv;
                    object2 = this.$ctx;
                    String string = this.$requestUri;
                    boolean bl = false;
                    boolean bl2 = false;
                    entry = object;
                    boolean bl3 = false;
                    ((HandlerEntry)entry).getHandler().handle(ContextUtil.INSTANCE.update((Context)object2, (HandlerEntry)entry, string));
                    return;
                }
                if (this.$type == HandlerType.HEAD && JavalinServlet.access$hasGetHandlerMapped(this.this$0, this.$requestUri)) {
                    return;
                }
                if (this.$type == HandlerType.HEAD || this.$type == HandlerType.GET) {
                    $this$forEach$iv = this.this$0.getConfig().inner.resourceHandler;
                    if ($this$forEach$iv == null ? false : $this$forEach$iv.handle(this.$req, (HttpServletResponse)new JavalinResponseWrapper(this.$res, this.$rwc))) {
                        return;
                    }
                    if (this.this$0.getConfig().inner.singlePageHandler.handle(this.$ctx)) {
                        return;
                    }
                }
                if (this.$type == HandlerType.OPTIONS && JavalinServlet.access$isCorsEnabled(this.this$0, this.this$0.getConfig())) {
                    return;
                }
                if (this.$ctx.getHandlerType$javalin() == HandlerType.BEFORE) {
                    this.$ctx.setEndpointHandlerPath$javalin("No handler matched request path/method (404/405)");
                }
                List<HandlerType> availableHandlerTypes = MethodNotAllowedUtil.INSTANCE.findAvailableHttpHandlerTypes(this.this$0.getMatcher(), this.$requestUri);
                if (this.this$0.getConfig().prefer405over404) {
                    object = availableHandlerTypes;
                    boolean bl = false;
                    if (!object.isEmpty()) {
                        throw new MethodNotAllowedResponse(null, MethodNotAllowedUtil.INSTANCE.getAvailableHandlerTypes(this.$ctx, availableHandlerTypes), 1, null);
                    }
                }
                throw new NotFoundResponse(null, null, 3, null);
            }
        }));
    }

    private static final void service$finishUpResponse(AtomicBoolean responseStarted, ResponseWrapperContext rwc, Context ctx, JavalinServlet this$0, String requestUri, ServletResponse response) {
        if (responseStarted.getAndSet(true)) {
            return;
        }
        JavalinServlet.service$tryWithExceptionMapper(this$0, ctx, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, ctx){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ Context $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            public final void invoke() {
                this.this$0.getErrorMapper().handle(this.$ctx.status(), this.$ctx);
            }
        }));
        JavalinServlet.service$tryWithExceptionMapper(this$0, ctx, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, requestUri, ctx){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ String $requestUri;
            final /* synthetic */ Context $ctx;
            {
                this.this$0 = $receiver;
                this.$requestUri = $requestUri;
                this.$ctx = $ctx;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Iterable iterable = this.this$0.getMatcher().findEntries(HandlerType.AFTER, this.$requestUri);
                Context context = this.$ctx;
                String string = this.$requestUri;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HandlerEntry entry = (HandlerEntry)element$iv;
                    boolean bl = false;
                    entry.getHandler().handle(ContextUtil.INSTANCE.update(context, entry, string));
                }
            }
        }));
        new JavalinResponseWrapper((HttpServletResponse)response, rwc).write(ctx.resultStream());
        RequestLogger requestLogger = this$0.config.inner.requestLogger;
        if (requestLogger != null) {
            requestLogger.handle(ctx, Float.valueOf(LogUtil.INSTANCE.executionTimeMs(ctx)));
        }
    }

    private static final void service$lambda-2(AsyncContext $asyncContext, Context $ctx, JavalinServlet this$0, AtomicBoolean $responseStarted, ResponseWrapperContext $rwc, String $requestUri, Object futureValue) {
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$responseStarted, (String)"$responseStarted");
        Intrinsics.checkNotNullParameter((Object)$rwc, (String)"$rwc");
        Intrinsics.checkNotNullParameter((Object)$requestUri, (String)"$requestUri");
        JavalinServlet.service$tryWithExceptionMapper(this$0, $ctx, (Function0<Unit>)((Function0)new Function0<Unit>($ctx, futureValue){
            final /* synthetic */ Context $ctx;
            final /* synthetic */ Object $futureValue;
            {
                this.$ctx = $ctx;
                this.$futureValue = $futureValue;
                super(0);
            }

            public final void invoke() {
                Consumer<Object> consumer = this.$ctx.getFutureConsumer$javalin();
                if (consumer != null) {
                    consumer.accept(this.$futureValue);
                }
            }
        }));
        ServletResponse servletResponse = $asyncContext.getResponse();
        Intrinsics.checkNotNullExpressionValue((Object)servletResponse, (String)"asyncContext.response");
        JavalinServlet.service$finishUpResponse($responseStarted, $rwc, $ctx, this$0, $requestUri, servletResponse);
        servletResponse = Unit.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        ServletResponse it = servletResponse;
        boolean bl3 = false;
        $asyncContext.complete();
    }

    private static final Void service$lambda-4(JavalinServlet this$0, HttpServletResponse $res, AsyncContext $asyncContext, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$res, (String)"$res");
        ExceptionMapper exceptionMapper = this$0.getExceptionMapper();
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"throwable");
        Void void_ = exceptionMapper.handleUnexpectedThrowable$javalin($res, throwable);
        boolean bl = false;
        boolean bl2 = false;
        Void it = void_;
        boolean bl3 = false;
        $asyncContext.complete();
        return void_;
    }

    private static final void addHandler$lambda-5(JavalinServlet this$0, Handler $handler, Set $roles, Context ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)$roles, (String)"$roles");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.getConfig().inner.accessManager.manage($handler, ctx, $roles);
    }

    public static final /* synthetic */ void access$service$finishUpResponse(AtomicBoolean responseStarted, ResponseWrapperContext rwc, Context ctx, JavalinServlet this$0, String requestUri, ServletResponse response) {
        JavalinServlet.service$finishUpResponse(responseStarted, rwc, ctx, this$0, requestUri, response);
    }

    public static final /* synthetic */ boolean access$hasGetHandlerMapped(JavalinServlet $this, String requestUri) {
        return $this.hasGetHandlerMapped(requestUri);
    }

    public static final /* synthetic */ boolean access$isCorsEnabled(JavalinServlet $this, JavalinConfig config) {
        return $this.isCorsEnabled(config);
    }
}

