/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import com.nixxcode.jvmbrotli.enc.BrotliOutputStream;
import io.javalin.http.LeveledBrotliStream;
import io.javalin.http.LeveledGzipStream;
import io.javalin.http.ResponseWrapperContext;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\bH\u0016J\u0012\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/javalin/http/OutputStreamWrapper;", "Ljavax/servlet/ServletOutputStream;", "res", "Ljavax/servlet/http/HttpServletResponse;", "rwc", "Lio/javalin/http/ResponseWrapperContext;", "(Ljavax/servlet/http/HttpServletResponse;Lio/javalin/http/ResponseWrapperContext;)V", "brotliEnabled", "", "compressingStream", "Ljava/io/OutputStream;", "gzipEnabled", "initialized", "getRes", "()Ljavax/servlet/http/HttpServletResponse;", "excludedMimeType", "mimeType", "", "finalizeCompression", "", "isReady", "setWriteListener", "writeListener", "Ljavax/servlet/WriteListener;", "write", "b", "", "off", "", "len", "Companion", "javalin"})
public final class OutputStreamWrapper
extends ServletOutputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpServletResponse res;
    @NotNull
    private final ResponseWrapperContext rwc;
    private OutputStream compressingStream;
    private boolean initialized;
    private boolean brotliEnabled;
    private boolean gzipEnabled;
    private static int minSizeForCompression = 1500;
    @NotNull
    private static final Set<String> excludedMimeTypes;

    public OutputStreamWrapper(@NotNull HttpServletResponse res, @NotNull ResponseWrapperContext rwc) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)rwc, (String)"rwc");
        this.res = res;
        this.rwc = rwc;
    }

    @NotNull
    public final HttpServletResponse getRes() {
        return this.res;
    }

    /*
     * Unable to fully structure code
     */
    public void write(@NotNull byte[] b, int off, int len) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (this.initialized) break block13;
            if (len < OutputStreamWrapper.minSizeForCompression || this.excludedMimeType((String)((var5_4 = this.res.getContentType()) == null ? "" : var5_4))) ** GOTO lbl-1000
            var5_4 = this.res.getHeader("Content-Encoding");
            var6_5 = false;
            var7_6 = false;
            if (var5_4 == null || var5_4.length() == 0) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = isCompressible = false;
            }
            if (isCompressible && this.rwc.getAcceptsBrotli() && this.rwc.getCompStrat().getBrotli() != null) {
                this.res.setHeader("Content-Encoding", "br");
                var5_4 = this.res.getOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)var5_4, (String)"res.outputStream");
                this.compressingStream = (OutputStream)new LeveledBrotliStream((OutputStream)var5_4, this.rwc.getCompStrat().getBrotli().getLevel());
                this.brotliEnabled = true;
            } else if (isCompressible && this.rwc.getAcceptsGzip() && this.rwc.getCompStrat().getGzip() != null) {
                this.res.setHeader("Content-Encoding", "gzip");
                var5_4 = this.res.getOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)var5_4, (String)"res.outputStream");
                this.compressingStream = new LeveledGzipStream((OutputStream)var5_4, this.rwc.getCompStrat().getGzip().getLevel());
                this.gzipEnabled = true;
            }
            this.initialized = true;
        }
        if (this.brotliEnabled) {
            var4_8 = this.compressingStream;
            if (var4_8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compressingStream");
                v1 = null;
            } else {
                v1 = var4_8;
            }
            ((LeveledBrotliStream)v1).write(b, off, len);
        } else if (this.gzipEnabled) {
            var4_9 = this.compressingStream;
            if (var4_9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compressingStream");
                v2 = null;
            } else {
                v2 = var4_9;
            }
            ((LeveledGzipStream)v2).write(b, off, len);
        } else {
            super.write(b, off, len);
        }
    }

    public final void finalizeCompression() {
        if (this.brotliEnabled && Intrinsics.areEqual((Object)this.res.getHeader("Content-Encoding"), (Object)"br")) {
            OutputStream outputStream;
            OutputStream outputStream2 = this.compressingStream;
            if (outputStream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compressingStream");
                outputStream = null;
            } else {
                outputStream = outputStream2;
            }
            ((BrotliOutputStream)outputStream).close();
        } else if (this.gzipEnabled && Intrinsics.areEqual((Object)this.res.getHeader("Content-Encoding"), (Object)"gzip")) {
            OutputStream outputStream;
            OutputStream outputStream3 = this.compressingStream;
            if (outputStream3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compressingStream");
                outputStream = null;
            } else {
                outputStream = outputStream3;
            }
            ((LeveledGzipStream)outputStream).close();
        }
    }

    private final boolean excludedMimeType(String mimeType) {
        boolean bl;
        block5: {
            if (Intrinsics.areEqual((Object)mimeType, (Object)"")) {
                bl = false;
            } else {
                Iterable $this$any$iv = excludedMimeTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String excluded = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains((CharSequence)mimeType, (CharSequence)excluded, (boolean)true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    public boolean isReady() {
        return this.res.getOutputStream().isReady();
    }

    public void setWriteListener(@Nullable WriteListener writeListener) {
        this.res.getOutputStream().setWriteListener(writeListener);
    }

    public void write(int b) {
        this.res.getOutputStream().write(b);
    }

    static {
        Object[] objectArray = new String[]{"image/", "audio/", "video/", "application/compress", "application/zip", "application/gzip", "application/bzip2", "application/brotli", "application/x-xz", "application/x-rar-compressed"};
        excludedMimeTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/javalin/http/OutputStreamWrapper$Companion;", "", "()V", "excludedMimeTypes", "", "", "getExcludedMimeTypes", "()Ljava/util/Set;", "minSizeForCompression", "", "getMinSizeForCompression", "()I", "setMinSizeForCompression", "(I)V", "javalin"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMinSizeForCompression() {
            return minSizeForCompression;
        }

        public final void setMinSizeForCompression(int n) {
            minSizeForCompression = n;
        }

        @NotNull
        public final Set<String> getExcludedMimeTypes() {
            return excludedMimeTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

