/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.javalin.core.util.JavalinException;
import io.javalin.core.util.JavalinLogger;
import io.javalin.http.staticfiles.Location;
import io.javalin.http.staticfiles.StaticFileConfig;
import java.io.File;
import java.nio.file.AccessDeniedException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.EmptyResource;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f\u00b2\u0006\u0012\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\b0\bX\u008a\u0084\u0002"}, d2={"Lio/javalin/jetty/ConfigurableHandler;", "Lorg/eclipse/jetty/server/handler/ResourceHandler;", "config", "Lio/javalin/http/staticfiles/StaticFileConfig;", "(Lio/javalin/http/staticfiles/StaticFileConfig;)V", "getConfig", "()Lio/javalin/http/staticfiles/StaticFileConfig;", "getResource", "Lorg/eclipse/jetty/util/resource/Resource;", "path", "", "getResourceBase", "javalin", "aliasResource", "kotlin.jvm.PlatformType"})
public class ConfigurableHandler
extends ResourceHandler {
    @NotNull
    private final StaticFileConfig config;

    public ConfigurableHandler(@NotNull StaticFileConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.setResourceBase(this.getResourceBase(this.config));
        this.setDirAllowed(false);
        this.setEtags(true);
        JavalinLogger.info$default("Static file handler added: " + this.config + ". File system location: '" + this.getResourceBase(this.config) + '\'', null, 2, null);
    }

    @NotNull
    public final StaticFileConfig getConfig() {
        return this.config;
    }

    @NotNull
    public Resource getResource(@NotNull String path) {
        Resource resource;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Lazy aliasResource$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Resource>(this, path){
            final /* synthetic */ ConfigurableHandler this$0;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(0);
            }

            public final Resource invoke() {
                Resource resource = this.this$0.getBaseResource();
                Intrinsics.checkNotNull((Object)resource);
                return resource.addPath(URIUtil.canonicalPath((String)this.$path));
            }
        }));
        if (Intrinsics.areEqual((Object)this.config.directory, (Object)"META-INF/resources/webjars")) {
            Resource resource2 = Resource.newClassPathResource((String)Intrinsics.stringPlus((String)"META-INF/resources", (Object)path));
            Resource resource3 = resource2 == null ? EmptyResource.INSTANCE : resource2;
            Intrinsics.checkNotNullExpressionValue((Object)resource3, (String)"Resource.newClassPathRes\u2026?: EmptyResource.INSTANCE");
            resource = resource3;
        } else if (this.config.aliasCheck != null && ConfigurableHandler.getResource$lambda-0((Lazy<? extends Resource>)aliasResource$delegate).isAlias()) {
            ContextHandler.AliasCheck aliasCheck = this.config.aliasCheck;
            if (!(aliasCheck == null ? false : aliasCheck.check(path, ConfigurableHandler.getResource$lambda-0((Lazy<? extends Resource>)aliasResource$delegate)))) {
                throw new AccessDeniedException("Failed alias check");
            }
            Resource resource4 = ConfigurableHandler.getResource$lambda-0((Lazy<? extends Resource>)aliasResource$delegate);
            Intrinsics.checkNotNullExpressionValue((Object)resource4, (String)"if (config.aliasCheck?.c\u2026ion(\"Failed alias check\")");
            resource = resource4;
        } else if (Intrinsics.areEqual((Object)this.config.hostedPath, (Object)"/")) {
            Resource resource5 = super.getResource(path);
            Intrinsics.checkNotNullExpressionValue((Object)resource5, (String)"super.getResource(path)");
            resource = resource5;
        } else if (StringsKt.startsWith$default((String)path, (String)this.config.hostedPath, (boolean)false, (int)2, null)) {
            Resource resource6 = super.getResource(StringsKt.removePrefix((String)path, (CharSequence)this.config.hostedPath));
            Intrinsics.checkNotNullExpressionValue((Object)resource6, (String)"super.getResource(path.r\u2026refix(config.hostedPath))");
            resource = resource6;
        } else {
            Resource resource7 = EmptyResource.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)resource7, (String)"INSTANCE");
            resource = resource7;
        }
        return resource;
    }

    private final String getResourceBase(StaticFileConfig config) {
        String noSuchDirMessage = "Static resource directory with path: '" + config.directory + "' does not exist.";
        String classpathHint = "Depending on your setup, empty folders might not get copied to classpath.";
        if (config.location == Location.CLASSPATH) {
            String string;
            Resource resource = Resource.newClassPathResource((String)config.directory);
            String string2 = string = resource == null ? null : resource.toString();
            if (string == null) {
                throw new JavalinException(noSuchDirMessage + ' ' + classpathHint);
            }
            return string;
        }
        if (!new File(config.directory).exists()) {
            throw new JavalinException(noSuchDirMessage);
        }
        return config.directory;
    }

    private static final Resource getResource$lambda-0(Lazy<? extends Resource> aliasResource$delegate) {
        Lazy<? extends Resource> lazy = aliasResource$delegate;
        Object var2_2 = null;
        Object var3_3 = null;
        boolean bl = false;
        return (Resource)lazy.getValue();
    }
}

