/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.javalin.core.util.JavalinLogger;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import io.javalin.http.LeveledBrotliStream;
import io.javalin.http.LeveledGzipStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/javalin/jetty/JettyPrecompressingResourceHandler;", "", "()V", "compressedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getCompressedFiles", "()Ljava/util/concurrent/ConcurrentHashMap;", "excludedMimeTypes", "", "getExcludedMimeTypes", "()Ljava/util/Set;", "resourceMaxSize", "", "excludedMimeType", "", "mimeType", "getCompressedByteArray", "resource", "Lorg/eclipse/jetty/util/resource/Resource;", "type", "Lio/javalin/jetty/JettyPrecompressingResourceHandler$CompressType;", "getStaticResourceByteArray", "target", "handle", "req", "Ljavax/servlet/http/HttpServletRequest;", "res", "Ljavax/servlet/http/HttpServletResponse;", "CompressType", "javalin"})
public final class JettyPrecompressingResourceHandler {
    @NotNull
    public static final JettyPrecompressingResourceHandler INSTANCE = new JettyPrecompressingResourceHandler();
    @NotNull
    private static final ConcurrentHashMap<String, byte[]> compressedFiles = new ConcurrentHashMap();
    @JvmField
    public static int resourceMaxSize = 0x200000;
    @NotNull
    private static final Set<String> excludedMimeTypes;

    private JettyPrecompressingResourceHandler() {
    }

    @NotNull
    public final ConcurrentHashMap<String, byte[]> getCompressedFiles() {
        return compressedFiles;
    }

    @NotNull
    public final Set<String> getExcludedMimeTypes() {
        return excludedMimeTypes;
    }

    public final boolean handle(@NotNull Resource resource, @NotNull HttpServletRequest req, @NotNull HttpServletResponse res) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        if (resource.exists() && !resource.isDirectory()) {
            byte[] byArray;
            Object object = req.getAttribute("jetty-target");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String target = (String)object;
            String string = req.getHeader("Accept-Encoding");
            CompressType acceptCompressType = CompressType.Companion.getByAcceptEncoding(string == null ? "" : string);
            String contentType = MimeTypes.getDefaultMimeByExtension((String)target);
            if (contentType == null || this.excludedMimeType(contentType)) {
                acceptCompressType = CompressType.NONE;
            }
            if ((byArray = this.getStaticResourceByteArray(resource, target, acceptCompressType)) == null) {
                return false;
            }
            byte[] resultByteArray = byArray;
            res.setContentLength(resultByteArray.length);
            res.setHeader("Content-Type", contentType);
            if (acceptCompressType != CompressType.NONE) {
                res.setHeader("Content-Encoding", acceptCompressType.getTypeName());
            }
            String weakETag = resource.getWeakETag();
            Object object2 = req.getHeader("If-None-Match");
            if (object2 != null) {
                String string2 = object2;
                boolean bl = false;
                boolean bl2 = false;
                String etag = string2;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)etag, (Object)weakETag)) {
                    res.setStatus(304);
                    return true;
                }
            }
            res.setHeader("ETag", weakETag);
            object2 = resultByteArray;
            boolean bl = false;
            InputStream inputStream = new ByteArrayInputStream((byte[])object2);
            object2 = res.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"res.outputStream");
            ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)((OutputStream)object2), (int)0, (int)2, null);
            res.getOutputStream().close();
            return true;
        }
        return false;
    }

    private final byte[] getStaticResourceByteArray(Resource resource, String target, CompressType type2) {
        if (resource.length() > (long)resourceMaxSize) {
            JavalinLogger.warn$default("Static file '" + target + "' is larger than configured max size for pre-compression (" + resourceMaxSize + " bytes).\nYou can configure the max size with `JettyPrecompressingResourceHandler.resourceMaxSize = newMaxSize`.", null, 2, null);
            return null;
        }
        return compressedFiles.computeIfAbsent(Intrinsics.stringPlus((String)target, (Object)type2.getExtension()), arg_0 -> JettyPrecompressingResourceHandler.getStaticResourceByteArray$lambda-1(resource, type2, arg_0));
    }

    private final byte[] getCompressedByteArray(Resource resource, CompressType type2) {
        InputStream fileInput = resource.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = type2 == CompressType.GZIP ? (OutputStream)new LeveledGzipStream((OutputStream)byteArrayOutputStream, 9) : (type2 == CompressType.BR && Util.INSTANCE.dependencyIsPresent(OptionalDependency.JVMBROTLI) ? (OutputStream)((Object)new LeveledBrotliStream(byteArrayOutputStream, 11)) : (OutputStream)byteArrayOutputStream);
        Intrinsics.checkNotNullExpressionValue((Object)fileInput, (String)"fileInput");
        ByteStreamsKt.copyTo$default((InputStream)fileInput, (OutputStream)outputStream, (int)0, (int)2, null);
        fileInput.close();
        outputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    private final boolean excludedMimeType(String mimeType) {
        boolean bl;
        block5: {
            if (Intrinsics.areEqual((Object)mimeType, (Object)"")) {
                bl = false;
            } else {
                Iterable $this$any$iv = excludedMimeTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String excluded = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains((CharSequence)mimeType, (CharSequence)excluded, (boolean)true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private static final byte[] getStaticResourceByteArray$lambda-1(Resource $resource, CompressType $type, String it) {
        Intrinsics.checkNotNullParameter((Object)$resource, (String)"$resource");
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.getCompressedByteArray($resource, $type);
    }

    static {
        Object[] objectArray = new String[]{"image/", "audio/", "video/", "application/compress", "application/zip", "application/gzip", "application/bzip2", "application/brotli", "application/x-xz", "application/x-rar-compressed"};
        excludedMimeTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lio/javalin/jetty/JettyPrecompressingResourceHandler$CompressType;", "", "typeName", "", "extension", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "getTypeName", "acceptEncoding", "", "GZIP", "BR", "NONE", "Companion", "javalin"})
    public static final class CompressType
    extends Enum<CompressType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String typeName;
        @NotNull
        private final String extension;
        public static final /* enum */ CompressType GZIP;
        public static final /* enum */ CompressType BR;
        public static final /* enum */ CompressType NONE;
        private static final /* synthetic */ CompressType[] $VALUES;

        private CompressType(String typeName, String extension) {
            this.typeName = typeName;
            this.extension = extension;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        public final boolean acceptEncoding(@NotNull String acceptEncoding) {
            Intrinsics.checkNotNullParameter((Object)acceptEncoding, (String)"acceptEncoding");
            return StringsKt.contains((CharSequence)acceptEncoding, (CharSequence)this.typeName, (boolean)true);
        }

        public static CompressType[] values() {
            return (CompressType[])$VALUES.clone();
        }

        public static CompressType valueOf(String value) {
            return Enum.valueOf(CompressType.class, value);
        }

        static {
            GZIP = new CompressType("gzip", ".gz");
            BR = new CompressType("br", ".br");
            NONE = new CompressType("", "");
            $VALUES = compressTypeArray = new CompressType[]{CompressType.GZIP, CompressType.BR, CompressType.NONE};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/javalin/jetty/JettyPrecompressingResourceHandler$CompressType$Companion;", "", "()V", "getByAcceptEncoding", "Lio/javalin/jetty/JettyPrecompressingResourceHandler$CompressType;", "acceptEncoding", "", "javalin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CompressType getByAcceptEncoding(@NotNull String acceptEncoding) {
                CompressType compressType;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)acceptEncoding, (String)"acceptEncoding");
                    CompressType[] compressTypeArray = CompressType.values();
                    boolean bl = false;
                    CompressType[] compressTypeArray2 = compressTypeArray;
                    boolean bl2 = false;
                    CompressType[] compressTypeArray3 = compressTypeArray2;
                    int n = compressTypeArray3.length;
                    for (int i = 0; i < n; ++i) {
                        CompressType compressType2;
                        CompressType it = compressType2 = compressTypeArray3[i];
                        boolean bl3 = false;
                        if (!it.acceptEncoding(acceptEncoding)) continue;
                        compressType = compressType2;
                        break block1;
                    }
                    compressType = null;
                }
                CompressType compressType3 = compressType;
                return compressType3 == null ? NONE : compressType3;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

