/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import io.keen.client.java.AbsoluteTimeframe;
import io.keen.client.java.JacksonJsonHandler;
import io.keen.client.java.KeenJsonHandler;
import io.keen.client.java.KeenLogging;
import io.keen.client.java.KeenProject;
import io.keen.client.java.Query;
import io.keen.client.java.QueryType;
import io.keen.client.java.Timeframe;
import io.keen.client.java.exceptions.KeenQueryClientException;
import io.keen.client.java.exceptions.ServerException;
import io.keen.client.java.http.HttpHandler;
import io.keen.client.java.http.OutputSource;
import io.keen.client.java.http.Request;
import io.keen.client.java.http.Response;
import io.keen.client.java.http.UrlConnectionHttpHandler;
import io.keen.client.java.result.DoubleResult;
import io.keen.client.java.result.Group;
import io.keen.client.java.result.GroupByResult;
import io.keen.client.java.result.IntervalResult;
import io.keen.client.java.result.IntervalResultValue;
import io.keen.client.java.result.ListResult;
import io.keen.client.java.result.LongResult;
import io.keen.client.java.result.QueryResult;
import io.keen.client.java.result.StringResult;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class KeenQueryClient {
    private static final String ENCODING = "UTF-8";
    private final KeenJsonHandler jsonHandler;
    private final String baseUrl;
    private final KeenProject project;
    private final HttpHandler httpHandler;

    public KeenProject getProject() {
        return this.project;
    }

    public long count(String eventCollection, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.COUNT).withEventCollection(eventCollection).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return this.queryResultToLong(result);
    }

    public long countUnique(String eventCollection, String targetProperty, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.COUNT_UNIQUE).withEventCollection(eventCollection).withTargetProperty(targetProperty).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return this.queryResultToLong(result);
    }

    public double minimum(String eventCollection, String targetProperty, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.MINIMUM).withEventCollection(eventCollection).withTargetProperty(targetProperty).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return this.queryResultToDouble(result);
    }

    public double maximum(String eventCollection, String targetProperty, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.MAXIMUM).withEventCollection(eventCollection).withTargetProperty(targetProperty).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return this.queryResultToDouble(result);
    }

    public double average(String eventCollection, String targetProperty, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.AVERAGE).withEventCollection(eventCollection).withTargetProperty(targetProperty).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return this.queryResultToDouble(result);
    }

    public double median(String eventCollection, String targetProperty, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.MEDIAN).withEventCollection(eventCollection).withTargetProperty(targetProperty).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return this.queryResultToDouble(result);
    }

    public double percentile(String eventCollection, String targetProperty, Double percentile, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.PERCENTILE).withEventCollection(eventCollection).withTargetProperty(targetProperty).withPercentile(percentile).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return this.queryResultToDouble(result);
    }

    public double sum(String eventCollection, String targetProperty, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.SUM).withEventCollection(eventCollection).withTargetProperty(targetProperty).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return this.queryResultToDouble(result);
    }

    public QueryResult selectUnique(String eventCollection, String targetProperty, Timeframe timeframe) throws IOException {
        Query queryParams = new Query.Builder(QueryType.SELECT_UNIQUE).withEventCollection(eventCollection).withTargetProperty(targetProperty).withTimeframe(timeframe).build();
        QueryResult result = this.execute(queryParams);
        return result;
    }

    public QueryResult execute(Query params) throws IOException {
        if (!params.areParamsValid()) {
            throw new IllegalArgumentException("Keen Query parameters are insufficient. Please check Query API docs for required arguments.");
        }
        Map<String, Object> allQueryArgs = params.constructQueryArgs();
        String urlString = this.formatBaseURL(params.getQueryType().toString());
        URL url = new URL(urlString);
        Object postResult = this.postRequest(this.project, url, allQueryArgs);
        return KeenQueryClient.constructQueryResult(postResult, params.hasGroupBy(), params.hasInterval());
    }

    private static QueryResult constructQueryResult(Object input, boolean isGroupBy, boolean isInterval) {
        QueryResult result = null;
        if (input instanceof Integer) {
            Integer intValue = (Integer)input;
            result = new LongResult(intValue.longValue());
        } else if (input instanceof Long) {
            result = new LongResult((Long)input);
        } else if (input instanceof Double) {
            result = new DoubleResult((Double)input);
        } else if (input instanceof String) {
            result = new StringResult((String)input);
        } else if (input instanceof List) {
            ArrayList listInput = (ArrayList)input;
            if (isInterval) {
                result = KeenQueryClient.constructIntervalResult(listInput, isGroupBy);
            } else if (isGroupBy) {
                result = KeenQueryClient.constructGroupByResult(listInput);
            } else {
                ArrayList<QueryResult> listOutput = new ArrayList<QueryResult>();
                for (Object child : listInput) {
                    QueryResult resultItem = KeenQueryClient.constructQueryResult(child, false, false);
                    listOutput.add(resultItem);
                }
                result = new ListResult(listOutput);
            }
        }
        return result;
    }

    private static IntervalResult constructIntervalResult(List<Object> intervals, boolean isGroupBy) {
        ArrayList<IntervalResultValue> intervalResult = new ArrayList<IntervalResultValue>();
        for (Object child : intervals) {
            if (child instanceof Map) {
                HashMap inputMap = (HashMap)child;
                if (inputMap.containsKey("timeframe") && inputMap.containsKey("value")) {
                    Object timeframe = inputMap.get("timeframe");
                    if (!(timeframe instanceof Map)) {
                        throw new IllegalStateException("IntervalResult Timeframe should be instanceof Map. Instead, it is " + timeframe.getClass().getCanonicalName() + ".");
                    }
                    HashMap hashTimeframe = (HashMap)timeframe;
                    String start = (String)hashTimeframe.get("start");
                    String end = (String)hashTimeframe.get("end");
                    AbsoluteTimeframe absoluteTimeframe = new AbsoluteTimeframe(start, end);
                    Object value = inputMap.get("value");
                    QueryResult queryResultValue = KeenQueryClient.constructQueryResult(value, isGroupBy, false);
                    intervalResult.add(new IntervalResultValue(absoluteTimeframe, queryResultValue));
                    continue;
                }
                throw new IllegalStateException("IntervalResult is missing \"timeframe\" and \"value\" keys.");
            }
            throw new IllegalStateException("IntervalResult should be instanceof Map. Instead, it is " + child.getClass().getCanonicalName() + ".");
        }
        return new IntervalResult(intervalResult);
    }

    private static GroupByResult constructGroupByResult(List<Object> groups) {
        HashMap<Group, QueryResult> groupByResult = new HashMap<Group, QueryResult>();
        for (Object child : groups) {
            if (child instanceof Map) {
                HashMap inputMap = (HashMap)child;
                if (inputMap.containsKey("result")) {
                    QueryResult result = null;
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (String key : inputMap.keySet()) {
                        if (key.equals("result")) {
                            result = KeenQueryClient.constructQueryResult(inputMap.get(key), false, false);
                            continue;
                        }
                        properties.put(key, inputMap.get(key));
                    }
                    Group groupBy = new Group(properties);
                    groupByResult.put(groupBy, result);
                    continue;
                }
                throw new IllegalStateException("GroupBy result is missing \"result\" key.");
            }
            throw new IllegalStateException("GroupBy result should be instanceof Map. Instead, it is " + child.getClass().getCanonicalName() + ".");
        }
        return new GroupByResult(groupByResult);
    }

    private Object postRequest(KeenProject project, URL url, final Map<String, ?> requestData) throws IOException {
        String readkey;
        Response response;
        Object request;
        OutputSource source = new OutputSource(){

            public void writeTo(OutputStream out) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(out, KeenQueryClient.ENCODING);
                if (requestData != null && requestData.size() != 0) {
                    KeenQueryClient.this.jsonHandler.writeJson((Writer)writer, requestData);
                }
            }
        };
        if (KeenLogging.isLoggingEnabled()) {
            try {
                StringWriter writer = new StringWriter();
                this.jsonHandler.writeJson((Writer)writer, requestData);
                request = writer.toString();
                KeenLogging.log((String)String.format(Locale.US, "Sent request '%s' to URL '%s'", request, url.toString()));
            }
            catch (IOException e) {
                KeenLogging.log((String)"Couldn't log event written to file: ");
                e.printStackTrace();
            }
        }
        if (!(response = this.httpHandler.execute(request = new Request(url, "POST", readkey = project.getReadKey(), source, null))).isSuccess()) {
            throw new ServerException(response.body);
        }
        StringReader reader = new StringReader(response.body);
        Map responseMap = this.jsonHandler.readJson((Reader)reader);
        Object result = responseMap.get("result");
        if (result == null && responseMap.containsKey("error_code")) {
            String errorCode = responseMap.get("error_code").toString();
            String message = responseMap.get("message").toString();
            String errorMessage = "Error response received from server";
            if (errorCode != null) {
                errorMessage = errorMessage + " " + errorCode;
            }
            if (message != null) {
                errorMessage = errorMessage + ": " + message;
            }
            throw new KeenQueryClientException(errorMessage);
        }
        return result;
    }

    private String formatBaseURL(String queryName) {
        return String.format(Locale.US, "%s/%s/projects/%s/queries/%s", this.baseUrl, "3.0", this.project.getProjectId(), queryName);
    }

    private long queryResultToLong(QueryResult result) throws KeenQueryClientException {
        if (result == null) {
            throw new NullPointerException("Query Error: expected long response type but received null.");
        }
        if (result.isLong()) {
            return result.longValue();
        }
        throw new IllegalStateException("Query Error: expected long response type.");
    }

    private double queryResultToDouble(QueryResult result) throws KeenQueryClientException {
        if (result == null) {
            throw new NullPointerException("Query Error: expected double response type but received null.");
        }
        if (result.isDouble()) {
            return result.doubleValue();
        }
        if (result.isLong()) {
            return result.longValue();
        }
        throw new IllegalStateException("Query Error: expected double response type.");
    }

    protected KeenQueryClient(Builder builder) {
        this.httpHandler = builder.httpHandler;
        this.jsonHandler = builder.jsonHandler;
        this.baseUrl = builder.baseUrl;
        this.project = builder.project;
    }

    public static class Builder {
        private HttpHandler httpHandler;
        private KeenJsonHandler jsonHandler;
        private String baseUrl;
        private KeenProject project;

        public Builder(KeenProject project) {
            this.project = project;
        }

        protected HttpHandler getDefaultHttpHandler() throws Exception {
            return new UrlConnectionHttpHandler();
        }

        public HttpHandler getHttpHandler() {
            return this.httpHandler;
        }

        public void setHttpHandler(HttpHandler httpHandler) {
            this.httpHandler = httpHandler;
        }

        public Builder withHttpHandler(HttpHandler httpHandler) {
            this.setHttpHandler(httpHandler);
            return this;
        }

        protected KeenJsonHandler getDefaultJsonHandler() throws Exception {
            return new JacksonJsonHandler();
        }

        public KeenJsonHandler getJsonHandler() {
            return this.jsonHandler;
        }

        public void setJsonHandler(KeenJsonHandler jsonHandler) {
            this.jsonHandler = jsonHandler;
        }

        public Builder withJsonHandler(KeenJsonHandler jsonHandler) {
            this.setJsonHandler(jsonHandler);
            return this;
        }

        public String getBaseURL() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public Builder withBaseUrl(String baseUrl) {
            this.setBaseUrl(baseUrl);
            return this;
        }

        public KeenProject getKeenProject() {
            return this.project;
        }

        public void setKeenProject(KeenProject project) {
            this.project = project;
        }

        public KeenQueryClient build() {
            try {
                if (this.httpHandler == null) {
                    this.httpHandler = this.getDefaultHttpHandler();
                }
            }
            catch (Exception e) {
                KeenLogging.log((String)("Exception building HTTP handler: " + e.getMessage()));
            }
            try {
                if (this.jsonHandler == null) {
                    this.jsonHandler = this.getDefaultJsonHandler();
                }
            }
            catch (Exception e) {
                KeenLogging.log((String)("Exception building JSON handler: " + e.getMessage()));
            }
            if (this.project == null) {
                throw new IllegalStateException("Cannot build KeenQueryClient with null project.");
            }
            if (this.baseUrl == null) {
                this.baseUrl = "https://api.keen.io";
            }
            return this.buildInstance();
        }

        protected KeenQueryClient buildInstance() {
            return new KeenQueryClient(this);
        }
    }
}

