package io.knotx.server.configuration;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter for {@link io.knotx.server.configuration.KnotxServerOptions}.
 * NOTE: This class has been automatically generated from the {@link io.knotx.server.configuration.KnotxServerOptions} original class using Vert.x codegen.
 */
 class KnotxServerOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, KnotxServerOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "displayExceptionDetails":
          if (member.getValue() instanceof Boolean) {
            obj.setDisplayExceptionDetails((Boolean)member.getValue());
          }
          break;
        case "dropRequestOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setDropRequestOptions(new io.knotx.server.configuration.DropRequestOptions((JsonObject)member.getValue()));
          }
          break;
        case "globalHandlers":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<io.knotx.server.configuration.RoutingHandlerOptions> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof JsonObject)
                list.add(new io.knotx.server.configuration.RoutingHandlerOptions((JsonObject)item));
            });
            obj.setGlobalHandlers(list);
          }
          break;
        case "hystrixMetricsOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setHystrixMetricsOptions(new io.knotx.server.configuration.HystrixMetricsOptions((JsonObject)member.getValue()));
          }
          break;
        case "routingOperations":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<io.knotx.server.configuration.RoutingOperationOptions> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof JsonObject)
                list.add(new io.knotx.server.configuration.RoutingOperationOptions((JsonObject)item));
            });
            obj.setRoutingOperations(list);
          }
          break;
        case "routingSpecificationLocation":
          if (member.getValue() instanceof String) {
            obj.setRoutingSpecificationLocation((String)member.getValue());
          }
          break;
        case "securityHandlers":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<io.knotx.server.configuration.AuthHandlerOptions> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof JsonObject)
                list.add(new io.knotx.server.configuration.AuthHandlerOptions((JsonObject)item));
            });
            obj.setSecurityHandlers(list);
          }
          break;
        case "serverOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setServerOptions(new io.vertx.core.http.HttpServerOptions((JsonObject)member.getValue()));
          }
          break;
      }
    }
  }

   static void toJson(KnotxServerOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(KnotxServerOptions obj, java.util.Map<String, Object> json) {
    json.put("displayExceptionDetails", obj.isDisplayExceptionDetails());
    if (obj.getDropRequestOptions() != null) {
      json.put("dropRequestOptions", obj.getDropRequestOptions().toJson());
    }
    if (obj.getGlobalHandlers() != null) {
      JsonArray array = new JsonArray();
      obj.getGlobalHandlers().forEach(item -> array.add(item.toJson()));
      json.put("globalHandlers", array);
    }
    if (obj.getHystrixMetricsOptions() != null) {
      json.put("hystrixMetricsOptions", obj.getHystrixMetricsOptions().toJson());
    }
    if (obj.getRoutingOperations() != null) {
      JsonArray array = new JsonArray();
      obj.getRoutingOperations().forEach(item -> array.add(item.toJson()));
      json.put("routingOperations", array);
    }
    if (obj.getRoutingSpecificationLocation() != null) {
      json.put("routingSpecificationLocation", obj.getRoutingSpecificationLocation());
    }
    if (obj.getSecurityHandlers() != null) {
      JsonArray array = new JsonArray();
      obj.getSecurityHandlers().forEach(item -> array.add(item.toJson()));
      json.put("securityHandlers", array);
    }
    if (obj.getServerOptions() != null) {
      json.put("serverOptions", obj.getServerOptions().toJson());
    }
  }
}
