/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.logging;

import io.ktor.client.HttpClient;
import io.ktor.client.call.HttpClientCall;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.logging.LogLevel;
import io.ktor.client.plugins.logging.Logger;
import io.ktor.client.plugins.logging.LoggerJvmKt;
import io.ktor.client.plugins.logging.Logging;
import io.ktor.client.plugins.logging.ObservingUtilsKt;
import io.ktor.client.plugins.observer.ResponseObserver;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpSendPipeline;
import io.ktor.client.statement.HttpReceivePipeline;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseContainer;
import io.ktor.client.statement.HttpResponsePipeline;
import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.AttributeKey;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteChannelKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelKt;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 92\u00020\u0001:\u00029:B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0018\u001a\u00020\u0019H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0019H\u0002J(\u0010\u001c\u001a\u00020\u00192\u001e\u0010\u001d\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00070\u001f0\u001eH\u0002J\u001b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u001b\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010&\u001a\u00020\"H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0002J#\u0010/\u001a\u00020\u00192\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010&\u001a\u000202H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020\u00192\u0006\u0010#\u001a\u0002052\u0006\u0010*\u001a\u00020+H\u0002J\u001c\u00106\u001a\u00020\u0019*\u00020\u00032\u0006\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002R,\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Lio/ktor/client/plugins/logging/Logging;", "", "logger", "Lio/ktor/client/plugins/logging/Logger;", "level", "Lio/ktor/client/plugins/logging/LogLevel;", "filters", "", "Lkotlin/Function1;", "Lio/ktor/client/request/HttpRequestBuilder;", "", "(Lio/ktor/client/plugins/logging/Logger;Lio/ktor/client/plugins/logging/LogLevel;Ljava/util/List;)V", "getFilters", "()Ljava/util/List;", "setFilters", "(Ljava/util/List;)V", "getLevel", "()Lio/ktor/client/plugins/logging/LogLevel;", "setLevel", "(Lio/ktor/client/plugins/logging/LogLevel;)V", "getLogger", "()Lio/ktor/client/plugins/logging/Logger;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "beginLogging", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doneLogging", "logHeaders", "headers", "", "", "", "logRequest", "Lio/ktor/http/content/OutgoingContent;", "request", "(Lio/ktor/client/request/HttpRequestBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logRequestBody", "content", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logRequestException", "context", "cause", "", "logResponse", "response", "Lio/ktor/client/statement/HttpResponse;", "logResponseBody", "contentType", "Lio/ktor/http/ContentType;", "Lio/ktor/utils/io/ByteReadChannel;", "(Lio/ktor/http/ContentType;Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logResponseException", "Lio/ktor/client/request/HttpRequest;", "logHeader", "key", "value", "Companion", "Config", "ktor-client-logging"})
public final class Logging {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private LogLevel level;
    @NotNull
    private List<? extends Function1<? super HttpRequestBuilder, Boolean>> filters;
    @NotNull
    private final Mutex mutex;
    @NotNull
    private static final AttributeKey<Logging> key = new AttributeKey("ClientLogging");

    private Logging(Logger logger, LogLevel level, List<? extends Function1<? super HttpRequestBuilder, Boolean>> filters) {
        this.logger = logger;
        this.level = level;
        this.filters = filters;
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    /* synthetic */ Logging(Logger logger, LogLevel logLevel, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(logger, logLevel, list);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final LogLevel getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        this.level = logLevel;
    }

    @NotNull
    public final List<Function1<HttpRequestBuilder, Boolean>> getFilters() {
        return this.filters;
    }

    public final void setFilters(@NotNull List<? extends Function1<? super HttpRequestBuilder, Boolean>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.filters = list;
    }

    private final Object beginLogging(Continuation<? super Unit> $completion) {
        Object object = Mutex.DefaultImpls.lock$default((Mutex)this.mutex, null, $completion, (int)1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void doneLogging() {
        Mutex.DefaultImpls.unlock$default((Mutex)this.mutex, null, (int)1, null);
    }

    private final Object logRequest(HttpRequestBuilder request, Continuation<? super OutgoingContent> $completion) {
        if (this.getLevel().getInfo()) {
            this.getLogger().log(Intrinsics.stringPlus((String)"REQUEST: ", (Object)URLUtilsKt.Url((URLBuilder)request.getUrl())));
            this.getLogger().log(Intrinsics.stringPlus((String)"METHOD: ", (Object)request.getMethod()));
        }
        OutgoingContent content = (OutgoingContent)request.getBody();
        if (this.getLevel().getHeaders()) {
            this.getLogger().log("COMMON HEADERS");
            this.logHeaders(request.getHeaders().entries());
            this.getLogger().log("CONTENT HEADERS");
            Long l = content.getContentLength();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                this.logHeader(this.getLogger(), HttpHeaders.INSTANCE.getContentLength(), String.valueOf(it));
            }
            ContentType contentType = content.getContentType();
            if (contentType != null) {
                ContentType it = contentType;
                boolean bl = false;
                this.logHeader(this.getLogger(), HttpHeaders.INSTANCE.getContentType(), it.toString());
            }
            this.logHeaders(content.getHeaders().entries());
        }
        if (this.getLevel().getBody()) {
            return this.logRequestBody(content, $completion);
        }
        return null;
    }

    private final void logResponse(HttpResponse response) {
        if (this.level.getInfo()) {
            this.logger.log(Intrinsics.stringPlus((String)"RESPONSE: ", (Object)response.getStatus()));
            this.logger.log(Intrinsics.stringPlus((String)"METHOD: ", (Object)response.getCall().getRequest().getMethod()));
            this.logger.log(Intrinsics.stringPlus((String)"FROM: ", (Object)response.getCall().getRequest().getUrl()));
        }
        if (this.level.getHeaders()) {
            this.logger.log("COMMON HEADERS");
            this.logHeaders(response.getHeaders().entries());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object logResponseBody(ContentType var1_1, ByteReadChannel var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof logResponseBody.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ Logging this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Logging.access$logResponseBody(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$logResponseBody_u24lambda_u2d2 = this.getLogger();
                $i$a$-with-Logging$logResponseBody$2 = false;
                $this$logResponseBody_u24lambda_u2d2.log(Intrinsics.stringPlus((String)"BODY Content-Type: ", (Object)contentType));
                $this$logResponseBody_u24lambda_u2d2.log("BODY START");
                var6_10 = content;
                v0 = var1_1;
                v1 = v0 == null ? null : ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)v0));
                if (v1 == null) {
                    v1 = Charsets.UTF_8;
                }
                var8_11 = v1;
                $completion$iv = $continuation;
                $i$f$tryReadText = false;
                $continuation.L$0 = $this$logResponseBody_u24lambda_u2d2;
                $continuation.L$1 = charset$iv;
                $continuation.label = 1;
                v2 = ByteReadChannelKt.readRemaining((ByteReadChannel)$this$tryReadText$iv, (Continuation)$completion$iv);
                ** if (v2 != var15_6) goto lbl32
lbl31:
                // 1 sources

                return var15_6;
lbl32:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                $i$a$-with-Logging$logResponseBody$2 = false;
                $i$f$tryReadText = false;
                charset$iv = (Charset)$continuation.L$1;
                $this$logResponseBody_u24lambda_u2d2 = (Logger)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl42:
                    // 2 sources

                    var10_15 = StringsKt.readText$default((Input)((Input)v2), (Charset)charset$iv, (int)0, (int)2, null);
                }
                catch (Throwable var11_16) {
                    var10_15 = null;
                }
                v3 = var10_15;
                v4 = v3;
                if (v3 == null) {
                    v4 = "[response body omitted]";
                }
                message = v4;
                $this$logResponseBody_u24lambda_u2d2.log(message);
                $this$logResponseBody_u24lambda_u2d2.log("BODY END");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void logRequestException(HttpRequestBuilder context, Throwable cause) {
        if (this.level.getInfo()) {
            this.logger.log("REQUEST " + URLUtilsKt.Url((URLBuilder)context.getUrl()) + " failed with exception: " + cause);
        }
    }

    private final void logResponseException(HttpRequest request, Throwable cause) {
        if (this.level.getInfo()) {
            this.logger.log("RESPONSE " + request.getUrl() + " failed with exception: " + cause);
        }
    }

    private final void logHeaders(Set<? extends Map.Entry<String, ? extends List<String>>> headers) {
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)headers);
        boolean $i$f$sortedBy = false;
        List sortedHeaders = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        Iterable $this$forEach$iv = sortedHeaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry $dstr$key$values = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)$dstr$key$values.getKey();
            List values = (List)$dstr$key$values.getValue();
            this.logHeader(this.getLogger(), key, CollectionsKt.joinToString$default((Iterable)values, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null));
        }
    }

    private final void logHeader(Logger $this$logHeader, String key, String value) {
        $this$logHeader.log("-> " + key + ": " + value);
    }

    private final Object logRequestBody(OutgoingContent content, Continuation<? super OutgoingContent> $completion) {
        this.getLogger().log(Intrinsics.stringPlus((String)"BODY Content-Type: ", (Object)content.getContentType()));
        ContentType contentType = content.getContentType();
        Charset charset = contentType == null ? null : ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)contentType));
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        Charset charset2 = charset;
        ByteChannel channel = ByteChannelKt.ByteChannel$default((boolean)false, (int)1, null);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(channel, charset2, this, null){
            Object L$0;
            int label;
            final /* synthetic */ ByteChannel $channel;
            final /* synthetic */ Charset $charset;
            final /* synthetic */ Logging this$0;
            {
                this.$channel = $channel;
                this.$charset = $charset;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = (ByteReadChannel)this.$channel;
                        charset$iv = this.$charset;
                        $i$f$tryReadText = false;
                        this.L$0 = charset$iv;
                        this.label = 1;
                        v0 = ByteReadChannelKt.readRemaining((ByteReadChannel)$this$tryReadText$iv, (Continuation)((Continuation)this));
                        ** if (v0 != var8_2) goto lbl15
lbl14:
                        // 1 sources

                        return var8_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$f$tryReadText = false;
                        charset$iv = (Charset)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            var6_7 = StringsKt.readText$default((Input)((Input)v0), (Charset)charset$iv, (int)0, (int)2, null);
                        }
                        catch (Throwable var7_8) {
                            var6_7 = null;
                        }
                        v1 = var6_7;
                        v2 = v1;
                        if (v1 == null) {
                            v2 = "[request body omitted]";
                        }
                        text = v2;
                        this.this$0.getLogger().log("BODY START");
                        this.this$0.getLogger().log(text);
                        this.this$0.getLogger().log("BODY END");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return ObservingUtilsKt.observe(content, (ByteWriteChannel)channel, $completion);
    }

    public static final /* synthetic */ Object access$beginLogging(Logging $this, Continuation $completion) {
        return $this.beginLogging((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$logRequest(Logging $this, HttpRequestBuilder request, Continuation $completion) {
        return $this.logRequest(request, (Continuation<? super OutgoingContent>)$completion);
    }

    public static final /* synthetic */ Object access$logResponseBody(Logging $this, ContentType contentType, ByteReadChannel content, Continuation $completion) {
        return $this.logResponseBody(contentType, content, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$logRequestBody(Logging $this, OutgoingContent content, Continuation $completion) {
        return $this.logRequestBody(content, (Continuation<? super OutgoingContent>)$completion);
    }

    public /* synthetic */ Logging(Logger logger, LogLevel level, List filters, DefaultConstructorMarker $constructor_marker) {
        this(logger, level, filters);
    }

    public static final /* synthetic */ void access$doneLogging(Logging $this) {
        $this.doneLogging();
    }

    public static final /* synthetic */ void access$logRequestException(Logging $this, HttpRequestBuilder context, Throwable cause) {
        $this.logRequestException(context, cause);
    }

    public static final /* synthetic */ void access$logResponse(Logging $this, HttpResponse response) {
        $this.logResponse(response);
    }

    public static final /* synthetic */ void access$logResponseException(Logging $this, HttpRequest request, Throwable cause) {
        $this.logResponseException(request, cause);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005R,\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lio/ktor/client/plugins/logging/Logging$Config;", "", "()V", "filters", "", "Lkotlin/Function1;", "Lio/ktor/client/request/HttpRequestBuilder;", "", "getFilters$ktor_client_logging", "()Ljava/util/List;", "setFilters$ktor_client_logging", "(Ljava/util/List;)V", "level", "Lio/ktor/client/plugins/logging/LogLevel;", "getLevel", "()Lio/ktor/client/plugins/logging/LogLevel;", "setLevel", "(Lio/ktor/client/plugins/logging/LogLevel;)V", "logger", "Lio/ktor/client/plugins/logging/Logger;", "getLogger", "()Lio/ktor/client/plugins/logging/Logger;", "setLogger", "(Lio/ktor/client/plugins/logging/Logger;)V", "filter", "", "predicate", "ktor-client-logging"})
    public static final class Config {
        @NotNull
        private List<Function1<HttpRequestBuilder, Boolean>> filters = new ArrayList();
        @NotNull
        private Logger logger = LoggerJvmKt.getDEFAULT(Logger.Companion);
        @NotNull
        private LogLevel level = LogLevel.HEADERS;

        @NotNull
        public final List<Function1<HttpRequestBuilder, Boolean>> getFilters$ktor_client_logging() {
            return this.filters;
        }

        public final void setFilters$ktor_client_logging(@NotNull List<Function1<HttpRequestBuilder, Boolean>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.filters = list;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        public final void setLogger(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
            this.logger = logger;
        }

        @NotNull
        public final LogLevel getLevel() {
            return this.level;
        }

        public final void setLevel(@NotNull LogLevel logLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
            this.level = logLevel;
        }

        public final void filter(@NotNull Function1<? super HttpRequestBuilder, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            this.filters.add(predicate);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J!\u0010\u000e\u001a\u00020\u00032\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u0010\u00a2\u0006\u0002\b\u0011H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/ktor/client/plugins/logging/Logging$Companion;", "Lio/ktor/client/plugins/HttpClientPlugin;", "Lio/ktor/client/plugins/logging/Logging$Config;", "Lio/ktor/client/plugins/logging/Logging;", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "install", "", "plugin", "scope", "Lio/ktor/client/HttpClient;", "prepare", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "ktor-client-logging"})
    public static final class Companion
    implements HttpClientPlugin<Config, Logging> {
        private Companion() {
        }

        @NotNull
        public AttributeKey<Logging> getKey() {
            return key;
        }

        @NotNull
        public Logging prepare(@NotNull Function1<? super Config, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Config config = new Config();
            block.invoke((Object)config);
            Config config2 = config;
            return new Logging(config2.getLogger(), config2.getLevel(), config2.getFilters$ktor_client_logging(), null);
        }

        public void install(@NotNull Logging plugin, @NotNull HttpClient scope) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            scope.getSendPipeline().intercept(HttpSendPipeline.Phases.getMonitoring(), (Function3)new Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object>(plugin, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Logging $plugin;
                {
                    this.$plugin = $plugin;
                    super(3, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block23: {
                        var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$intercept = (PipelineContext)this.L$0;
                                if (this.$plugin.getFilters().isEmpty()) ** GOTO lbl23
                                $this$any$iv = this.$plugin.getFilters();
                                $i$f$any = false;
                                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl12
                                v0 = false;
                                ** GOTO lbl21
lbl12:
                                // 1 sources

                                var6_10 = $this$any$iv.iterator();
                                while (var6_10.hasNext()) {
                                    element$iv = var6_10.next();
                                    it = (Function1)element$iv;
                                    $i$a$-any-Logging$Companion$install$1$response$1 = false;
                                    if (!((Boolean)it.invoke($this$intercept.getContext())).booleanValue()) continue;
                                    v0 = true;
                                    ** GOTO lbl21
                                }
                                v0 = false;
lbl21:
                                // 3 sources

                                if (!v0) break;
lbl23:
                                // 3 sources

                                this.L$0 = $this$intercept;
                                this.label = 1;
                                v1 = Logging.access$beginLogging(this.$plugin, (Continuation)this);
                                ** if (v1 != var10_2) goto lbl29
lbl28:
                                // 1 sources

                                return var10_2;
lbl29:
                                // 1 sources

                                ** GOTO lbl36
                            }
                            case 1: {
                                $this$intercept = (PipelineContext)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl36:
                                // 2 sources

                                this.L$0 = $this$intercept;
                                this.label = 2;
                                v2 = Logging.access$logRequest(this.$plugin, (HttpRequestBuilder)$this$intercept.getContext(), (Continuation)this);
                                ** if (v2 != var10_2) goto lbl41
lbl40:
                                // 1 sources

                                return var10_2;
lbl41:
                                // 1 sources

                                ** GOTO lbl48
                            }
                            case 2: {
                                $this$intercept = (PipelineContext)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl48:
                                    // 2 sources

                                    $this$any$iv = (OutgoingContent)v2;
                                    ** GOTO lbl58
                                }
                                catch (Throwable var5_8) {
                                    $this$any$iv = null;
                                    ** GOTO lbl58
                                }
                            }
                            catch (Throwable var5_9) {
                                throw var5_9;
                            }
                            {
                                finally {
                                    Logging.access$doneLogging(this.$plugin);
                                }
lbl58:
                                // 2 sources

                                v3 = $this$any$iv;
                                break block23;
                            }
                        }
                        v3 = null;
                    }
                    response = v3;
                    v4 = response;
                    if (v4 == null) {
                        v4 = $this$intercept.getSubject();
                    }
                    this.L$0 = $this$intercept;
                    this.label = 3;
                    v5 = $this$intercept.proceedWith(v4, (Continuation)this);
                    ** if (v5 != var10_2) goto lbl73
lbl72:
                    // 1 sources

                    return var10_2;
lbl73:
                    // 1 sources

                    ** GOTO lbl87
                    {
                        case 3: {
                            $this$intercept = (PipelineContext)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
                            }
                            catch (Throwable cause) {
                                Logging.access$logRequestException(this.$plugin, (HttpRequestBuilder)$this$intercept.getContext(), cause);
                                throw cause;
                            }
lbl87:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<Object, HttpRequestBuilder> p1, @NotNull Object p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
            scope.getReceivePipeline().intercept(HttpReceivePipeline.Phases.getState(), (Function3)new Function3<PipelineContext<HttpResponse, Unit>, HttpResponse, Continuation<? super Unit>, Object>(plugin, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ Logging $plugin;
                {
                    this.$plugin = $plugin;
                    super(3, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$intercept = (PipelineContext)this.L$0;
                            response = (HttpResponse)this.L$1;
                            this.L$0 = $this$intercept;
                            this.L$1 = response;
                            this.label = 1;
                            v0 = Logging.access$beginLogging(this.$plugin, (Continuation)this);
                            ** if (v0 != var5_2) goto lbl15
lbl14:
                            // 1 sources

                            return var5_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            response = (HttpResponse)this.L$1;
                            $this$intercept = (PipelineContext)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            Logging.access$logResponse(this.$plugin, response.getCall().getResponse());
                            this.L$0 = response;
                            this.L$1 = null;
                            this.label = 2;
                            v1 = $this$intercept.proceedWith($this$intercept.getSubject(), (Continuation)this);
                            ** if (v1 != var5_2) goto lbl30
lbl29:
                            // 1 sources

                            return var5_2;
lbl30:
                            // 1 sources

                            ** GOTO lbl47
                        }
                        case 2: {
                            response = (HttpResponse)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                ** GOTO lbl47
                            }
                            catch (Throwable cause) {
                                Logging.access$logResponseException(this.$plugin, response.getCall().getRequest(), cause);
                                throw cause;
                            }
                        }
                        catch (Throwable var4_6) {
                            throw var4_6;
                        }
                        {
                            finally {
                                if (!this.$plugin.getLevel().getBody()) {
                                    Logging.access$doneLogging(this.$plugin);
                                }
                            }
lbl47:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<HttpResponse, Unit> p1, @NotNull HttpResponse p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<HttpResponse, Unit>, HttpResponse, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
            scope.getResponsePipeline().intercept(HttpResponsePipeline.Phases.getReceive(), (Function3)new Function3<PipelineContext<HttpResponseContainer, HttpClientCall>, HttpResponseContainer, Continuation<? super Unit>, Object>(plugin, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Logging $plugin;
                {
                    this.$plugin = $plugin;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            this.L$0 = $this$intercept;
                            this.label = 1;
                            Object object3 = $this$intercept.proceed((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object3;
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable cause) {
                                Logging.access$logResponseException(this.$plugin, ((HttpClientCall)$this$intercept.getContext()).getRequest(), cause);
                                throw cause;
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<HttpResponseContainer, HttpClientCall> p1, @NotNull HttpResponseContainer p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<HttpResponseContainer, HttpClientCall>, HttpResponseContainer, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
            if (!plugin.getLevel().getBody()) {
                return;
            }
            Function2 observer2 = (Function2)new Function2<HttpResponse, Continuation<? super Unit>, Object>(plugin, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ Logging $plugin;
                {
                    this.$plugin = $plugin;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            HttpResponse it = (HttpResponse)this.L$0;
                            this.label = 1;
                            Object object3 = Logging.access$logResponseBody(this.$plugin, HttpMessagePropertiesKt.contentType((HttpMessage)((HttpMessage)it)), it.getContent(), (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object3;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                return Unit.INSTANCE;
                                catch (Throwable throwable2) {
                                    throw throwable2;
                                }
                            }
                            finally {
                                Logging.access$doneLogging(this.$plugin);
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<HttpResponse, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull HttpResponse p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            };
            ResponseObserver.Plugin.install(new ResponseObserver(observer2, null, 2, null), scope);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

