/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\r\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u000e\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u000f"}, d2={"count", "", "urlString", "", "startIndex", "endIndex", "char", "", "findScheme", "fillHost", "", "Lio/ktor/http/URLBuilder;", "indexOfColonInHostPort", "takeFrom", "takeFromUnsafe", "ktor-http"})
public final class URLParserKt {
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $receiver, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
        try {
            uRLBuilder = URLParserKt.takeFromUnsafe($receiver, urlString);
        }
        catch (Throwable cause) {
            throw (Throwable)new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder takeFromUnsafe(@NotNull URLBuilder $receiver, @NotNull String urlString) {
        String string;
        URLBuilder uRLBuilder;
        int it4;
        int n;
        int it22;
        int startIndex;
        block14: {
            int n2;
            char it3;
            int n3;
            block13: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
                CharSequence $receiver$iv = urlString;
                int n4 = 0;
                n3 = $receiver$iv.length();
                while (n4 < n3) {
                    void index$iv;
                    it3 = $receiver$iv.charAt((int)index$iv);
                    if (!CharsKt.isWhitespace((char)it3)) {
                        n2 = index$iv;
                        break block13;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            startIndex = n2;
            CharSequence $receiver$iv = urlString;
            n3 = $receiver$iv.length();
            --n3;
            it3 = '\u0000';
            while (n3 >= 0) {
                void index$iv;
                it22 = $receiver$iv.charAt((int)index$iv);
                if (!CharsKt.isWhitespace((char)it22)) {
                    n = index$iv;
                    break block14;
                }
                --index$iv;
            }
            n = -1;
        }
        int endIndex = n + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String it3 = urlString;
            it22 = startIndex + schemeLength;
            String string2 = it3.substring(startIndex, it22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String scheme = string2;
            $receiver.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                String it4;
                Integer it22;
                Integer n5 = (it4 = ((Number)(it22 = Integer.valueOf(StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"@/\\?#"), (int)startIndex, (boolean)false, (int)4, null)))).intValue()) > 0 ? it22 : null;
                int n6 = delimiter = n5 != null ? n5 : endIndex;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    it4 = urlString;
                    uRLBuilder = $receiver;
                    String string3 = it4.substring(startIndex, passwordIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = string3;
                    uRLBuilder.setUser(string);
                    it4 = urlString;
                    int $i$a$1$takeIf = passwordIndex + 1;
                    uRLBuilder = $receiver;
                    String string4 = it4.substring($i$a$1$takeIf, delimiter);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = string4;
                    uRLBuilder.setPassword(string);
                } else {
                    it4 = urlString;
                    uRLBuilder = $receiver;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it4.substring(startIndex, delimiter), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    uRLBuilder.setUser(string);
                }
                startIndex = delimiter + 1;
            }
            URLParserKt.fillHost($receiver, urlString, startIndex, delimiter);
            startIndex = delimiter;
        }
        $receiver.setEncodedPath("/");
        if (startIndex >= endIndex) {
            return $receiver;
        }
        Integer passwordIndex = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"?#"), (int)startIndex, (boolean)false, (int)4, null);
        it4 = ((Number)passwordIndex).intValue();
        Integer n7 = it4 > 0 ? passwordIndex : null;
        int pathEnd = n7 != null ? n7 : endIndex;
        String it23 = urlString;
        String string5 = it23.substring(startIndex, pathEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String rawPath = string5;
        $receiver.setEncodedPath(CodecsKt.encodeURLPath(rawPath));
        startIndex = pathEnd;
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            if (startIndex + 1 == endIndex) {
                $receiver.setTrailingQuery(true);
                return $receiver;
            }
            Integer $i$a$1$takeIf = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
            int it5 = ((Number)$i$a$1$takeIf).intValue();
            Integer n8 = it5 > 0 ? $i$a$1$takeIf : null;
            int fragmentStart = n8 != null ? n8 : endIndex;
            String string6 = urlString;
            int n9 = startIndex + 1;
            String string7 = string6.substring(n9, fragmentStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Parameters rawParameters = QueryKt.parseQueryString$default(string7, 0, 0, 6, null);
            rawParameters.forEach((Function2)new Function2<String, List<? extends String>, Unit>($receiver){
                final /* synthetic */ URLBuilder $this_takeFromUnsafe;

                public final void invoke(@NotNull String key, @NotNull List<String> values) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Intrinsics.checkParameterIsNotNull(values, (String)"values");
                    this.$this_takeFromUnsafe.getParameters().appendAll(key, values);
                }
                {
                    this.$this_takeFromUnsafe = uRLBuilder;
                    super(2);
                }
            });
            startIndex = fragmentStart;
        }
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string8 = urlString;
            int n10 = startIndex + 1;
            uRLBuilder = $receiver;
            String string9 = string8.substring(n10, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string9;
            uRLBuilder.setFragment(string);
        }
        return $receiver;
    }

    private static final void fillHost(@NotNull URLBuilder $receiver, String urlString, int startIndex, int endIndex) {
        Object object = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int it = ((Number)object).intValue();
        Object object2 = it > 0 ? object : null;
        int colonIndex = object2 != null ? (Integer)object2 : endIndex;
        object = urlString;
        URLBuilder uRLBuilder = $receiver;
        Object object3 = object;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object3).substring(startIndex, colonIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string2 = string;
        uRLBuilder.setHost(string2);
        if (colonIndex + 1 < endIndex) {
            object = urlString;
            int n = colonIndex + 1;
            uRLBuilder = $receiver;
            Object object4 = object;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object4).substring(n, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string3;
            object = string2;
            int n2 = Integer.parseInt((String)object);
            uRLBuilder.setPort(n2);
        }
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        for (int current = startIndex; current < endIndex; ++current) {
            if (urlString.charAt(current) != ':') continue;
            return current;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result = 0;
        while (startIndex + result < endIndex && urlString.charAt(startIndex + result) == c) {
            ++result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfColonInHostPort(@NotNull String $receiver, int startIndex, int endIndex) {
        boolean skip = false;
        int n = startIndex;
        int n2 = endIndex;
        while (n < n2) {
            void index;
            switch ($receiver.charAt((int)index)) {
                case '[': {
                    skip = true;
                    break;
                }
                case ']': {
                    skip = false;
                    break;
                }
                case ':': {
                    if (skip) break;
                    return (int)index;
                }
            }
            ++index;
        }
        return -1;
    }
}

