/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ApplicationResponsePropertiesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0000J\u0014\u0010\u001d\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001fJ\u0014\u0010 \u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00000\u001fJ\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lio/ktor/http/content/EntityTagVersion;", "Lio/ktor/http/content/Version;", "etag", "", "(Ljava/lang/String;)V", "weak", "", "(Ljava/lang/String;Z)V", "getEtag", "()Ljava/lang/String;", "normalized", "getWeak", "()Z", "appendHeadersTo", "", "builder", "Lio/ktor/http/HeadersBuilder;", "check", "Lio/ktor/http/content/VersionCheckResult;", "requestHeaders", "Lio/ktor/http/Headers;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "match", "givenMatchEtags", "", "noneMatch", "givenNoneMatchEtags", "toString", "Companion", "ktor-http"})
public final class EntityTagVersion
implements Version {
    private final String normalized;
    @NotNull
    private final String etag;
    private final boolean weak;
    @NotNull
    private static final EntityTagVersion STAR;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public VersionCheckResult check(@NotNull Headers requestHeaders) {
        List<EntityTagVersion> list;
        VersionCheckResult result;
        boolean bl;
        boolean bl2;
        VersionCheckResult versionCheckResult;
        String it;
        boolean bl3;
        boolean bl4;
        Object object;
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        List<EntityTagVersion> list2 = requestHeaders.get(HttpHeaders.INSTANCE.getIfNoneMatch());
        if (list2 != null) {
            object = list2;
            bl4 = false;
            bl3 = false;
            it = object;
            boolean bl5 = false;
            list2 = Companion.parse(it);
            if (list2 != null) {
                object = list2;
                bl4 = false;
                bl3 = false;
                Object givenNoneMatchEtags = object;
                boolean bl6 = false;
                versionCheckResult = this.noneMatch((List<EntityTagVersion>)givenNoneMatchEtags);
                bl2 = false;
                bl = false;
                result = versionCheckResult;
                boolean bl7 = false;
                if (result != VersionCheckResult.OK) {
                    return result;
                }
            }
        }
        if ((list = requestHeaders.get(HttpHeaders.INSTANCE.getIfMatch())) != null) {
            object = list;
            bl4 = false;
            bl3 = false;
            it = object;
            boolean bl8 = false;
            list = Companion.parse(it);
            if (list != null) {
                object = list;
                bl4 = false;
                bl3 = false;
                Object givenMatchEtags = object;
                boolean bl9 = false;
                versionCheckResult = this.match((List<EntityTagVersion>)givenMatchEtags);
                bl2 = false;
                bl = false;
                result = versionCheckResult;
                boolean bl10 = false;
                if (result != VersionCheckResult.OK) {
                    return result;
                }
            }
        }
        return VersionCheckResult.OK;
    }

    public final boolean match(@NotNull EntityTagVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)STAR) || Intrinsics.areEqual((Object)other, (Object)STAR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)this.normalized, (Object)other.normalized);
    }

    @NotNull
    public final VersionCheckResult noneMatch(@NotNull List<EntityTagVersion> givenNoneMatchEtags) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(givenNoneMatchEtags, (String)"givenNoneMatchEtags");
            if (givenNoneMatchEtags.contains(STAR)) {
                return VersionCheckResult.OK;
            }
            Iterable $this$any$iv = givenNoneMatchEtags;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EntityTagVersion it = (EntityTagVersion)element$iv;
                    boolean bl2 = false;
                    if (!this.match(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        return VersionCheckResult.OK;
    }

    @NotNull
    public final VersionCheckResult match(@NotNull List<EntityTagVersion> givenMatchEtags) {
        Intrinsics.checkNotNullParameter(givenMatchEtags, (String)"givenMatchEtags");
        if (givenMatchEtags.isEmpty()) {
            return VersionCheckResult.OK;
        }
        if (givenMatchEtags.contains(STAR)) {
            return VersionCheckResult.OK;
        }
        for (EntityTagVersion given : givenMatchEtags) {
            if (!this.match(given)) continue;
            return VersionCheckResult.OK;
        }
        return VersionCheckResult.PRECONDITION_FAILED;
    }

    @Override
    public void appendHeadersTo(@NotNull HeadersBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        ApplicationResponsePropertiesKt.etag(builder, this.normalized);
    }

    @NotNull
    public final String getEtag() {
        return this.etag;
    }

    public final boolean getWeak() {
        return this.weak;
    }

    /*
     * WARNING - void declaration
     */
    public EntityTagVersion(@NotNull String etag, boolean weak) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        this.etag = etag;
        this.weak = weak;
        this.normalized = Intrinsics.areEqual((Object)this.etag, (Object)"*") ? this.etag : (StringsKt.startsWith$default((String)this.etag, (String)"\"", (boolean)false, (int)2, null) ? this.etag : HeaderValueWithParametersKt.quote(this.etag));
        int n = 0;
        int n2 = ((CharSequence)this.etag).length();
        while (n < n2) {
            void index;
            char ch = this.etag.charAt((int)index);
            if (Intrinsics.compare((int)ch, (int)32) <= 0 || ch == '\"') {
                boolean bl = index == false || index == StringsKt.getLastIndex((CharSequence)this.etag);
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Character '" + ch + "' is not allowed in entity-tag.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            ++index;
        }
    }

    @Deprecated(message="Binary compatibility.", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ EntityTagVersion(String etag) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        this(StringsKt.removePrefix((String)etag, (CharSequence)"W/"), StringsKt.startsWith$default((String)etag, (String)"W/", (boolean)false, (int)2, null));
    }

    static {
        Companion = new Companion(null);
        STAR = new EntityTagVersion("*", false);
    }

    @NotNull
    public final String component1() {
        return this.etag;
    }

    public final boolean component2() {
        return this.weak;
    }

    @NotNull
    public final EntityTagVersion copy(@NotNull String etag, boolean weak) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        return new EntityTagVersion(etag, weak);
    }

    public static /* synthetic */ EntityTagVersion copy$default(EntityTagVersion entityTagVersion, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = entityTagVersion.etag;
        }
        if ((n & 2) != 0) {
            bl = entityTagVersion.weak;
        }
        return entityTagVersion.copy(string, bl);
    }

    @NotNull
    public String toString() {
        return "EntityTagVersion(etag=" + this.etag + ", weak=" + this.weak + ")";
    }

    public int hashCode() {
        String string = this.etag;
        int n = (string != null ? string.hashCode() : 0) * 31;
        int n2 = this.weak ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof EntityTagVersion)) break block3;
                EntityTagVersion entityTagVersion = (EntityTagVersion)object;
                if (!Intrinsics.areEqual((Object)this.etag, (Object)entityTagVersion.etag) || this.weak != entityTagVersion.weak) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/ktor/http/content/EntityTagVersion$Companion;", "", "()V", "STAR", "Lio/ktor/http/content/EntityTagVersion;", "getSTAR", "()Lio/ktor/http/content/EntityTagVersion;", "parse", "", "headerValue", "", "parseSingle", "value", "ktor-http"})
    public static final class Companion {
        @NotNull
        public final EntityTagVersion getSTAR() {
            return STAR;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<EntityTagVersion> parse(@NotNull String headerValue) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)headerValue, (String)"headerValue");
            List<HeaderValue> rawEntries = HttpHeaderValueParserKt.parseHeaderValue(headerValue);
            Iterable $this$map$iv = rawEntries;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void entry;
                HeaderValue headerValue2 = (HeaderValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                boolean bl2 = entry.getQuality() == 1.0;
                boolean bl3 = false;
                boolean bl4 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string = "entity-tag quality parameter is not allowed: " + entry.getQuality() + '.';
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                bl2 = entry.getParams().isEmpty();
                bl3 = false;
                bl4 = false;
                if (!bl2) {
                    boolean bl6 = false;
                    String string = "entity-tag parameters are not allowed: " + entry.getParams() + '.';
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                EntityTagVersion entityTagVersion = Companion.parseSingle(entry.getValue());
                collection.add(entityTagVersion);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final EntityTagVersion parseSingle(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)value, (Object)"*")) {
                return this.getSTAR();
            }
            boolean weak = false;
            String rawEtag = null;
            if (StringsKt.startsWith$default((String)value, (String)"W/", (boolean)false, (int)2, null)) {
                weak = true;
                rawEtag = StringsKt.drop((String)value, (int)2);
            } else {
                weak = false;
                rawEtag = value;
            }
            String etag = StringsKt.startsWith$default((String)rawEtag, (String)"\"", (boolean)false, (int)2, null) ? rawEtag : HeaderValueWithParametersKt.quote(rawEtag);
            return new EntityTagVersion(etag, weak);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

