/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieEncoding;
import io.ktor.http.CookieKt;
import io.ktor.http.DateUtilsKt;
import io.ktor.util.Base64Kt;
import io.ktor.util.TextKt;
import io.ktor.util.date.GMTDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a#\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0082\b\u001a#\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0082\b\u001a\u0019\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0013H\u0082\b\u001a\u001b\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0082\b\u001a\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\u0013\u001a\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\t\u001a\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001d\u001a\u000e\u0010 \u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001d\u001a\u0084\u0001\u0010 \u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010'\u001a\u00020\u00132\b\b\u0002\u0010(\u001a\u00020\u00132\u0016\b\u0002\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00192\b\b\u0002\u0010*\u001a\u00020\u0013\u001a\f\u0010+\u001a\u00020\t*\u00020\tH\u0002\u001a\f\u0010,\u001a\u00020\u0013*\u00020\u0006H\u0002\u001a\f\u0010-\u001a\u00020\"*\u00020\tH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003\"\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003\u00a8\u0006."}, d2={"clientCookieHeaderPattern", "Lkotlin/text/Regex;", "getClientCookieHeaderPattern$annotations", "()V", "cookieCharsShouldBeEscaped", "", "", "getCookieCharsShouldBeEscaped$annotations", "loweredPartNames", "", "getLoweredPartNames$annotations", "cookiePart", "name", "value", "", "encoding", "Lio/ktor/http/CookieEncoding;", "cookiePartExt", "cookiePartFlag", "", "cookiePartUnencoded", "decodeCookieValue", "encodedValue", "encodeCookieValue", "parseClientCookiesHeader", "", "cookiesHeader", "skipEscaped", "parseServerSetCookieHeader", "Lio/ktor/http/Cookie;", "renderCookieHeader", "cookie", "renderSetCookieHeader", "maxAge", "", "expires", "Lio/ktor/util/date/GMTDate;", "domain", "path", "secure", "httpOnly", "extensions", "includeEncoding", "assertCookieName", "shouldEscapeInCookies", "toIntClamping", "ktor-http"})
public final class CookieKt {
    @NotNull
    private static final Set<String> loweredPartNames;
    @NotNull
    private static final Regex clientCookieHeaderPattern;
    @NotNull
    private static final Set<Character> cookieCharsShouldBeEscaped;

    private static /* synthetic */ void getLoweredPartNames$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Cookie parseServerSetCookieHeader(@NotNull String cookiesHeader) {
        Map map;
        void $this$filterKeys$iv;
        void $this$mapKeysTo$iv$iv;
        CookieEncoding cookieEncoding;
        Map<String, String> it;
        Object element$iv2;
        Map<String, String> asMap;
        block6: {
            Intrinsics.checkNotNullParameter((Object)cookiesHeader, (String)"cookiesHeader");
            asMap = CookieKt.parseClientCookiesHeader(cookiesHeader, false);
            Iterable $this$first$iv = asMap.entrySet();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                it = (Map.Entry)element$iv2;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default((String)((String)it.getKey()), (String)"$", (boolean)false, (int)2, null))) continue;
                break block6;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Map.Entry first = (Map.Entry)element$iv2;
        String string = asMap.get("$x-enc");
        if (string == null) {
            cookieEncoding = null;
        } else {
            it = string;
            boolean bl = false;
            cookieEncoding = CookieEncoding.valueOf((String)((Object)it));
        }
        CookieEncoding cookieEncoding2 = cookieEncoding;
        if (cookieEncoding == null) {
            cookieEncoding2 = CookieEncoding.RAW;
        }
        CookieEncoding encoding = cookieEncoding2;
        Map<String, String> $this$mapKeys$iv = asMap;
        int $i$f$mapKeys = 0;
        it = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it2;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string2 = TextKt.toLowerCasePreservingASCIIRules((String)((String)it2.getKey()));
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string2, entry);
        }
        Map loweredMap = destination$iv$iv;
        String string3 = (String)loweredMap.get("max-age");
        int n = string3 == null ? 0 : ($i$f$mapKeys = CookieKt.toIntClamping(string3));
        String string4 = (String)loweredMap.get("expires");
        $this$mapKeys$iv = asMap;
        boolean bl = loweredMap.containsKey("httponly");
        boolean bl3 = loweredMap.containsKey("secure");
        String string5 = (String)loweredMap.get("path");
        String string6 = (String)loweredMap.get("domain");
        GMTDate gMTDate = string4 == null ? null : DateUtilsKt.fromCookieToGmtDate(string4);
        int n2 = n;
        CookieEncoding cookieEncoding3 = encoding;
        String string7 = CookieKt.decodeCookieValue((String)first.getValue(), encoding);
        String string8 = (String)first.getKey();
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it3 = (String)entry$iv.getKey();
            boolean bl4 = false;
            if (!(!loweredPartNames.contains(TextKt.toLowerCasePreservingASCIIRules((String)it3)) && !Intrinsics.areEqual((Object)it3, first.getKey()))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map map4 = map = (Map)result$iv;
        boolean bl5 = bl;
        boolean bl6 = bl3;
        String string9 = string5;
        String string10 = string6;
        GMTDate gMTDate2 = gMTDate;
        int n3 = n2;
        CookieEncoding cookieEncoding4 = cookieEncoding3;
        String string11 = string7;
        String string12 = string8;
        return new Cookie(string12, string11, cookieEncoding4, n3, gMTDate2, string10, string9, bl6, bl5, map4);
    }

    private static /* synthetic */ void getClientCookieHeaderPattern$annotations() {
    }

    @NotNull
    public static final Map<String, String> parseClientCookiesHeader(@NotNull String cookiesHeader, boolean skipEscaped) {
        Intrinsics.checkNotNullParameter((Object)cookiesHeader, (String)"cookiesHeader");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)clientCookieHeaderPattern, (CharSequence)cookiesHeader, (int)0, (int)2, null), (Function1)parseClientCookiesHeader.1.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Boolean>(skipEscaped){
            final /* synthetic */ boolean $skipEscaped;
            {
                this.$skipEscaped = $skipEscaped;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return !this.$skipEscaped || !StringsKt.startsWith$default((String)((String)it.getFirst()), (String)"$", (boolean)false, (int)2, null);
            }
        })), (Function1)parseClientCookiesHeader.3.INSTANCE));
    }

    public static /* synthetic */ Map parseClientCookiesHeader$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CookieKt.parseClientCookiesHeader(string, bl);
    }

    @NotNull
    public static final String renderSetCookieHeader(@NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Cookie $this$renderSetCookieHeader_u24lambda_u2d4 = cookie;
        boolean bl = false;
        return CookieKt.renderSetCookieHeader$default($this$renderSetCookieHeader_u24lambda_u2d4.getName(), $this$renderSetCookieHeader_u24lambda_u2d4.getValue(), $this$renderSetCookieHeader_u24lambda_u2d4.getEncoding(), $this$renderSetCookieHeader_u24lambda_u2d4.getMaxAgeInt(), $this$renderSetCookieHeader_u24lambda_u2d4.getExpires(), $this$renderSetCookieHeader_u24lambda_u2d4.getDomain(), $this$renderSetCookieHeader_u24lambda_u2d4.getPath(), $this$renderSetCookieHeader_u24lambda_u2d4.getSecure(), $this$renderSetCookieHeader_u24lambda_u2d4.getHttpOnly(), $this$renderSetCookieHeader_u24lambda_u2d4.getExtensions(), false, 1024, null);
    }

    @NotNull
    public static final String renderCookieHeader(@NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Cookie $this$renderCookieHeader_u24lambda_u2d5 = cookie;
        boolean bl = false;
        return $this$renderCookieHeader_u24lambda_u2d5.getName() + '=' + CookieKt.encodeCookieValue($this$renderCookieHeader_u24lambda_u2d5.getValue(), $this$renderCookieHeader_u24lambda_u2d5.getEncoding());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderSetCookieHeader(@NotNull String name, @NotNull String value, @NotNull CookieEncoding encoding, int maxAge, @Nullable GMTDate expires, @Nullable String domain, @Nullable String path, boolean secure, boolean httpOnly, @NotNull Map<String, String> extensions, boolean includeEncoding) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object;
        Iterable name$iv;
        String it;
        void $this$mapTo$iv$iv;
        String $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Object object2 = new String[7];
        String name$iv2 = CookieKt.assertCookieName(name);
        boolean $i$f$cookiePart = false;
        object2[0] = name$iv2 + '=' + CookieKt.encodeCookieValue(value.toString(), encoding);
        name$iv2 = "Max-Age";
        Object value$iv = maxAge > 0 ? Integer.valueOf(maxAge) : null;
        boolean $i$f$cookiePartUnencoded = false;
        object2[1] = value$iv != null ? name$iv2 + '=' + value$iv : "";
        name$iv2 = "Expires";
        GMTDate gMTDate = expires;
        value$iv = gMTDate == null ? null : DateUtilsKt.toHttpDate(gMTDate);
        $i$f$cookiePartUnencoded = false;
        object2[2] = value$iv != null ? name$iv2 + '=' + value$iv : "";
        name$iv2 = "Domain";
        CookieEncoding encoding$iv = CookieEncoding.RAW;
        boolean $i$f$cookiePart2 = false;
        object2[3] = domain != null ? name$iv2 + '=' + CookieKt.encodeCookieValue(domain.toString(), encoding$iv) : "";
        name$iv2 = "Path";
        encoding$iv = CookieEncoding.RAW;
        $i$f$cookiePart2 = false;
        object2[4] = path != null ? name$iv2 + '=' + CookieKt.encodeCookieValue(path.toString(), encoding$iv) : "";
        name$iv2 = "Secure";
        boolean $i$f$cookiePartFlag = false;
        object2[5] = secure ? name$iv2 : "";
        name$iv2 = "HttpOnly";
        $i$f$cookiePartFlag = false;
        object2[6] = httpOnly ? name$iv2 : "";
        Collection collection = CollectionsKt.listOf((Object[])object2);
        object2 = extensions;
        Collection collection2 = collection;
        boolean $i$f$map2 = false;
        void $i$f$cookiePartFlag2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            void name$iv3;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            String string2 = CookieKt.assertCookieName((String)it.getKey());
            String value$iv2 = (String)it.getValue();
            boolean $i$f$cookiePartExt = false;
            if (value$iv2 == null) {
                boolean value$iv$iv = true;
                boolean $i$f$cookiePartFlag3 = false;
                string = name$iv3;
            } else {
                boolean $i$f$cookiePart3 = false;
                string = (String)name$iv3 + '=' + CookieKt.encodeCookieValue(value$iv2.toString(), encoding);
            }
            collection3.add(string);
        }
        Collection collection4 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        if (includeEncoding) {
            void value$iv3;
            $this$map$iv = "$x-enc";
            String $i$f$map2 = encoding.name();
            encoding$iv = CookieEncoding.RAW;
            boolean $i$f$cookiePartExt = false;
            if (value$iv3 == null) {
                boolean value$iv$iv = true;
                boolean $i$f$cookiePartFlag4 = false;
                object = name$iv;
            } else {
                boolean $i$f$cookiePart4 = false;
                object = (String)((Object)name$iv) + '=' + CookieKt.encodeCookieValue(value$iv3.toString(), encoding$iv);
            }
        } else {
            object = "";
        }
        name$iv = CollectionsKt.plus((Collection)collection4, (Object)object);
        boolean $i$f$filter = false;
        encoding$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String renderSetCookieHeader$default(String string, String string2, CookieEncoding cookieEncoding, int n, GMTDate gMTDate, String string3, String string4, boolean bl, boolean bl2, Map map, boolean bl3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            cookieEncoding = CookieEncoding.URI_ENCODING;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            gMTDate = null;
        }
        if ((n2 & 0x20) != 0) {
            string3 = null;
        }
        if ((n2 & 0x40) != 0) {
            string4 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x200) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n2 & 0x400) != 0) {
            bl3 = true;
        }
        return CookieKt.renderSetCookieHeader(string, string2, cookieEncoding, n, gMTDate, string3, string4, bl, bl2, map, bl3);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String encodeCookieValue(@NotNull String value, @NotNull CookieEncoding encoding) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        switch (WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: {
                $this$any$iv = value;
                $i$f$any = false;
                var4_6 = $this$any$iv;
                for (var5_8 = 0; var5_8 < var4_6.length(); ++var5_8) {
                    element$iv = var4_6.charAt(var5_8);
                    it = element$iv;
                    $i$a$-any-CookieKt$encodeCookieValue$1 = false;
                    if (!CookieKt.shouldEscapeInCookies(it)) continue;
                    v0 = true;
                    ** GOTO lbl17
                }
                v0 = false;
lbl17:
                // 2 sources

                if (v0) {
                    throw new IllegalArgumentException("The cookie value contains characters that cannot be encoded in RAW format.  Consider URL_ENCODING mode");
                }
                v1 = value;
                break;
            }
            case 2: {
                if (StringsKt.contains$default((CharSequence)value, (char)'\"', (boolean)false, (int)2, null)) {
                    throw new IllegalArgumentException("The cookie value contains characters that cannot be encoded in DQUOTES format. Consider URL_ENCODING mode");
                }
                $this$any$iv = value;
                $i$f$any = false;
                var4_7 = $this$any$iv;
                for (var5_9 = 0; var5_9 < var4_7.length(); ++var5_9) {
                    element$iv = var4_7.charAt(var5_9);
                    it = element$iv;
                    $i$a$-any-CookieKt$encodeCookieValue$2 = false;
                    if (!CookieKt.shouldEscapeInCookies(it)) continue;
                    v2 = true;
                    ** GOTO lbl36
                }
                v2 = false;
lbl36:
                // 2 sources

                if (v2) {
                    v1 = '\"' + value + '\"';
                    break;
                }
                v1 = value;
                break;
            }
            case 3: {
                v1 = Base64Kt.encodeBase64((String)value);
                break;
            }
            case 4: {
                v1 = CodecsKt.encodeURLQueryComponent$default(value, true, true, null, 4, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v1;
    }

    @NotNull
    public static final String decodeCookieValue(@NotNull String encodedValue, @NotNull CookieEncoding encoding) {
        String string;
        Intrinsics.checkNotNullParameter((Object)encodedValue, (String)"encodedValue");
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        switch (WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: 
            case 2: {
                if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)encodedValue)).toString(), (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)((Object)StringsKt.trimEnd((CharSequence)encodedValue)).toString(), (String)"\"", (boolean)false, (int)2, null)) {
                    string = StringsKt.removeSurrounding((String)((Object)StringsKt.trim((CharSequence)encodedValue)).toString(), (CharSequence)"\"");
                    break;
                }
                string = encodedValue;
                break;
            }
            case 4: {
                string = CodecsKt.decodeURLQueryComponent$default(encodedValue, 0, 0, true, null, 11, null);
                break;
            }
            case 3: {
                string = Base64Kt.decodeBase64String((String)encodedValue);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final String assertCookieName(String $this$assertCookieName) {
        boolean bl;
        block2: {
            CharSequence $this$any$iv = $this$assertCookieName;
            boolean $i$f$any = false;
            CharSequence charSequence = $this$any$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl2 = false;
                if (!CookieKt.shouldEscapeInCookies(it)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Cookie name is not valid: ", (Object)$this$assertCookieName));
        }
        return $this$assertCookieName;
    }

    private static /* synthetic */ void getCookieCharsShouldBeEscaped$annotations() {
    }

    private static final boolean shouldEscapeInCookies(char $this$shouldEscapeInCookies) {
        return CharsKt.isWhitespace((char)$this$shouldEscapeInCookies) || Intrinsics.compare((int)$this$shouldEscapeInCookies, (int)32) < 0 || cookieCharsShouldBeEscaped.contains(Character.valueOf($this$shouldEscapeInCookies));
    }

    private static final String cookiePart(String name, Object value, CookieEncoding encoding) {
        boolean $i$f$cookiePart = false;
        return value != null ? name + '=' + CookieKt.encodeCookieValue(value.toString(), encoding) : "";
    }

    private static final String cookiePartUnencoded(String name, Object value) {
        boolean $i$f$cookiePartUnencoded = false;
        return value != null ? name + '=' + value : "";
    }

    private static final String cookiePartFlag(String name, boolean value) {
        boolean $i$f$cookiePartFlag = false;
        return value ? name : "";
    }

    private static final String cookiePartExt(String name, String value, CookieEncoding encoding) {
        String string;
        boolean $i$f$cookiePartExt = false;
        if (value == null) {
            boolean value$iv = true;
            boolean $i$f$cookiePartFlag = false;
            string = name;
        } else {
            boolean $i$f$cookiePart = false;
            string = name + '=' + CookieKt.encodeCookieValue(value.toString(), encoding);
        }
        return string;
    }

    private static final int toIntClamping(String $this$toIntClamping) {
        return (int)RangesKt.coerceIn((long)Long.parseLong($this$toIntClamping), (long)0L, (long)Integer.MAX_VALUE);
    }

    static {
        Object[] objectArray = new String[]{"max-age", "expires", "domain", "path", "secure", "httponly", "$x-enc"};
        loweredPartNames = SetsKt.setOf((Object[])objectArray);
        clientCookieHeaderPattern = new Regex("(^|;)\\s*([^;=\\{\\}\\s]+)\\s*(=\\s*(\"[^\"]*\"|[^;]*))?");
        objectArray = new Character[]{Character.valueOf(';'), Character.valueOf(','), Character.valueOf('\"')};
        cookieCharsShouldBeEscaped = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CookieEncoding.values().length];
            nArray[CookieEncoding.RAW.ordinal()] = 1;
            nArray[CookieEncoding.DQUOTES.ordinal()] = 2;
            nArray[CookieEncoding.BASE64_ENCODING.ordinal()] = 3;
            nArray[CookieEncoding.URI_ENCODING.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

