/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.charsets;

import io.ktor.utils.io.bits.Memory;
import io.ktor.utils.io.charsets.MalformedInputException;
import io.ktor.utils.io.core.AbstractInput;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.core.internal.UTF8Kt;
import io.ktor.utils.io.core.internal.UnsafeKt;
import java.io.EOFException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0014\u001a\u00020\u0001*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0001\u001a6\u0010\u001b\u001a\u00020\u0001*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u001a\u001a\u00020\u0001H\u0000\u001a\u001e\u0010 \u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0001\u001a \u0010\"\u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0001H\u0002\u001a \u0010$\u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0001H\u0002\u001a\u0018\u0010%\u001a\u00020\u001f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0017\u001a\u00020\u001cH\u0000\u001a0\u0010&\u001a\u00020\u0001*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u001cH\u0000\u001a*\u0010*\u001a\u00020+*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u00012\b\b\u0002\u0010)\u001a\u00020\u0001\u001a(\u0010,\u001a\u00020+*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0002\u001a\u001e\u0010-\u001a\u00020.*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020/2\u0006\u0010\u0017\u001a\u000200\u001a\f\u00101\u001a\u00020.*\u000202H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0006\u001a\u00060\u0007j\u0002`\b*\u00060\tj\u0002`\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001d\u0010\u0006\u001a\u00060\u0007j\u0002`\b*\u00060\rj\u0002`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000f\"\u0019\u0010\u0010\u001a\u00020\u0011*\u00060\u0007j\u0002`\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013*\n\u00103\"\u00020\u00072\u00020\u0007*\n\u00104\"\u00020\t2\u00020\t*\n\u00105\"\u00020\r2\u00020\r*\n\u00106\"\u0002072\u000207\u00a8\u00068"}, d2={"DECODE_CHAR_BUFFER_SIZE", "", "EmptyByteBuffer", "Ljava/nio/ByteBuffer;", "EmptyCharBuffer", "Ljava/nio/CharBuffer;", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "Ljava/nio/charset/CharsetDecoder;", "Lio/ktor/utils/io/charsets/CharsetDecoder;", "getCharset", "(Ljava/nio/charset/CharsetDecoder;)Ljava/nio/charset/Charset;", "Ljava/nio/charset/CharsetEncoder;", "Lio/ktor/utils/io/charsets/CharsetEncoder;", "(Ljava/nio/charset/CharsetEncoder;)Ljava/nio/charset/Charset;", "name", "", "getName", "(Ljava/nio/charset/Charset;)Ljava/lang/String;", "decode", "input", "Lio/ktor/utils/io/core/Input;", "dst", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "max", "decodeBuffer", "Lio/ktor/utils/io/core/Buffer;", "out", "lastBuffer", "", "decodeExactBytes", "inputLength", "decodeImplByteBuffer", "Lio/ktor/utils/io/core/AbstractInput;", "decodeImplSlow", "encodeComplete", "encodeImpl", "", "fromIndex", "toIndex", "encodeToByteArray", "", "encodeToByteArraySlow", "encodeUTF8", "", "Lio/ktor/utils/io/core/ByteReadPacket;", "Lio/ktor/utils/io/core/Output;", "throwExceptionWrapped", "Ljava/nio/charset/CoderResult;", "Charset", "CharsetDecoder", "CharsetEncoder", "Charsets", "Lkotlin/text/Charsets;", "ktor-io"})
public final class CharsetJVMKt {
    private static final int DECODE_CHAR_BUFFER_SIZE = 8192;
    @NotNull
    private static final CharBuffer EmptyCharBuffer;
    @NotNull
    private static final ByteBuffer EmptyByteBuffer;

    @NotNull
    public static final String getName(@NotNull Charset $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        String string = $this$name.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
        return string;
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetEncoder $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        Charset charset = $this$charset.charset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset()");
        return charset;
    }

    @NotNull
    public static final byte[] encodeToByteArray(@NotNull CharsetEncoder $this$encodeToByteArray, @NotNull CharSequence input, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input instanceof String) {
            if (fromIndex == 0 && toIndex == input.length()) {
                byte[] byArray = ((String)input).getBytes($this$encodeToByteArray.charset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input as java.lang.String).getBytes(charset())");
                return byArray;
            }
            String string = (String)input;
            boolean bl = false;
            String string2 = string.substring(fromIndex, toIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            byte[] byArray = string2.getBytes($this$encodeToByteArray.charset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input.substring(fromIndex, toIndex) as java.lang.String).getBytes(charset())");
            return byArray;
        }
        return CharsetJVMKt.encodeToByteArraySlow($this$encodeToByteArray, input, fromIndex, toIndex);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return CharsetJVMKt.encodeToByteArray(charsetEncoder, charSequence, n, n2);
    }

    private static final byte[] encodeToByteArraySlow(CharsetEncoder $this$encodeToByteArraySlow, CharSequence input, int fromIndex, int toIndex) {
        byte[] byArray;
        byte[] existingArray;
        byte[] it;
        boolean bl;
        boolean bl2;
        byte[] byArray2;
        Object object;
        byte[] byArray3;
        ByteBuffer result = $this$encodeToByteArraySlow.encode(CharBuffer.wrap(input, fromIndex, toIndex));
        if (result.hasArray() && result.arrayOffset() == 0) {
            byArray3 = result.array();
            if (byArray3 == null) {
                object = null;
            } else {
                byArray2 = byArray3;
                bl2 = false;
                bl = false;
                it = byArray2;
                boolean bl3 = false;
                object = it.length == result.remaining() ? byArray2 : null;
            }
        } else {
            object = null;
        }
        byArray3 = existingArray = object;
        if (byArray3 == null) {
            byArray2 = new byte[result.remaining()];
            bl2 = false;
            bl = false;
            it = byArray2;
            boolean bl4 = false;
            result.get(it);
            byArray = byArray2;
        } else {
            byArray = byArray3;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final int encodeImpl(@NotNull CharsetEncoder $this$encodeImpl, @NotNull CharSequence input, int fromIndex, int toIndex, @NotNull io.ktor.utils.io.core.Buffer dst) {
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        void $this$writeDirect$iv;
        Intrinsics.checkNotNullParameter((Object)$this$encodeImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        CharBuffer cb = CharBuffer.wrap(input, fromIndex, toIndex);
        int before = cb.remaining();
        io.ktor.utils.io.core.Buffer buffer = dst;
        boolean size$iv = false;
        boolean $i$f$writeDirect = false;
        boolean bl = false;
        void $this$write$iv$iv = $this$writeDirect$iv;
        boolean $i$f$write = false;
        boolean bl2 = false;
        int n = $this$write$iv$iv.getLimit();
        int n2 = $this$write$iv$iv.getWritePosition();
        ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
        boolean bl3 = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl4 = false;
        CoderResult result = $this$encodeImpl.encode(cb, bb, false);
        if (result.isMalformed() || result.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            CharsetJVMKt.throwExceptionWrapped(result);
        }
        boolean bl5 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl5) {
            boolean bl8 = false;
            String string = "Buffer's limit change is not allowed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$write$iv$iv.commitWritten(rc$iv$iv);
        return before - cb.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void encodeUTF8(@NotNull CharsetEncoder $this$encodeUTF8, @NotNull ByteReadPacket input, @NotNull Output dst) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUTF8, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (CharsetJVMKt.getCharset($this$encodeUTF8) == Charsets.UTF_8) {
            OutputKt.writePacket(dst, input);
            return;
        }
        ChunkBuffer tmp = ChunkBuffer.Companion.getPool().borrow();
        int readSize = 0;
        readSize = 1;
        try {
            int rc$iv$iv;
            boolean bl;
            int n;
            int $i$f$write;
            void endExclusive$iv;
            void start$iv;
            ByteBuffer nioBuffer$iv;
            void $this$writeDirect$iv;
            io.ktor.utils.io.core.Buffer buffer = tmp;
            boolean size$iv = false;
            boolean $i$f$writeDirect = false;
            boolean bl2 = false;
            void $this$write$iv$iv = $this$writeDirect$iv;
            boolean $i$f$write2 = false;
            boolean bl3 = false;
            int n2 = $this$write$iv$iv.getLimit();
            int n3 = $this$write$iv$iv.getWritePosition();
            ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
            boolean bl4 = false;
            ByteBuffer tmpBb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
            boolean bl5 = false;
            CharBuffer charBuffer = tmpBb.asCharBuffer();
            Intrinsics.checkNotNull((Object)charBuffer);
            CharBuffer cb = charBuffer;
            while (input.getRemaining() > 0L) {
                int mask$iv;
                int n4;
                int n5;
                boolean index$iv;
                ChunkBuffer chunk;
                block44: {
                    void endExclusive$iv2;
                    void start$iv2;
                    io.ktor.utils.io.core.Buffer $this$read$iv$iv;
                    block48: {
                        cb.clear();
                        chunk = input.prepareReadHead(readSize);
                        if (chunk == null) {
                            break;
                        }
                        io.ktor.utils.io.core.Buffer $this$decodeUTF8$iv = chunk;
                        boolean $i$f$decodeUTF8 = false;
                        int byteCount$iv = 0;
                        int value$iv = 0;
                        int lastByteCount$iv = 0;
                        $this$read$iv$iv = $this$decodeUTF8$iv;
                        boolean $i$f$read = false;
                        boolean bl6 = false;
                        int n6 = $this$read$iv$iv.getWritePosition();
                        int n7 = $this$read$iv$iv.getReadPosition();
                        ByteBuffer memory$iv2 = $this$read$iv$iv.getMemory-SK3TCg8();
                        boolean bl7 = false;
                        void var32_54 = start$iv2;
                        if (var32_54 >= endExclusive$iv2) break block48;
                        do {
                            block50: {
                                block51: {
                                    boolean bl8;
                                    boolean bl9;
                                    boolean bl10;
                                    char ch;
                                    block49: {
                                        boolean bl11;
                                        int n8;
                                        index$iv = var32_54++;
                                        boolean bl12 = false;
                                        n5 = 0;
                                        int v$iv = memory$iv2.get(index$iv ? 1 : 0) & 0xFF;
                                        if ((v$iv & 0x80) == 0) {
                                            boolean bl13;
                                            if (byteCount$iv != 0) {
                                                UTF8Kt.malformedByteCount(byteCount$iv);
                                                throw new KotlinNothingValueException();
                                            }
                                            char ch2 = (char)v$iv;
                                            n8 = 0;
                                            if (cb.hasRemaining()) {
                                                cb.put(ch2);
                                                bl13 = true;
                                            } else {
                                                bl13 = false;
                                            }
                                            if (bl13) continue;
                                            $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2));
                                            n4 = -1;
                                            break block44;
                                        }
                                        if (byteCount$iv == 0) {
                                            mask$iv = 128;
                                            value$iv = v$iv;
                                            n5 = 1;
                                            do {
                                                int i$iv = n5++;
                                                if ((value$iv & mask$iv) == 0) break;
                                                value$iv &= ~mask$iv;
                                                mask$iv >>= 1;
                                                n8 = byteCount$iv;
                                                byteCount$iv = n8 + 1;
                                            } while (n5 <= 6);
                                            lastByteCount$iv = byteCount$iv;
                                            n5 = byteCount$iv;
                                            byteCount$iv = n5 + -1;
                                            if (lastByteCount$iv <= endExclusive$iv2 - index$iv) continue;
                                            $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2));
                                            n4 = lastByteCount$iv;
                                            break block44;
                                        }
                                        value$iv = value$iv << 6 | v$iv & 0x7F;
                                        mask$iv = byteCount$iv;
                                        byteCount$iv = mask$iv + -1;
                                        if (byteCount$iv != 0) continue;
                                        if (!UTF8Kt.isBmpCodePoint(value$iv)) break block49;
                                        ch = (char)value$iv;
                                        bl10 = false;
                                        if (cb.hasRemaining()) {
                                            cb.put(ch);
                                            bl11 = true;
                                        } else {
                                            bl11 = false;
                                        }
                                        if (!bl11) {
                                            $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2 - lastByteCount$iv + true));
                                            n4 = -1;
                                            break block44;
                                        }
                                        break block50;
                                    }
                                    if (!UTF8Kt.isValidCodePoint(value$iv)) {
                                        UTF8Kt.malformedCodePoint(value$iv);
                                        throw new KotlinNothingValueException();
                                    }
                                    ch = (char)UTF8Kt.highSurrogate(value$iv);
                                    bl10 = false;
                                    if (cb.hasRemaining()) {
                                        cb.put(ch);
                                        bl9 = true;
                                    } else {
                                        bl9 = false;
                                    }
                                    if (!bl9) break block51;
                                    ch = (char)UTF8Kt.lowSurrogate(value$iv);
                                    bl10 = false;
                                    if (cb.hasRemaining()) {
                                        cb.put(ch);
                                        bl8 = true;
                                    } else {
                                        bl8 = false;
                                    }
                                    if (bl8) break block50;
                                }
                                $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2 - lastByteCount$iv + true));
                                n4 = -1;
                                break block44;
                            }
                            value$iv = 0;
                        } while (var32_54 < endExclusive$iv2);
                    }
                    void rc$iv$iv2 = endExclusive$iv2 - start$iv2;
                    $this$read$iv$iv.discardExact((int)rc$iv$iv2);
                    n4 = 0;
                }
                int rc = n4;
                input.setHeadPosition(chunk.getReadPosition());
                cb.flip();
                int writeSize = 0;
                writeSize = 1;
                if (cb.hasRemaining()) {
                    Output $this$writeWhileSize_u24default$iv = dst;
                    int initialSize$iv = 1;
                    boolean $i$f$writeWhileSize = false;
                    ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, initialSize$iv, null);
                    try {
                        int size$iv2 = 0;
                        while (true) {
                            void endExclusive$iv3;
                            void start$iv3;
                            ByteBuffer nioBuffer$iv2;
                            void $this$writeDirect$iv2;
                            io.ktor.utils.io.core.Buffer view = tail$iv;
                            boolean bl14 = false;
                            io.ktor.utils.io.core.Buffer endExclusive$iv2 = view;
                            int size$iv3 = writeSize;
                            boolean $i$f$writeDirect2 = false;
                            boolean bl7 = false;
                            void $this$write$iv$iv2 = $this$writeDirect$iv2;
                            $i$f$write = 0;
                            index$iv = false;
                            mask$iv = $this$write$iv$iv2.getLimit();
                            n5 = $this$write$iv$iv2.getWritePosition();
                            ByteBuffer memory$iv3 = $this$write$iv$iv2.getMemory-SK3TCg8();
                            $i$a$-write-IoBufferJVMKt$writeDirect$2$iv = false;
                            ByteBuffer to = nioBuffer$iv2 = Memory.slice-SK3TCg8(memory$iv3, (int)start$iv3, (int)(endExclusive$iv3 - start$iv3));
                            boolean bl15 = false;
                            CoderResult cr = $this$encodeUTF8.encode(cb, to, false);
                            if (cr.isUnmappable() || cr.isMalformed()) {
                                Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
                                CharsetJVMKt.throwExceptionWrapped(cr);
                            }
                            if (cr.isOverflow() && to.hasRemaining()) {
                                n = writeSize;
                                writeSize = n + 1;
                            } else {
                                writeSize = 1;
                            }
                            bl = nioBuffer$iv2.limit() == endExclusive$iv3 - start$iv3;
                            boolean bl16 = false;
                            boolean bl17 = false;
                            if (!bl) {
                                boolean bl18 = false;
                                String string = "Buffer's limit change is not allowed";
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            rc$iv$iv = nioBuffer$iv2.position();
                            $this$write$iv$iv2.commitWritten(rc$iv$iv);
                            int n9 = size$iv2 = cb.hasRemaining() ? writeSize : 0;
                            if (size$iv2 <= 0) {
                                break;
                            }
                            tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, size$iv2, tail$iv);
                        }
                    }
                    finally {
                        UnsafeKt.afterHeadWrite($this$writeWhileSize_u24default$iv, tail$iv);
                    }
                }
                if (rc <= 0) continue;
                readSize = rc;
                break;
            }
            cb.clear();
            cb.flip();
            int completeSize = 0;
            completeSize = 1;
            Output $this$writeWhileSize_u24default$iv = dst;
            int initialSize$iv = 1;
            boolean $i$f$writeWhileSize = false;
            ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, initialSize$iv, null);
            try {
                int size$iv4 = 0;
                while (true) {
                    void endExclusive$iv4;
                    void start$iv4;
                    ByteBuffer nioBuffer$iv3;
                    void $this$writeDirect$iv3;
                    io.ktor.utils.io.core.Buffer chunk = tail$iv;
                    boolean bl19 = false;
                    io.ktor.utils.io.core.Buffer view = chunk;
                    int size$iv5 = completeSize;
                    boolean $i$f$writeDirect3 = false;
                    boolean size$iv3 = false;
                    void $this$write$iv$iv3 = $this$writeDirect$iv3;
                    boolean $i$f$write3 = false;
                    boolean $this$write$iv$iv2 = false;
                    $i$f$write = $this$write$iv$iv3.getLimit();
                    rc$iv$iv = $this$write$iv$iv3.getWritePosition();
                    ByteBuffer memory$iv4 = $this$write$iv$iv3.getMemory-SK3TCg8();
                    $i$a$-write-IoBufferJVMKt$writeDirect$2$iv = false;
                    ByteBuffer to = nioBuffer$iv3 = Memory.slice-SK3TCg8(memory$iv4, (int)start$iv4, (int)(endExclusive$iv4 - start$iv4));
                    boolean bl20 = false;
                    CoderResult cr = $this$encodeUTF8.encode(cb, to, true);
                    if (cr.isMalformed() || cr.isUnmappable()) {
                        Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
                        CharsetJVMKt.throwExceptionWrapped(cr);
                    }
                    if (cr.isOverflow()) {
                        int n10 = completeSize;
                        completeSize = n10 + 1;
                    } else {
                        completeSize = 0;
                    }
                    boolean bl21 = nioBuffer$iv3.limit() == endExclusive$iv4 - start$iv4;
                    n = 0;
                    bl = false;
                    if (!bl21) {
                        boolean bl22 = false;
                        String string = "Buffer's limit change is not allowed";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    int rc$iv$iv3 = nioBuffer$iv3.position();
                    $this$write$iv$iv3.commitWritten(rc$iv$iv3);
                    size$iv4 = completeSize;
                    if (size$iv4 <= 0) {
                        break;
                    }
                    tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, size$iv4, tail$iv);
                }
            }
            finally {
                UnsafeKt.afterHeadWrite($this$writeWhileSize_u24default$iv, tail$iv);
            }
            boolean bl23 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
            boolean bl24 = false;
            boolean bl25 = false;
            if (!bl23) {
                boolean bl26 = false;
                String string = "Buffer's limit change is not allowed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            int rc$iv$iv4 = nioBuffer$iv.position();
            $this$write$iv$iv.commitWritten(rc$iv$iv4);
        }
        finally {
            tmp.release(ChunkBuffer.Companion.getPool());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean encodeComplete(@NotNull CharsetEncoder $this$encodeComplete, @NotNull io.ktor.utils.io.core.Buffer dst) {
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        void $this$writeDirect$iv;
        Intrinsics.checkNotNullParameter((Object)$this$encodeComplete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean completed = false;
        io.ktor.utils.io.core.Buffer buffer = dst;
        boolean size$iv = false;
        boolean $i$f$writeDirect = false;
        boolean bl = false;
        void $this$write$iv$iv = $this$writeDirect$iv;
        boolean $i$f$write = false;
        boolean bl2 = false;
        int n = $this$write$iv$iv.getLimit();
        int n2 = $this$write$iv$iv.getWritePosition();
        ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
        boolean bl3 = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl4 = false;
        CoderResult result = $this$encodeComplete.encode(EmptyCharBuffer, bb, true);
        if (result.isMalformed() || result.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            CharsetJVMKt.throwExceptionWrapped(result);
        }
        if (result.isUnderflow()) {
            completed = true;
        }
        boolean bl5 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl5) {
            boolean bl8 = false;
            String string = "Buffer's limit change is not allowed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$write$iv$iv.commitWritten(rc$iv$iv);
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final int decodeBuffer(@NotNull CharsetDecoder $this$decodeBuffer, @NotNull io.ktor.utils.io.core.Buffer input, @NotNull Appendable out2, boolean lastBuffer, int max) {
        int charactersCopied;
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeBuffer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out2, (String)"out");
        io.ktor.utils.io.core.Buffer $this$readDirect$iv = input;
        boolean $i$f$readDirect = false;
        boolean bl = false;
        io.ktor.utils.io.core.Buffer $this$read$iv$iv = $this$readDirect$iv;
        boolean $i$f$read = false;
        boolean bl2 = false;
        int n = $this$read$iv$iv.getWritePosition();
        int n2 = $this$read$iv$iv.getReadPosition();
        ByteBuffer memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
        boolean bl3 = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl4 = false;
        ChunkBuffer tmpBuffer = ChunkBuffer.Companion.getPool().borrow();
        CharBuffer charBuffer = tmpBuffer.getMemory-SK3TCg8().asCharBuffer();
        Intrinsics.checkNotNull((Object)charBuffer);
        CharBuffer cb = charBuffer;
        try {
            int partSize;
            for (charactersCopied = 0; bb.hasRemaining() && charactersCopied < max; charactersCopied += partSize) {
                int n3 = cb.capacity();
                int n4 = max - charactersCopied;
                boolean bl5 = false;
                partSize = Math.min(n3, n4);
                cb.clear();
                cb.limit(partSize);
                CoderResult result = $this$decodeBuffer.decode(bb, cb, lastBuffer);
                if (!result.isMalformed() && !result.isUnmappable()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
                CharsetJVMKt.throwExceptionWrapped(result);
            }
        }
        finally {
            tmpBuffer.release(ChunkBuffer.Companion.getPool());
        }
        boolean bl6 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl6) {
            boolean bl9 = false;
            String string = "Buffer's limit change is not allowed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$read$iv$iv.discardExact(rc$iv$iv);
        return charactersCopied;
    }

    public static /* synthetic */ int decodeBuffer$default(CharsetDecoder charsetDecoder, io.ktor.utils.io.core.Buffer buffer, Appendable appendable, boolean bl, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return CharsetJVMKt.decodeBuffer(charsetDecoder, buffer, appendable, bl, n);
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetDecoder $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        Charset charset = $this$charset.charset();
        Intrinsics.checkNotNull((Object)charset);
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final int decode(@NotNull CharsetDecoder $this$decode, @NotNull Input input, @NotNull Appendable dst, int max) {
        block22: {
            Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            copied = 0;
            cb = CharBuffer.allocate(8192);
            readSize = 0;
            readSize = 1;
            $this$takeWhileSize_u24default$iv = input;
            initialSize$iv = 1;
            $i$f$takeWhileSize = false;
            release$iv = true;
            var11_13 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, initialSize$iv);
            if (var11_13 == null) break block22;
            current$iv = var11_13;
            size$iv = initialSize$iv;
            try {
                do {
                    block24: {
                        block23: {
                            this_$iv$iv = current$iv;
                            $i$f$getReadRemaining = false;
                            before$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                            after$iv = 0;
                            if (before$iv >= size$iv) {
                                try {
                                    buffer = current$iv;
                                    $i$a$-takeWhileSize$default-CharsetJVMKt$decode$1 = false;
                                    rem = max - copied;
                                    if (rem == 0) {
                                        v0 = 0;
                                    } else {
                                        $this$readDirect$iv = buffer;
                                        $i$f$readDirect = false;
                                        var21_30 = false;
                                        $this$read$iv$iv = $this$readDirect$iv;
                                        $i$f$read = false;
                                        var23_32 = false;
                                        var24_33 = $this$read$iv$iv.getWritePosition();
                                        var25_34 = $this$read$iv$iv.getReadPosition();
                                        memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                                        $i$a$-read-IoBufferJVMKt$readDirect$2$iv = false;
                                        bb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                                        $i$a$-readDirect-CharsetJVMKt$decode$1$1 = false;
                                        cb.clear();
                                        if (rem < 8192) {
                                            cb.limit(rem);
                                        }
                                        rc = $this$decode.decode(bb, cb, false);
                                        cb.flip();
                                        copied += cb.remaining();
                                        dst.append(cb);
                                        if (rc.isMalformed() || rc.isUnmappable()) {
                                            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
                                            CharsetJVMKt.throwExceptionWrapped(rc);
                                        }
                                        if (rc.isUnderflow() && bb.hasRemaining()) {
                                            var32_41 = readSize;
                                            readSize = var32_41 + 1;
                                        } else {
                                            readSize = 1;
                                        }
                                        var33_42 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
                                        var34_43 = false;
                                        var35_44 = false;
                                        if (!var33_42) {
                                            $i$a$-check-IoBufferJVMKt$readDirect$2$1$iv = false;
                                            var35_45 = "Buffer's limit change is not allowed";
                                            throw (Throwable)new IllegalStateException(var35_45.toString());
                                        }
                                        rc$iv$iv = nioBuffer$iv.position();
                                        $this$read$iv$iv.discardExact(rc$iv$iv);
                                        v0 = readSize;
                                    }
                                    size$iv = v0;
                                }
                                finally {
                                    this_$iv$iv = current$iv;
                                    $i$f$getReadRemaining = false;
                                    after$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                                }
                            } else {
                                after$iv = before$iv;
                            }
                            release$iv = false;
                            if (after$iv != 0) break block23;
                            v1 = UnsafeKt.prepareReadNextHead($this$takeWhileSize_u24default$iv, current$iv);
                            break block24;
                        }
                        if (after$iv < size$iv) ** GOTO lbl-1000
                        this_$iv$iv = current$iv;
                        $i$f$getEndGap = false;
                        if (this_$iv$iv.getCapacity() - this_$iv$iv.getLimit() < 8) lbl-1000:
                        // 2 sources

                        {
                            UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                            v1 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, size$iv);
                        } else {
                            v1 = next$iv = current$iv;
                        }
                    }
                    if (next$iv == null) {
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                }
            }
        }
        do {
            cb.clear();
            rem = max - copied;
            if (rem == 0) break;
            if (rem < 8192) {
                cb.limit(rem);
            }
            cr = $this$decode.decode(CharsetJVMKt.EmptyByteBuffer, cb, true);
            cb.flip();
            copied += cb.remaining();
            dst.append(cb);
            if (!cr.isUnmappable() && !cr.isMalformed()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
            CharsetJVMKt.throwExceptionWrapped(cr);
        } while (cr.isOverflow());
        return copied;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decodeExactBytes(@NotNull CharsetDecoder $this$decodeExactBytes, @NotNull Input input, int inputLength) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeExactBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (inputLength == 0) {
            return "";
        }
        if (input instanceof AbstractInput) {
            AbstractInput this_$iv = (AbstractInput)input;
            boolean $i$f$getHeadRemaining = false;
            if (this_$iv.getHeadEndExclusive() - this_$iv.getHeadPosition() >= inputLength) {
                if (((AbstractInput)input).getHeadMemory-SK3TCg8().hasArray()) {
                    void charset$iv;
                    void offset$iv;
                    void bytes$iv;
                    ByteBuffer bb = ((AbstractInput)input).getHeadMemory-SK3TCg8();
                    byte[] byArray = bb.array();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bb.array()");
                    int n = bb.arrayOffset() + bb.position() + ((AbstractInput)input).getHead().getReadPosition();
                    Charset charset = $this$decodeExactBytes.charset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset()");
                    boolean $i$f$String = false;
                    String text = new String((byte[])bytes$iv, (int)offset$iv, inputLength, (Charset)charset$iv);
                    ((AbstractInput)input).discardExact(inputLength);
                    return text;
                }
                return CharsetJVMKt.decodeImplByteBuffer($this$decodeExactBytes, (AbstractInput)input, inputLength);
            }
        }
        return CharsetJVMKt.decodeImplSlow($this$decodeExactBytes, input, inputLength);
    }

    private static final String decodeImplByteBuffer(CharsetDecoder $this$decodeImplByteBuffer, AbstractInput input, int inputLength) {
        CharBuffer cb = CharBuffer.allocate(inputLength);
        ByteBuffer bb = Memory.slice-SK3TCg8(input.getHeadMemory-SK3TCg8(), input.getHead().getReadPosition(), inputLength);
        CoderResult rc = $this$decodeImplByteBuffer.decode(bb, cb, true);
        if (rc.isMalformed() || rc.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
            CharsetJVMKt.throwExceptionWrapped(rc);
        }
        cb.flip();
        input.discardExact(bb.position());
        String string = cb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cb.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final String decodeImplSlow(CharsetDecoder $this$decodeImplSlow, Input input, int inputLength) {
        block23: {
            cb = CharBuffer.allocate(inputLength);
            remainingInputBytes = 0;
            remainingInputBytes = inputLength;
            lastChunk = false;
            readSize = 0;
            readSize = 1;
            $this$takeWhileSize_u24default$iv = input;
            initialSize$iv = 1;
            $i$f$takeWhileSize = false;
            release$iv = true;
            var11_11 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, initialSize$iv);
            if (var11_11 == null) break block23;
            current$iv = var11_11;
            size$iv = initialSize$iv;
            try {
                do {
                    block25: {
                        block24: {
                            this_$iv$iv = current$iv;
                            $i$f$getReadRemaining = false;
                            before$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                            after$iv = 0;
                            if (before$iv >= size$iv) {
                                try {
                                    buffer = current$iv;
                                    $i$a$-takeWhileSize$default-CharsetJVMKt$decodeImplSlow$1 = false;
                                    if (!cb.hasRemaining() || remainingInputBytes == 0) {
                                        v0 = 0;
                                    } else {
                                        $this$readDirect$iv = buffer;
                                        $i$f$readDirect = false;
                                        var20_27 = false;
                                        $this$read$iv$iv = $this$readDirect$iv;
                                        $i$f$read = false;
                                        var22_29 = false;
                                        var23_30 = $this$read$iv$iv.getWritePosition();
                                        var24_31 = $this$read$iv$iv.getReadPosition();
                                        memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                                        $i$a$-read-IoBufferJVMKt$readDirect$2$iv = false;
                                        bb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                                        $i$a$-readDirect-CharsetJVMKt$decodeImplSlow$1$1 = false;
                                        limitBefore = bb.limit();
                                        v1 = lastChunk = limitBefore - (positionBefore = bb.position()) >= remainingInputBytes;
                                        if (lastChunk) {
                                            bb.limit(positionBefore + remainingInputBytes);
                                        }
                                        if ((rc = $this$decodeImplSlow.decode(bb, cb, lastChunk)).isMalformed() || rc.isUnmappable()) {
                                            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
                                            CharsetJVMKt.throwExceptionWrapped(rc);
                                        }
                                        if (rc.isUnderflow() && bb.hasRemaining()) {
                                            var33_40 = readSize;
                                            readSize = var33_40 + 1;
                                        } else {
                                            readSize = 1;
                                        }
                                        bb.limit(limitBefore);
                                        remainingInputBytes -= bb.position() - positionBefore;
                                        var34_41 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
                                        var35_42 = false;
                                        var36_43 = false;
                                        if (!var34_41) {
                                            $i$a$-check-IoBufferJVMKt$readDirect$2$1$iv = false;
                                            var36_44 = "Buffer's limit change is not allowed";
                                            throw (Throwable)new IllegalStateException(var36_44.toString());
                                        }
                                        rc$iv$iv = nioBuffer$iv.position();
                                        $this$read$iv$iv.discardExact(rc$iv$iv);
                                        v0 = readSize;
                                    }
                                    size$iv = v0;
                                }
                                finally {
                                    this_$iv$iv = current$iv;
                                    $i$f$getReadRemaining = false;
                                    after$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                                }
                            } else {
                                after$iv = before$iv;
                            }
                            release$iv = false;
                            if (after$iv != 0) break block24;
                            v2 = UnsafeKt.prepareReadNextHead($this$takeWhileSize_u24default$iv, current$iv);
                            break block25;
                        }
                        if (after$iv < size$iv) ** GOTO lbl-1000
                        this_$iv$iv = current$iv;
                        $i$f$getEndGap = false;
                        if (this_$iv$iv.getCapacity() - this_$iv$iv.getLimit() < 8) lbl-1000:
                        // 2 sources

                        {
                            UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                            v2 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, size$iv);
                        } else {
                            v2 = next$iv = current$iv;
                        }
                    }
                    if (next$iv == null) {
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                }
            }
        }
        if (cb.hasRemaining() && !lastChunk && ((rc = $this$decodeImplSlow.decode(CharsetJVMKt.EmptyByteBuffer, cb, true)).isMalformed() || rc.isUnmappable())) {
            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
            CharsetJVMKt.throwExceptionWrapped(rc);
        }
        if (remainingInputBytes > 0) {
            throw new EOFException("Not enough bytes available: had only " + (inputLength - remainingInputBytes) + " instead of " + inputLength);
        }
        if (remainingInputBytes < 0) {
            throw new AssertionError((Object)"remainingInputBytes < 0");
        }
        cb.flip();
        var7_7 = cb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)var7_7, (String)"cb.toString()");
        return var7_7;
    }

    private static final void throwExceptionWrapped(CoderResult $this$throwExceptionWrapped) {
        try {
            $this$throwExceptionWrapped.throwException();
        }
        catch (java.nio.charset.MalformedInputException original) {
            String string = original.getMessage();
            String string2 = string == null ? "Failed to decode bytes" : string;
            throw new MalformedInputException(string2);
        }
    }

    public static /* synthetic */ void Charset$annotations() {
    }

    static {
        Buffer buffer = CharBuffer.allocate(0);
        Intrinsics.checkNotNull((Object)buffer);
        EmptyCharBuffer = buffer;
        buffer = ByteBuffer.allocate(0);
        Intrinsics.checkNotNull((Object)buffer);
        EmptyByteBuffer = buffer;
    }
}

