/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.core.ByteBuffersKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.utils.AtomicKt;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u001a\u001e\u0010\u0007\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a*\u0010\r\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0001H\u0007\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003*\n\u0010\u0014\"\u00020\u00152\u00020\u0015\u00a8\u0006\u0016"}, d2={"PACKET_MAX_COPY_SIZE", "", "getPACKET_MAX_COPY_SIZE", "()I", "BytePacketBuilder", "Lio/ktor/utils/io/core/BytePacketBuilder;", "headerSizeHint", "readByteBuffer", "Ljava/nio/ByteBuffer;", "Lio/ktor/utils/io/core/ByteReadPacket;", "n", "direct", "", "readText", "decoder", "Ljava/nio/charset/CharsetDecoder;", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "max", "EOFException", "Ljava/io/EOFException;", "ktor-io"})
public final class PacketJVMKt {
    private static final int PACKET_MAX_COPY_SIZE = AtomicKt.getIOIntProperty("max.copy.size", 500);

    public static final int getPACKET_MAX_COPY_SIZE() {
        return PACKET_MAX_COPY_SIZE;
    }

    @NotNull
    public static final BytePacketBuilder BytePacketBuilder(int headerSizeHint) {
        return new BytePacketBuilder(headerSizeHint, ChunkBuffer.Companion.getPool());
    }

    public static /* synthetic */ BytePacketBuilder BytePacketBuilder$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return PacketJVMKt.BytePacketBuilder(n);
    }

    @NotNull
    public static final ByteBuffer readByteBuffer(@NotNull ByteReadPacket $this$readByteBuffer, int n, boolean direct) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2;
        Intrinsics.checkNotNullParameter((Object)$this$readByteBuffer, (String)"<this>");
        if (direct) {
            byteBuffer2 = ByteBuffer.allocateDirect(n);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocateDirect(n)");
            byteBuffer = byteBuffer2;
        } else {
            byteBuffer2 = ByteBuffer.allocate(n);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocate(n)");
            byteBuffer = byteBuffer2;
        }
        ByteBuffer bb = byteBuffer;
        ByteBuffersKt.readFully($this$readByteBuffer, bb);
        bb.clear();
        return bb;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ ByteBuffer readByteBuffer$default(ByteReadPacket byteReadPacket, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            void $this$coerceAtMostMaxIntOrFail$iv;
            long l = byteReadPacket.getRemaining();
            String message$iv = "Unable to make a ByteBuffer: packet is too big";
            boolean $i$f$coerceAtMostMaxIntOrFail = false;
            if ($this$coerceAtMostMaxIntOrFail$iv > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(message$iv);
            }
            n = (int)$this$coerceAtMostMaxIntOrFail$iv;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return PacketJVMKt.readByteBuffer(byteReadPacket, n, bl);
    }

    @Deprecated(message="Migrate parameters order", replaceWith=@ReplaceWith(expression="readText(out, decoder, max)", imports={}), level=DeprecationLevel.ERROR)
    public static final int readText(@NotNull ByteReadPacket $this$readText, @NotNull CharsetDecoder decoder, @NotNull Appendable out2, int max) {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)out2, (String)"out");
        return CharsetJVMKt.decode(decoder, $this$readText, out2, max);
    }

    public static /* synthetic */ int readText$default(ByteReadPacket byteReadPacket, CharsetDecoder charsetDecoder, Appendable appendable, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return PacketJVMKt.readText(byteReadPacket, charsetDecoder, appendable, n);
    }
}

