/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.internal;

import io.ktor.utils.io.ByteBufferChannel;
import io.ktor.utils.io.WriterSuspendSession;
import io.ktor.utils.io.core.BufferUtilsJvmKt;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.internal.JoiningState;
import io.ktor.utils.io.internal.RingBufferCapacity;
import io.ktor.utils.io.internal.WriteSessionImpl;
import java.nio.ByteBuffer;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0001\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0019\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lio/ktor/utils/io/internal/WriteSessionImpl;", "Lio/ktor/utils/io/WriterSuspendSession;", "channel", "Lio/ktor/utils/io/ByteBufferChannel;", "(Lio/ktor/utils/io/ByteBufferChannel;)V", "byteBuffer", "Ljava/nio/ByteBuffer;", "current", "locked", "", "ringBufferCapacity", "Lio/ktor/utils/io/internal/RingBufferCapacity;", "view", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "begin", "", "complete", "flush", "request", "min", "tryAwait", "n", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryAwaitJoinSwitch", "written", "writtenFailed", "", "ktor-io"})
public final class WriteSessionImpl
implements WriterSuspendSession {
    private int locked;
    @NotNull
    private ByteBufferChannel current;
    @NotNull
    private ByteBuffer byteBuffer;
    @NotNull
    private ChunkBuffer view;
    @NotNull
    private RingBufferCapacity ringBufferCapacity;

    public WriteSessionImpl(@NotNull ByteBufferChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.current = channel.resolveChannelInstance$ktor_io();
        this.byteBuffer = ChunkBuffer.Companion.getEmpty().getMemory-SK3TCg8();
        this.view = ChunkBuffer.Companion.getEmpty();
        this.ringBufferCapacity = this.current.currentState$ktor_io().capacity;
    }

    public final void begin() {
        this.current = this.current.resolveChannelInstance$ktor_io();
        ByteBuffer byteBuffer = this.current.setupStateForWrite$ktor_io();
        if (byteBuffer == null) {
            return;
        }
        this.byteBuffer = byteBuffer;
        this.view = BufferUtilsJvmKt.ChunkBuffer$default(this.current.currentState$ktor_io().backingBuffer, null, 2, null);
        BufferUtilsJvmKt.resetFromContentToWrite(this.view, this.byteBuffer);
        this.ringBufferCapacity = this.current.currentState$ktor_io().capacity;
    }

    public final void complete() {
        if (this.locked > 0) {
            this.ringBufferCapacity.completeRead(this.locked);
            this.locked = 0;
        }
        this.current.restoreStateAfterWrite$ktor_io();
        this.current.tryTerminate$ktor_io();
    }

    @Override
    @Nullable
    public ChunkBuffer request(int min) {
        this.locked += this.ringBufferCapacity.tryWriteAtLeast(0);
        if (this.locked < min) {
            return null;
        }
        this.current.prepareWriteBuffer$ktor_io(this.byteBuffer, this.locked);
        if (this.byteBuffer.remaining() < min) {
            return null;
        }
        BufferUtilsJvmKt.resetFromContentToWrite(this.view, this.byteBuffer);
        return this.view;
    }

    @Override
    public void written(int n) {
        if (n < 0 || n > this.locked) {
            this.writtenFailed(n);
            throw new KotlinNothingValueException();
        }
        this.locked -= n;
        this.current.bytesWrittenFromSession$ktor_io(this.byteBuffer, this.ringBufferCapacity, n);
    }

    private final Void writtenFailed(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Written bytes count shouldn't be negative: " + n);
        }
        throw new IllegalStateException("Unable to mark " + n + " bytes as written: only " + this.locked + " were pre-locked.");
    }

    @Override
    @Nullable
    public Object tryAwait(int n, @NotNull Continuation<? super Unit> $completion) {
        JoiningState joining = this.current.getJoining$ktor_io();
        if (joining != null) {
            Object object = this.tryAwaitJoinSwitch(n, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (this.locked >= n) {
            return Unit.INSTANCE;
        }
        if (this.locked > 0) {
            this.ringBufferCapacity.completeRead(this.locked);
            this.locked = 0;
        }
        Object object = this.current.tryWriteSuspend$ktor_io(n, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object tryAwaitJoinSwitch(int var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof tryAwaitJoinSwitch.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ WriteSessionImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WriteSessionImpl.access$tryAwaitJoinSwitch(this.this$0, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.locked > 0) {
                    this.ringBufferCapacity.completeRead(this.locked);
                    this.locked = 0;
                }
                this.flush();
                this.current.restoreStateAfterWrite$ktor_io();
                this.current.tryTerminate$ktor_io();
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.current.tryWriteSuspend$ktor_io((int)n, (Continuation<? super Unit>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                this = (WriteSessionImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                this.current = this.current.resolveChannelInstance$ktor_io();
                v1 = this.current.setupStateForWrite$ktor_io();
                if (v1 != null) {
                    this.byteBuffer = v1;
                    this.view = BufferUtilsJvmKt.ChunkBuffer$default(this.current.currentState$ktor_io().backingBuffer, null, 2, null);
                    BufferUtilsJvmKt.resetFromContentToWrite(this.view, this.byteBuffer);
                    this.ringBufferCapacity = this.current.currentState$ktor_io().capacity;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void flush() {
        this.current.flush();
    }

    public static final /* synthetic */ Object access$tryAwaitJoinSwitch(WriteSessionImpl $this, int n, Continuation $completion) {
        return $this.tryAwaitJoinSwitch(n, (Continuation<? super Unit>)$completion);
    }
}

