/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.charsets;

import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.internal.CharArraySequence;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.core.internal.UnsafeKt;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u001a*\u0010\b\u001a\u00020\u0011*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\u00122\b\b\u0002\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u001a0\u0010\u0013\u001a\u00020\u0007*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0014H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u0007*\u00060\nj\u0002`\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a0\u0010\u0016\u001a\u00020\u0007*\u00060\nj\u0002`\u000b2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u0018\u001a\u00020\u0011*\u00060\nj\u0002`\u000b2\u0006\u0010\u0004\u001a\u00020\u0011\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0005H\u0000\u00a8\u0006\u001b"}, d2={"decode", "", "Ljava/nio/charset/CharsetDecoder;", "Lio/ktor/utils/io/charsets/CharsetDecoder;", "input", "Lio/ktor/utils/io/core/Input;", "max", "", "encode", "", "Ljava/nio/charset/CharsetEncoder;", "Lio/ktor/utils/io/charsets/CharsetEncoder;", "", "fromIndex", "toIndex", "dst", "Lio/ktor/utils/io/core/Output;", "Lio/ktor/utils/io/core/ByteReadPacket;", "", "encodeArrayImpl", "Lio/ktor/utils/io/core/Buffer;", "encodeCompleteImpl", "encodeToImpl", "destination", "encodeUTF8", "sizeEstimate", "", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encoding.kt\nio/ktor/utils/io/charsets/EncodingKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Output.kt\nio/ktor/utils/io/core/OutputKt\n+ 4 Buffer.kt\nio/ktor/utils/io/core/Buffer\n*L\n1#1,183:1\n12#2,11:184\n12#2,11:195\n507#3,13:206\n488#3,4:219\n492#3,6:225\n507#3,6:231\n513#3,7:239\n74#4:223\n74#4:224\n74#4:237\n74#4:238\n*S KotlinDebug\n*F\n+ 1 Encoding.kt\nio/ktor/utils/io/charsets/EncodingKt\n*L\n42#1:184,11\n46#1:195,11\n55#1:206,13\n140#1:219,4\n140#1:225,6\n166#1:231,6\n166#1:239,7\n141#1:223\n147#1:224\n167#1:237\n171#1:238\n*E\n"})
public final class EncodingKt {
    @NotNull
    public static final ByteReadPacket encode(@NotNull CharsetEncoder $this$encode, @NotNull CharSequence input, int fromIndex, int toIndex) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$encode_u24lambda_u240 = builder$iv;
            boolean bl = false;
            EncodingKt.encodeToImpl($this$encode, $this$encode_u24lambda_u240, input, fromIndex, toIndex);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    public static /* synthetic */ ByteReadPacket encode$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return EncodingKt.encode(charsetEncoder, charSequence, n, n2);
    }

    @NotNull
    public static final ByteReadPacket encodeUTF8(@NotNull CharsetEncoder $this$encodeUTF8, @NotNull ByteReadPacket input) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$encodeUTF8, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$encodeUTF8_u24lambda_u241 = builder$iv;
            boolean bl = false;
            CharsetJVMKt.encodeUTF8($this$encodeUTF8, input, $this$encodeUTF8_u24lambda_u241);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void encode(@NotNull CharsetEncoder $this$encode, @NotNull char[] input, int fromIndex, int toIndex, @NotNull Output dst) {
        void $this$writeWhileSize$iv;
        Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int start = 0;
        start = fromIndex;
        if (start >= toIndex) {
            return;
        }
        Output output = dst;
        int initialSize$iv = 1;
        boolean $i$f$writeWhileSize = false;
        ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead((Output)$this$writeWhileSize$iv, initialSize$iv, null);
        try {
            int size$iv = 0;
            while (true) {
                Buffer view = tail$iv;
                boolean bl = false;
                int rc = EncodingKt.encodeArrayImpl($this$encode, input, start, toIndex, view);
                if (!(rc >= 0)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                size$iv = (start += rc) >= toIndex ? 0 : (rc == 0 ? 8 : 1);
                if (size$iv > 0) {
                    tail$iv = UnsafeKt.prepareWriteHead((Output)$this$writeWhileSize$iv, size$iv, tail$iv);
                    continue;
                }
                break;
            }
        }
        finally {
            $this$writeWhileSize$iv.afterHeadWrite();
        }
        EncodingKt.encodeCompleteImpl($this$encode, dst);
    }

    @NotNull
    public static final String decode(@NotNull CharsetDecoder $this$decode, @NotNull Input input, int max) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int n = (int)Math.min((long)max, EncodingKt.sizeEstimate(input));
        StringBuilder $this$decode_u24lambda_u243 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        CharsetJVMKt.decode($this$decode, input, $this$decode_u24lambda_u243, max);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String decode$default(CharsetDecoder charsetDecoder, Input input, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return EncodingKt.decode(charsetDecoder, input, n);
    }

    public static final int encodeArrayImpl(@NotNull CharsetEncoder $this$encodeArrayImpl, @NotNull char[] input, int fromIndex, int toIndex, @NotNull Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeArrayImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int length = toIndex - fromIndex;
        return CharsetJVMKt.encodeImpl($this$encodeArrayImpl, new CharArraySequence(input, fromIndex, length), 0, length, dst);
    }

    public static final long sizeEstimate(@NotNull Input $this$sizeEstimate) {
        Intrinsics.checkNotNullParameter((Object)$this$sizeEstimate, (String)"<this>");
        return $this$sizeEstimate instanceof ByteReadPacket ? $this$sizeEstimate.getRemaining() : Math.max($this$sizeEstimate.getRemaining(), 16L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int encodeCompleteImpl(CharsetEncoder $this$encodeCompleteImpl, Output dst) {
        int size = 0;
        size = 1;
        int bytesWritten = 0;
        Output $this$writeWhile$iv = dst;
        boolean $i$f$writeWhile = false;
        ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhile$iv, 1, null);
        try {
            while (true) {
                Buffer view = tail$iv;
                boolean bl = false;
                Buffer this_$iv = view;
                boolean $i$f$getWriteRemaining = false;
                int before = this_$iv.getLimit() - this_$iv.getWritePosition();
                size = CharsetJVMKt.encodeComplete($this$encodeCompleteImpl, view) ? 0 : ++size;
                this_$iv = view;
                $i$f$getWriteRemaining = false;
                bytesWritten += before - (this_$iv.getLimit() - this_$iv.getWritePosition());
                if (size > 0) {
                    tail$iv = UnsafeKt.prepareWriteHead($this$writeWhile$iv, 1, tail$iv);
                    continue;
                }
                break;
            }
        }
        finally {
            $this$writeWhile$iv.afterHeadWrite();
        }
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final int encodeToImpl(@NotNull CharsetEncoder $this$encodeToImpl, @NotNull Output destination, @NotNull CharSequence input, int fromIndex, int toIndex) {
        void $this$writeWhileSize$iv;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int start = 0;
        start = fromIndex;
        if (start >= toIndex) {
            return 0;
        }
        int bytesWritten = 0;
        Output output = destination;
        int initialSize$iv = 1;
        boolean $i$f$writeWhileSize = false;
        ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead((Output)$this$writeWhileSize$iv, initialSize$iv, null);
        try {
            int size$iv = 0;
            while (true) {
                Buffer view = tail$iv;
                boolean bl = false;
                Buffer this_$iv = view;
                boolean $i$f$getWriteRemaining = false;
                int before = this_$iv.getLimit() - this_$iv.getWritePosition();
                int rc = CharsetJVMKt.encodeImpl($this$encodeToImpl, input, start, toIndex, view);
                if (!(rc >= 0)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Buffer this_$iv2 = view;
                boolean $i$f$getWriteRemaining2 = false;
                bytesWritten += before - (this_$iv2.getLimit() - this_$iv2.getWritePosition());
                size$iv = (start += rc) >= toIndex ? 0 : (rc == 0 ? 8 : 1);
                if (size$iv > 0) {
                    tail$iv = UnsafeKt.prepareWriteHead((Output)$this$writeWhileSize$iv, size$iv, tail$iv);
                    continue;
                }
                break;
            }
        }
        finally {
            $this$writeWhileSize$iv.afterHeadWrite();
        }
        return bytesWritten += EncodingKt.encodeCompleteImpl($this$encodeToImpl, destination);
    }
}

