/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.bits.MemoryJvmKt;
import io.ktor.utils.io.core.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a8\u0006\t"}, d2={"writeBufferAppend", "", "Lio/ktor/utils/io/core/Buffer;", "other", "maxSize", "writeBufferAppendUnreserve", "", "writeSize", "writeBufferPrepend", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nBufferAppend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferAppend.kt\nio/ktor/utils/io/core/BufferAppendKt\n+ 2 Buffer.kt\nio/ktor/utils/io/core/Buffer\n+ 3 Buffer.kt\nio/ktor/utils/io/core/BufferKt\n*L\n1#1,61:1\n69#2:62\n74#2:63\n69#2:78\n74#2:79\n59#2:80\n390#3,5:64\n372#3,7:69\n395#3,2:76\n*S KotlinDebug\n*F\n+ 1 BufferAppend.kt\nio/ktor/utils/io/core/BufferAppendKt\n*L\n12#1:62\n14#1:63\n34#1:78\n51#1:79\n51#1:80\n18#1:64,5\n19#1:69,7\n18#1:76,2\n*E\n"})
public final class BufferAppendKt {
    /*
     * WARNING - void declaration
     */
    public static final int writeBufferAppend(@NotNull Buffer $this$writeBufferAppend, @NotNull Buffer other, int maxSize) {
        void dstOffset;
        void srcOffset;
        Intrinsics.checkNotNullParameter((Object)$this$writeBufferAppend, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Buffer this_$iv = other;
        boolean $i$f$getReadRemaining = false;
        int size = Math.min(this_$iv.getWritePosition() - this_$iv.getReadPosition(), maxSize);
        this_$iv = $this$writeBufferAppend;
        boolean $i$f$getWriteRemaining = false;
        if (this_$iv.getLimit() - this_$iv.getWritePosition() <= size) {
            BufferAppendKt.writeBufferAppendUnreserve($this$writeBufferAppend, size);
        }
        Buffer $this$write$iv = $this$writeBufferAppend;
        boolean $i$f$write = false;
        ByteBuffer byteBuffer = $this$write$iv.getMemory();
        int n = $this$write$iv.getWritePosition();
        $this$write$iv.getLimit();
        int n2 = n;
        ByteBuffer dst = byteBuffer;
        boolean bl = false;
        Buffer $this$read$iv = other;
        boolean $i$f$read = false;
        ByteBuffer byteBuffer2 = $this$read$iv.getMemory();
        int n3 = $this$read$iv.getReadPosition();
        $this$read$iv.getWritePosition();
        int n4 = n3;
        ByteBuffer src = byteBuffer2;
        boolean bl2 = false;
        MemoryJvmKt.copyTo(src, dst, (int)srcOffset, size, (int)dstOffset);
        int rc$iv = size;
        $this$read$iv.discardExact(rc$iv);
        int rc$iv2 = rc$iv;
        $this$write$iv.commitWritten(rc$iv2);
        return rc$iv2;
    }

    public static final int writeBufferPrepend(@NotNull Buffer $this$writeBufferPrepend, @NotNull Buffer other) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBufferPrepend, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Buffer this_$iv = other;
        boolean $i$f$getReadRemaining = false;
        int size = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        int readPosition = $this$writeBufferPrepend.getReadPosition();
        if (readPosition < size) {
            throw new IllegalArgumentException("Not enough space in the beginning to prepend bytes");
        }
        int newReadPosition = readPosition - size;
        MemoryJvmKt.copyTo(other.getMemory(), $this$writeBufferPrepend.getMemory(), other.getReadPosition(), size, newReadPosition);
        other.discardExact(size);
        $this$writeBufferPrepend.releaseStartGap$ktor_io(newReadPosition);
        return size;
    }

    private static final void writeBufferAppendUnreserve(Buffer $this$writeBufferAppendUnreserve, int writeSize) {
        Buffer this_$iv = $this$writeBufferAppendUnreserve;
        boolean $i$f$getWriteRemaining = false;
        int n = this_$iv.getLimit() - this_$iv.getWritePosition();
        this_$iv = $this$writeBufferAppendUnreserve;
        boolean $i$f$getEndGap = false;
        if (n + (this_$iv.getCapacity() - this_$iv.getLimit()) < writeSize) {
            throw new IllegalArgumentException("Can't append buffer: not enough free space at the end");
        }
        int newWritePosition = $this$writeBufferAppendUnreserve.getWritePosition() + writeSize;
        int overrunSize = newWritePosition - $this$writeBufferAppendUnreserve.getLimit();
        if (overrunSize > 0) {
            $this$writeBufferAppendUnreserve.releaseEndGap$ktor_io();
        }
    }
}

