/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core.internal;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a1\u0010\b\u001a\u00020\u0006*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\t\u001a)\u0010\n\u001a\u00020\u0006*\u00060\u0000j\u0002`\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lkotlinx/io/Buffer;", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "", "min", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "", "block", "writeDirect", "(Lkotlinx/io/Buffer;ILkotlin/jvm/functions/Function1;)V", "readDirect", "(Lkotlinx/io/Buffer;Lkotlin/jvm/functions/Function1;)V", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nChunkBufferJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkBufferJvm.kt\nio/ktor/utils/io/core/internal/ChunkBufferJvmKt\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n166#2,28:33\n88#2:61\n89#2,7:63\n1#3:62\n*S KotlinDebug\n*F\n+ 1 ChunkBufferJvm.kt\nio/ktor/utils/io/core/internal/ChunkBufferJvmKt\n*L\n14#1:33,28\n24#1:61\n24#1:63,7\n24#1:62\n*E\n"})
public final class ChunkBufferJvmKt {
    /*
     * WARNING - void declaration
     */
    public static final void writeDirect(@NotNull Buffer $this$writeDirect, int min, @NotNull Function1<? super ByteBuffer, Unit> block) {
        void endIndex;
        void startIndex;
        Intrinsics.checkNotNullParameter((Object)$this$writeDirect, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer$iv = $this$writeDirect.getBuffer();
        boolean $i$f$writeToTail = false;
        Segment tail$iv = buffer$iv.writableSegment(min);
        byte[] data$iv = tail$iv.dataAsByteArray(false);
        int n = data$iv.length;
        int n2 = tail$iv.getLimit();
        byte[] array = data$iv;
        boolean bl = false;
        ByteBuffer buffer = ByteBuffer.wrap(array, (int)startIndex, (int)(endIndex - startIndex));
        Intrinsics.checkNotNull((Object)buffer);
        block.invoke((Object)buffer);
        int bytesWritten$iv = buffer.position() - startIndex;
        if (bytesWritten$iv == min) {
            tail$iv.writeBackData(data$iv, bytesWritten$iv);
            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
            buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
        } else {
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl2 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
            } else if (SegmentKt.isEmpty((Segment)tail$iv)) {
                buffer$iv.recycleTail();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void readDirect(@NotNull Buffer $this$readDirect, @NotNull Function1<? super ByteBuffer, Unit> block) {
        int consumed;
        void endExclusive;
        void start;
        Intrinsics.checkNotNullParameter((Object)$this$readDirect, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer$iv = $this$readDirect.getBuffer();
        boolean $i$f$readFromHead = false;
        if (!(!buffer$iv.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
        }
        Segment segment = buffer$iv.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head$iv = segment;
        int n = head$iv.getLimit();
        int n2 = head$iv.getPos();
        byte[] array = head$iv.dataAsByteArray(true);
        boolean bl = false;
        ByteBuffer wrap = ByteBuffer.wrap(array, (int)start, (int)(endExclusive - start));
        Intrinsics.checkNotNull((Object)wrap);
        block.invoke((Object)wrap);
        int bytesRead$iv = consumed = wrap.position() - start;
        if (bytesRead$iv < 0) {
            throw new IllegalStateException("Returned negative read bytes count");
        }
        if (bytesRead$iv != 0) {
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer$iv.skip((long)bytesRead$iv);
        }
    }
}

